/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.selectors.inject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.stianloader.micromixin.transform.api.InjectionPointConstraint;
import org.stianloader.micromixin.transform.api.InjectionPointSelector;
import org.stianloader.micromixin.transform.api.InjectionPointSelectorFactory;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.api.SlicedInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;

public class ReturnInjectionPointSelector
extends InjectionPointSelector
implements InjectionPointSelectorFactory.InjectionPointSelectorProvider {
    @NotNull
    public static final ReturnInjectionPointSelector INSTANCE = new ReturnInjectionPointSelector();

    private ReturnInjectionPointSelector() {
        super("org.spongepowered.asm.mixin.injection.points.BeforeReturn", "RETURN");
    }

    @Override
    @Nullable
    public AbstractInsnNode getFirstInsn(@NotNull MethodNode method, @Nullable SlicedInjectionPointSelector from, @Nullable SlicedInjectionPointSelector to, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        AbstractInsnNode insn;
        AbstractInsnNode guard;
        AbstractInsnNode abstractInsnNode = guard = to == null ? method.instructions.getLast() : to.getFirstInsn(method, remapper, sharedBuilder);
        for (insn = from == null ? method.instructions.getFirst() : from.getFirstInsn(method, remapper, sharedBuilder); insn != null; insn = insn.getNext()) {
            if (ASMUtil.isReturn(insn.getOpcode())) {
                return insn;
            }
            if (insn == guard) break;
        }
        if (insn == null) {
            throw new IllegalStateException("Exhausted instruction list before hitting the last instruction in the slice. This likely points to an invalidly programmed selector as well as insufficent slice validation.");
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends AbstractInsnNode> getMatchedInstructions(@NotNull MethodNode method, @Nullable SlicedInjectionPointSelector from, @Nullable SlicedInjectionPointSelector to, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        AbstractInsnNode insn;
        AbstractInsnNode guard;
        ArrayList<AbstractInsnNode> matched = new ArrayList<AbstractInsnNode>();
        AbstractInsnNode abstractInsnNode = guard = to == null ? method.instructions.getLast() : to.getFirstInsn(method, remapper, sharedBuilder);
        for (insn = from == null ? method.instructions.getFirst() : from.getFirstInsn(method, remapper, sharedBuilder); insn != null; insn = insn.getNext()) {
            if (ASMUtil.isReturn(insn.getOpcode())) {
                matched.add(insn);
            }
            if (insn == guard) break;
        }
        if (insn == null) {
            throw new IllegalStateException("Exhausted instruction list before hitting the last instruction in the slice. This likely points to an invalidly programmed selector as well as insufficent slice validation.");
        }
        return matched;
    }

    @Override
    public boolean supportsRedirect() {
        return false;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @NotNull
    public Set<String> getAllNames() {
        return this.allNames;
    }

    @Override
    @NotNull
    @ApiStatus.AvailableSince(value="0.7.0-a20241008")
    @Contract(pure=true)
    public InjectionPointSelector create(@Nullable List<String> args, @NotNull InjectionPointConstraint[] constraints) {
        if (constraints.length != 0) {
            throw new MixinParseException("Broken mixin: Superfluous discriminator found in @At(\"" + this.getFullyQualifiedName() + "\"). Usage of the 'target' or 'desc' constraints is not applicable to the CONSTANT injection point.");
        }
        if (args != null) {
            throw new MixinParseException("Broken mixin: Superfluous discriminator found in @At(\"" + this.getFullyQualifiedName() + "\"). Usage of the 'args' constraints is not applicable to the " + this.getFullyQualifiedName() + " injection point.");
        }
        return this;
    }
}

