/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeAnnotationNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.stianloader.micromixin.transform.api.MixinTransformer;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.api.SlicedInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.HandlerContextHelper;
import org.stianloader.micromixin.transform.internal.MixinMethodStub;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.MixinStub;
import org.stianloader.micromixin.transform.internal.annotation.MixinAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinAtAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinDescAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinSliceAnnotation;
import org.stianloader.micromixin.transform.internal.selectors.DescSelector;
import org.stianloader.micromixin.transform.internal.selectors.MixinTargetSelector;
import org.stianloader.micromixin.transform.internal.selectors.StringSelector;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;
import org.stianloader.micromixin.transform.internal.util.CodeCopyUtil;
import org.stianloader.micromixin.transform.internal.util.DescString;
import org.stianloader.micromixin.transform.internal.util.Objects;
import org.stianloader.micromixin.transform.internal.util.PrintUtils;
import org.stianloader.micromixin.transform.internal.util.commenttable.CommentTable;
import org.stianloader.micromixin.transform.internal.util.commenttable.KeyValueTableSection;
import org.stianloader.micromixin.transform.internal.util.commenttable.StringTableSection;
import org.stianloader.micromixin.transform.internal.util.locals.LocalCaptureResult;
import org.stianloader.micromixin.transform.internal.util.locals.LocalsCapture;

public final class MixinInjectAnnotation
extends MixinAnnotation<MixinMethodStub> {
    private final int allow;
    @NotNull
    public final Collection<SlicedInjectionPointSelector> at;
    @NotNull
    public final Collection<MixinTargetSelector> selectors;
    @NotNull
    private final MethodNode injectSource;
    private final int require;
    private final int expect;
    private final boolean cancellable;
    private final boolean denyVoids;
    @NotNull
    private final String locals;
    @NotNull
    private final MixinTransformer<?> transformer;

    private MixinInjectAnnotation(@NotNull Collection<SlicedInjectionPointSelector> at, @NotNull Collection<MixinTargetSelector> selectors, @NotNull MethodNode injectSource, int require, int expect, int allow, boolean cancellable, boolean denyVoids, @NotNull String locals, @NotNull MixinTransformer<?> transformer) {
        this.at = at;
        this.selectors = selectors;
        this.injectSource = injectSource;
        this.require = require;
        this.expect = expect;
        this.allow = allow;
        this.cancellable = cancellable;
        this.denyVoids = denyVoids;
        this.locals = locals;
        this.transformer = transformer;
    }

    @NotNull
    public static MixinInjectAnnotation parse(@NotNull ClassNode node, @NotNull MethodNode method, @NotNull AnnotationNode annot, @NotNull MixinTransformer<?> transformer, @NotNull StringBuilder sharedBuilder) throws MixinParseException {
        if ((method.access & 8) != 0 && (method.access & 2) == 0) {
            throw new MixinParseException("The injector handler method " + node.name + "." + method.name + method.desc + " is static, but isn't private. Consider making the method private.");
        }
        ArrayList<MixinAtAnnotation> at = new ArrayList<MixinAtAnnotation>();
        ArrayList<MixinSliceAnnotation> slice = new ArrayList<MixinSliceAnnotation>();
        Collection<MixinDescAnnotation> target = null;
        String[] targetSelectors = null;
        int require = -1;
        int expect = -1;
        int allow = -1;
        boolean cancellable = false;
        boolean denyVoids = "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;".equals(ASMUtil.getLastType(method.desc));
        String locals = null;
        for (int i = 0; i < annot.values.size(); i += 2) {
            List atValues;
            String name = (String)annot.values.get(i);
            Object val = annot.values.get(i + 1);
            if (name.equals("at")) {
                atValues = (List)val;
                for (AnnotationNode atValue : atValues) {
                    if (atValue == null) {
                        throw new NullPointerException();
                    }
                    try {
                        at.add(MixinAtAnnotation.parse(node, atValue, transformer.getInjectionPointSelectors()));
                    }
                    catch (MixinParseException mpe) {
                        throw new MixinParseException("Unable to parse @At annotation defined by " + node.name + "." + method.name + method.desc, mpe);
                    }
                }
                continue;
            }
            if (name.equals("target")) {
                if (target != null) {
                    throw new MixinParseException("Duplicate \"target\" field in @Inject.");
                }
                target = new ArrayList();
                atValues = (List)val;
                for (AnnotationNode atValue : atValues) {
                    if (atValue == null) {
                        throw new NullPointerException();
                    }
                    MixinDescAnnotation parsed = MixinDescAnnotation.parse(node, atValue);
                    target.add(parsed);
                }
                target = Collections.unmodifiableCollection(target);
                continue;
            }
            if (name.equals("method")) {
                String[] hack;
                if (targetSelectors != null) {
                    throw new MixinParseException("Duplicate \"method\" field in @Inject.");
                }
                targetSelectors = hack = ((List)val).toArray(new String[0]);
                continue;
            }
            if (name.equals("require")) {
                require = (Integer)val;
                continue;
            }
            if (name.equals("expect")) {
                expect = (Integer)val;
                continue;
            }
            if (name.equals("allow")) {
                allow = (Integer)val;
                continue;
            }
            if (name.equals("cancellable")) {
                cancellable = (Boolean)val;
                continue;
            }
            if (name.equals("locals")) {
                locals = ((String[])val)[1];
                continue;
            }
            if (name.equals("slice")) {
                List sliceValues = (List)val;
                for (AnnotationNode sliceValue : sliceValues) {
                    if (sliceValue == null) {
                        throw new NullPointerException();
                    }
                    try {
                        slice.add(MixinSliceAnnotation.parse(node, sliceValue, transformer.getInjectionPointSelectors()));
                    }
                    catch (MixinParseException mpe) {
                        throw new MixinParseException("Unable to parse @Slice annotation defined by " + node.name + "." + method.name + method.desc, mpe);
                    }
                }
                continue;
            }
            throw new MixinParseException("Unimplemented key in @Inject: " + name);
        }
        ArrayList<MixinTargetSelector> selectors = new ArrayList<MixinTargetSelector>();
        if (target != null) {
            for (MixinDescAnnotation desc : target) {
                selectors.add(new DescSelector(Objects.requireNonNull(desc)));
            }
        }
        if (targetSelectors != null) {
            for (void var19_27 : targetSelectors) {
                selectors.add(new StringSelector((String)Objects.requireNonNull(var19_27)));
            }
        }
        if (selectors.isEmpty()) {
            throw new MixinParseException("No available selectors: Mixin " + node.name + "." + method.name + method.desc + " does not match anything and is not a valid mixin. Did you forget to specify 'method' or 'target'?");
        }
        if (locals == null) {
            locals = "NO_CAPTURE";
        }
        if (allow < require) {
            allow = -1;
        }
        Collection<SlicedInjectionPointSelector> slicedAts = Collections.unmodifiableCollection(MixinAtAnnotation.bake(at, slice));
        return new MixinInjectAnnotation(slicedAts, Collections.unmodifiableCollection(selectors), method, require, expect, allow, cancellable, denyVoids, locals, transformer);
    }

    @Override
    public void apply(@NotNull ClassNode to, @NotNull HandlerContextHelper hctx, @NotNull MixinStub sourceStub, @NotNull MixinMethodStub source, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        MethodNode handlerNode = CodeCopyUtil.copyHandler(this.injectSource, sourceStub, to, remapper, hctx.lineAllocator, this.transformer.getLogger());
        HashMap<AbstractInsnNode, MethodNode> matched = new HashMap<AbstractInsnNode, MethodNode>();
        for (MixinTargetSelector mixinTargetSelector : this.selectors) {
            for (SlicedInjectionPointSelector at : this.at) {
                MethodNode targetMethod = mixinTargetSelector.selectMethod(to, sourceStub);
                if (targetMethod == null) continue;
                if (targetMethod.name.equals("<init>") && !at.supportsInstanceCaptureInConstructors() && (this.injectSource.access & 8) == 0) {
                    throw new IllegalStateException("Illegal mixin: " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " targets " + to.name + ".<init>" + targetMethod.desc + ", which is a constructor. The handler method is non-static and the selector @At(\"" + at.getQualifiedSelectorName() + "\") does not support non-static handlers when targetting constructors.");
                }
                if (this.denyVoids && targetMethod.desc.codePointBefore(targetMethod.desc.length()) == 86) {
                    throw new IllegalStateException("Illegal mixin: " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " targets " + to.name + "." + targetMethod.name + "V, which is a void method. The injector however has a CallbackInfoReturnable, which suggests a non-void type as the target's return type. This issue is caused due to the following selector (Make sure to set the return type accordingly!): " + mixinTargetSelector);
                }
                if ((targetMethod.access & 8) != 0) {
                    if ((this.injectSource.access & 8) == 0) {
                        throw new IllegalStateException("Illegal mixin: " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " targets " + to.name + "." + targetMethod.name + targetMethod.desc + " target is static, but the mixin is not.");
                    }
                    if ((this.injectSource.access & 1) != 0) {
                        throw new IllegalStateException("Illegal mixin: " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " targets " + to.name + "." + targetMethod.name + targetMethod.desc + " target is static, but the mixin is public. A mixin may not be static and public at the same time for whatever odd reasons.");
                    }
                }
                ArrayDeque<String> path = new ArrayDeque<String>();
                path.add(sourceStub.sourceNode.name);
                path.add(source.getName() + source.getDesc());
                at.verifySlices(Collections.asLifoQueue(path), targetMethod, remapper, sharedBuilder);
                for (AbstractInsnNode abstractInsnNode : at.getMatchedInstructions(targetMethod, remapper, sharedBuilder)) {
                    if (abstractInsnNode.getOpcode() == -1) {
                        throw new IllegalStateException("Selector " + at + " matched virtual instruction " + abstractInsnNode.getClass() + ". Declaring mixin " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " targets " + to.name + "." + targetMethod.name + targetMethod.desc);
                    }
                    matched.put(abstractInsnNode, targetMethod);
                }
            }
        }
        if (matched.size() < this.require) {
            throw new IllegalStateException("Illegal mixin: " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " requires " + this.require + " injection points but only found " + matched.size() + ".");
        }
        if (matched.size() < this.expect) {
            this.transformer.getLogger().warn(MixinInjectAnnotation.class, "Potentially outdated mixin: {}.{} {} expects {} injection points but only found {}.", sourceStub.sourceNode.name, this.injectSource.name, this.injectSource.desc, this.expect, matched.size());
        }
        if (this.allow > 0 && matched.size() > this.allow) {
            throw new IllegalStateException("Illegal mixin: " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " allows up to " + this.allow + " injection points but " + matched.size() + " injection points were selected.");
        }
        for (Map.Entry entry : matched.entrySet()) {
            AbstractInsnNode insn = (AbstractInsnNode)entry.getKey();
            MethodNode method = (MethodNode)entry.getValue();
            int returnType = method.desc.codePointAt(method.desc.lastIndexOf(41) + 1);
            boolean category2 = ASMUtil.isCategory2(returnType);
            InsnList insnList = new InsnList();
            if (this.captureLocalsEarly(sourceStub.sourceNode, to, method, insn, sharedBuilder)) continue;
            if (category2) {
                int storedType;
                int returnOpcode = ASMUtil.getReturnOpcode(returnType);
                int lvt0 = MixinInjectAnnotation.scanNextFreeLVTIndex(method);
                if (insn.getOpcode() != returnOpcode) {
                    insnList.add((AbstractInsnNode)new InsnNode(1));
                    storedType = 76;
                } else {
                    insnList.add((AbstractInsnNode)new InsnNode(92));
                    storedType = returnType;
                }
                int storeOpcode = ASMUtil.getStoreOpcode(storedType);
                int loadOpcode = ASMUtil.getLoadOpcode(storedType);
                insnList.add((AbstractInsnNode)new VarInsnNode(storeOpcode, lvt0));
                insnList.add((AbstractInsnNode)new TypeInsnNode(187, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable"));
                insnList.add((AbstractInsnNode)new InsnNode(89));
                insnList.add((AbstractInsnNode)new LdcInsnNode((Object)method.name));
                insnList.add((AbstractInsnNode)new InsnNode(this.cancellable ? 4 : 3));
                insnList.add((AbstractInsnNode)new VarInsnNode(loadOpcode, lvt0));
                String ctorDesc = storeOpcode == 58 ? "(Ljava/lang/String;ZLjava/lang/Object;)V" : "(Ljava/lang/String;Z" + (char)storedType + ")V";
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable", "<init>", ctorDesc));
                insnList.add((AbstractInsnNode)new InsnNode(89));
                if ((handlerNode.access & 8) != 0) {
                    this.captureArguments(sourceStub, insnList, to, method);
                    this.captureLocals(sourceStub.sourceNode, to, method, insnList, insn, sharedBuilder);
                    insnList.add((AbstractInsnNode)new MethodInsnNode(184, to.name, handlerNode.name, handlerNode.desc));
                } else {
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insnList.add((AbstractInsnNode)new InsnNode(95));
                    this.captureArguments(sourceStub, insnList, to, method);
                    this.captureLocals(sourceStub.sourceNode, to, method, insnList, insn, sharedBuilder);
                    insnList.add((AbstractInsnNode)new MethodInsnNode(182, to.name, handlerNode.name, handlerNode.desc));
                }
                insnList.add((AbstractInsnNode)new InsnNode(ASMUtil.popReturn(handlerNode.desc)));
                if (this.cancellable) {
                    insnList.add((AbstractInsnNode)new InsnNode(89));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(182, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable", "isCancelled", "()Z"));
                    LabelNode skipReturn = new LabelNode();
                    insnList.add((AbstractInsnNode)new JumpInsnNode(153, skipReturn));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(182, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable", "getReturnValue" + (char)returnType, "()" + (char)returnType));
                    insnList.add((AbstractInsnNode)new InsnNode(returnOpcode));
                    insnList.add((AbstractInsnNode)skipReturn);
                }
                insnList.add((AbstractInsnNode)new InsnNode(87));
            } else if (returnType != 86) {
                int storedType;
                int returnOpcode = ASMUtil.getReturnOpcode(returnType);
                if (insn.getOpcode() != returnOpcode) {
                    insnList.add((AbstractInsnNode)new InsnNode(1));
                    storedType = 76;
                } else {
                    insnList.add((AbstractInsnNode)new InsnNode(89));
                    storedType = returnType;
                }
                insnList.add((AbstractInsnNode)new TypeInsnNode(187, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable"));
                insnList.add((AbstractInsnNode)new InsnNode(92));
                insnList.add((AbstractInsnNode)new InsnNode(95));
                insnList.add((AbstractInsnNode)new LdcInsnNode((Object)method.name));
                insnList.add((AbstractInsnNode)new InsnNode(95));
                insnList.add((AbstractInsnNode)new InsnNode(this.cancellable ? 4 : 3));
                insnList.add((AbstractInsnNode)new InsnNode(95));
                String ctorDesc = storedType == 76 || storedType == 91 ? "(Ljava/lang/String;ZLjava/lang/Object;)V" : "(Ljava/lang/String;Z" + (char)storedType + ")V";
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable", "<init>", ctorDesc));
                insnList.add((AbstractInsnNode)new InsnNode(89));
                if ((handlerNode.access & 8) != 0) {
                    this.captureArguments(sourceStub, insnList, to, method);
                    this.captureLocals(sourceStub.sourceNode, to, method, insnList, insn, sharedBuilder);
                    insnList.add((AbstractInsnNode)new MethodInsnNode(184, to.name, handlerNode.name, handlerNode.desc));
                } else {
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insnList.add((AbstractInsnNode)new InsnNode(95));
                    this.captureArguments(sourceStub, insnList, to, method);
                    this.captureLocals(sourceStub.sourceNode, to, method, insnList, insn, sharedBuilder);
                    insnList.add((AbstractInsnNode)new MethodInsnNode(182, to.name, handlerNode.name, handlerNode.desc));
                }
                insnList.add((AbstractInsnNode)new InsnNode(ASMUtil.popReturn(handlerNode.desc)));
                if (this.cancellable) {
                    insnList.add((AbstractInsnNode)new InsnNode(89));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(182, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable", "isCancelled", "()Z"));
                    LabelNode skipReturn = new LabelNode();
                    insnList.add((AbstractInsnNode)new JumpInsnNode(153, skipReturn));
                    if (returnOpcode == 176) {
                        insnList.add((AbstractInsnNode)new MethodInsnNode(182, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable", "getReturnValue", "()Ljava/lang/Object;"));
                        String castDesc = returnType == 91 ? method.desc.substring(method.desc.lastIndexOf(41) + 1, method.desc.length()) : method.desc.substring(method.desc.lastIndexOf(41) + 2, method.desc.length() - 1);
                        insnList.add((AbstractInsnNode)new TypeInsnNode(192, castDesc));
                    } else {
                        insnList.add((AbstractInsnNode)new MethodInsnNode(182, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable", "getReturnValue" + (char)returnType, "()" + (char)returnType));
                    }
                    insnList.add((AbstractInsnNode)new InsnNode(returnOpcode));
                    insnList.add((AbstractInsnNode)skipReturn);
                }
                insnList.add((AbstractInsnNode)new InsnNode(88));
            } else if ((handlerNode.access & 8) != 0) {
                insnList.add((AbstractInsnNode)new TypeInsnNode(187, "org/spongepowered/asm/mixin/injection/callback/CallbackInfo"));
                insnList.add((AbstractInsnNode)new InsnNode(89));
                if (this.cancellable) {
                    insnList.add((AbstractInsnNode)new InsnNode(89));
                }
                insnList.add((AbstractInsnNode)new LdcInsnNode((Object)method.name));
                insnList.add((AbstractInsnNode)new InsnNode(this.cancellable ? 4 : 3));
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "org/spongepowered/asm/mixin/injection/callback/CallbackInfo", "<init>", "(Ljava/lang/String;Z)V"));
                this.captureArguments(sourceStub, insnList, to, method);
                this.captureLocals(sourceStub.sourceNode, to, method, insnList, insn, sharedBuilder);
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, to.name, handlerNode.name, handlerNode.desc));
                insnList.add((AbstractInsnNode)new InsnNode(ASMUtil.popReturn(handlerNode.desc)));
                if (this.cancellable) {
                    insnList.add((AbstractInsnNode)new MethodInsnNode(182, "org/spongepowered/asm/mixin/injection/callback/CallbackInfo", "isCancelled", "()Z"));
                    LabelNode skipReturn = new LabelNode();
                    insnList.add((AbstractInsnNode)new JumpInsnNode(153, skipReturn));
                    insnList.add((AbstractInsnNode)new InsnNode(177));
                    insnList.add((AbstractInsnNode)skipReturn);
                }
            } else {
                int idx = MixinInjectAnnotation.getCallbackInfoIndex(method, this.cancellable);
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList.add((AbstractInsnNode)new VarInsnNode(25, idx));
                this.captureArguments(sourceStub, insnList, to, method);
                this.captureLocals(sourceStub.sourceNode, to, method, insnList, insn, sharedBuilder);
                insnList.add((AbstractInsnNode)new MethodInsnNode(182, to.name, handlerNode.name, handlerNode.desc));
                insnList.add((AbstractInsnNode)new InsnNode(ASMUtil.popReturn(handlerNode.desc)));
                if (this.cancellable) {
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, idx));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(182, "org/spongepowered/asm/mixin/injection/callback/CallbackInfo", "isCancelled", "()Z"));
                    LabelNode skipReturn = new LabelNode();
                    insnList.add((AbstractInsnNode)new JumpInsnNode(153, skipReturn));
                    insnList.add((AbstractInsnNode)new InsnNode(177));
                    insnList.add((AbstractInsnNode)skipReturn);
                }
            }
            method.instructions.insertBefore(insn, insnList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureLocals(@NotNull ClassNode handlerOwner, @NotNull ClassNode targetClass, @NotNull MethodNode target, @NotNull InsnList out, AbstractInsnNode inspectionTarget, @NotNull StringBuilder sharedBuilder) {
        if (this.locals.equals("NO_CAPTURE")) {
            return;
        }
        LocalCaptureResult result = LocalsCapture.captureLocals(targetClass, target, Objects.requireNonNull(inspectionTarget), this.transformer.getPool());
        int initialFrameSize = ASMUtil.getInitialFrameSize(target);
        Frame<BasicValue> frame = result.frame;
        ArrayList<String> requestedLocals = new ArrayList<String>();
        String errorMessage = null;
        if (frame == null) {
            errorMessage = "Handler " + handlerOwner.name + "." + this.injectSource.name + this.injectSource.desc + " targets an unreachable instruction in " + targetClass.name + "." + target.name + target.desc;
        } else {
            String desc;
            String desc2;
            int maxLocals = frame.getLocals();
            DescString requesterDesc = new DescString(this.injectSource.desc);
            while (requesterDesc.hasNext() && !"Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;".equals(desc2 = requesterDesc.nextType()) && !"Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;".equals(desc2)) {
            }
            while (requesterDesc.hasNext()) {
                requestedLocals.add(requesterDesc.nextType());
            }
            ArrayList<String> providedLocals = new ArrayList<String>();
            for (int i = initialFrameSize; i < maxLocals; ++i) {
                BasicValue local = (BasicValue)frame.getLocal(i);
                Type localType = local.getType();
                if (localType == null) {
                    StringWriter sw = new StringWriter();
                    InsnNode hackInstruction = new InsnNode(0);
                    hackInstruction.invisibleTypeAnnotations = new ArrayList();
                    hackInstruction.invisibleTypeAnnotations.add(new TypeAnnotationNode(65, null, "Lorg/stianloader/micromixin/internal/MixinInjectAnnotationTraceLabel;"));
                    try {
                        target.instructions.insertBefore(inspectionTarget, (AbstractInsnNode)hackInstruction);
                        TraceMethodVisitor tmv = new TraceMethodVisitor((Printer)new Textifier());
                        target.accept((MethodVisitor)tmv);
                        tmv.p.print(new PrintWriter(sw));
                    }
                    finally {
                        target.instructions.remove((AbstractInsnNode)hackInstruction);
                    }
                    throw new AssertionError((Object)("localType == null, for i = " + i + "; initialFrameSize = " + initialFrameSize + "; maxLocals = " + maxLocals + "; frame[i] = " + local + "; frame = " + frame + "; frame[i].class= " + local.getClass() + "; frame[i].size = " + local.getSize() + "; target = " + targetClass.name + "." + target.name + target.desc + "; source = " + handlerOwner.name + "." + this.injectSource.name + this.injectSource.desc + "; ats = {" + this.at + "}; targetCode = \n" + sw.toString()));
                }
                desc = localType.getDescriptor();
                providedLocals.add(desc);
                if (!ASMUtil.isCategory2(desc.codePointAt(0))) continue;
                ++i;
            }
            int requestedCount = requestedLocals.size();
            if (requestedCount < providedLocals.size()) {
                errorMessage = "Handler " + handlerOwner.name + "." + this.injectSource.name + this.injectSource.desc + " whishes to capture more locals than " + targetClass.name + "." + target.name + target.desc + " can provide. Provided: " + providedLocals + ", Requested: " + requestedLocals + ".";
            } else {
                int localIndex = initialFrameSize;
                for (int i = 0; i < requestedCount; ++i) {
                    desc = (String)requestedLocals.get(i);
                    if (!desc.equals(providedLocals.get(i))) {
                        errorMessage = "Handler " + handlerOwner.name + "." + this.injectSource.name + this.injectSource.desc + " attempts to capture different locals than those supplied by " + targetClass.name + "." + target.name + target.desc + ". Provided: " + providedLocals + ", Requested: " + requestedLocals + ".";
                        break;
                    }
                    int type = desc.codePointAt(0);
                    out.add((AbstractInsnNode)new VarInsnNode(ASMUtil.getLoadOpcode(type), localIndex));
                    if (ASMUtil.isCategory2(type)) {
                        localIndex += 2;
                        continue;
                    }
                    ++localIndex;
                }
            }
        }
        if (this.locals.equals("CAPTURE_FAILHARD")) {
            if (errorMessage != null) {
                throw new Error(errorMessage);
            }
        } else {
            throw new IllegalStateException("Unsupported local capture flag: \"" + this.locals + "\"");
        }
    }

    private boolean captureLocalsEarly(@NotNull ClassNode handlerOwner, @NotNull ClassNode targetClass, @NotNull MethodNode target, AbstractInsnNode inspectionTarget, @NotNull StringBuilder sharedBuilder) {
        if (this.locals.equals("NO_CAPTURE") || this.locals.equals("CAPTURE_FAILHARD")) {
            return false;
        }
        LocalCaptureResult result = LocalsCapture.captureLocals(targetClass, target, Objects.requireNonNull(inspectionTarget), this.transformer.getPool());
        if (this.locals.equals("PRINT")) {
            String maxLocals;
            KeyValueTableSection injectionPointInfo = new KeyValueTableSection();
            CommentTable printTable = new CommentTable().addSection(injectionPointInfo);
            injectionPointInfo.add("Target Class", targetClass.name.replace('/', '.'));
            sharedBuilder.setLength(0);
            PrintUtils.fastPrettyMethodName(target.name, target.desc, target.access, sharedBuilder);
            injectionPointInfo.add("Target Method", sharedBuilder.toString());
            Throwable error = result.error;
            Frame<BasicValue> frame = result.frame;
            int initialFrameSize = ASMUtil.getInitialFrameSize(target);
            if (error != null) {
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("A fatal error has occured while analyzing the target method: ");
                lines.add("");
                lines.add("");
                StringWriter writer = new StringWriter();
                error.printStackTrace(new PrintWriter(writer));
                for (String line : writer.getBuffer().toString().split("[\\n\\r]")) {
                    lines.add(line);
                }
                printTable.addSection(new StringTableSection(lines));
                maxLocals = "???";
            } else if (frame == null) {
                printTable.addSection(new StringTableSection(Collections.singletonList("Error: The desired injection point is not reachable. Local capture is not possible")));
                maxLocals = "???";
            } else {
                maxLocals = Integer.toString(frame.getLocals());
                printTable.addSection(result.asLocalPrintTable(sharedBuilder));
                printTable.addSection(new StringTableSection(PrintUtils.getExpectedCallbackSignature(this.injectSource, target, frame, sharedBuilder)));
            }
            injectionPointInfo.add("Target Max LOCALS", maxLocals);
            injectionPointInfo.add("Initial Frame Size", Integer.toString(initialFrameSize));
            injectionPointInfo.add("Callback Name", this.injectSource.name);
            injectionPointInfo.add("Instruction", "<not implemented>");
            System.err.println(printTable);
            return true;
        }
        throw new IllegalStateException("Unsupported local capture flag: \"" + this.locals + "\"");
    }

    private static int searchCallbackInfoIndex(@NotNull MethodNode method, boolean cancellable) {
        if (method.desc.codePointBefore(method.desc.length()) != 86) {
            throw new AssertionError((Object)("Method called for a non-void method descriptor: " + method.desc + " (" + method.name + method.desc + "). Non-void methods should use CIR instead of CI, which shouldn't be cached."));
        }
        for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() == -1) continue;
            if (insn.getOpcode() != 187) {
                return -1;
            }
            TypeInsnNode typeInsn = (TypeInsnNode)insn;
            if (!typeInsn.desc.equals("org/spongepowered/asm/mixin/injection/callback/CallbackInfo") || (insn = insn.getNext()).getOpcode() != 89 || (insn = insn.getNext()).getOpcode() != 18 || ((LdcInsnNode)insn).cst.equals(method.name)) {
                return -1;
            }
            AbstractInsnNode cancellableFlag = insn.getNext();
            if (cancellableFlag.getOpcode() != 3 && cancellableFlag.getOpcode() != 4) {
                return -1;
            }
            if (cancellable) {
                if (cancellableFlag.getOpcode() == 3) {
                    insn = cancellableFlag.getNext();
                    if (insn.getOpcode() == 183 && (insn = insn.getNext()).getOpcode() == 58) continue;
                    return -1;
                }
                if (cancellableFlag.getOpcode() != 4) {
                    return -1;
                }
            } else {
                if (cancellableFlag.getOpcode() == 4) {
                    insn = cancellableFlag.getNext();
                    if (insn.getOpcode() == 183 && (insn = insn.getNext()).getOpcode() == 58) continue;
                    return -1;
                }
                if (cancellableFlag.getOpcode() != 3) {
                    return -1;
                }
            }
            if ((insn = cancellableFlag.getNext()).getOpcode() != 183 || (insn = insn.getNext()).getOpcode() != 58) {
                return -1;
            }
            return ((VarInsnNode)insn).var;
        }
        return -1;
    }

    private static int scanNextFreeLVTIndex(@NotNull MethodNode method) {
        int currentUsed = 0;
        if ((method.access & 8) == 0) {
            ++currentUsed;
        }
        DescString dstring = new DescString(method.desc);
        while (dstring.hasNext()) {
            if (ASMUtil.isCategory2(dstring.nextReferenceType())) {
                currentUsed += 2;
                continue;
            }
            ++currentUsed;
        }
        for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getType() != 2) continue;
            int idx = ((VarInsnNode)insn).var;
            if (insn.getOpcode() == 57 || insn.getOpcode() == 55) {
                ++idx;
            }
            currentUsed = Math.max(currentUsed, idx);
        }
        return ++currentUsed;
    }

    private static int getCallbackInfoIndex(@NotNull MethodNode method, boolean cancellable) {
        int preallocated = MixinInjectAnnotation.searchCallbackInfoIndex(method, cancellable);
        if (preallocated != -1) {
            return preallocated;
        }
        int index = MixinInjectAnnotation.scanNextFreeLVTIndex(method);
        InsnList injected = new InsnList();
        injected.add((AbstractInsnNode)new TypeInsnNode(187, "org/spongepowered/asm/mixin/injection/callback/CallbackInfo"));
        injected.add((AbstractInsnNode)new InsnNode(89));
        injected.add((AbstractInsnNode)new LdcInsnNode((Object)method.name));
        injected.add((AbstractInsnNode)new InsnNode(cancellable ? 4 : 3));
        injected.add((AbstractInsnNode)new MethodInsnNode(183, "org/spongepowered/asm/mixin/injection/callback/CallbackInfo", "<init>", "(Ljava/lang/String;Z)V"));
        injected.add((AbstractInsnNode)new VarInsnNode(58, index));
        method.instructions.insert(injected);
        return index;
    }

    @Override
    public void collectMappings(@NotNull MixinMethodStub source, @NotNull HandlerContextHelper hctx, @NotNull ClassNode target, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        remapper.remapMethod(source.getOwner().name, source.getDesc(), source.getName(), hctx.generateUniqueLocalPrefix() + source.getName());
    }

    private void captureArguments(@NotNull MixinStub sourceStub, @NotNull InsnList output, @NotNull ClassNode targetClass, @NotNull MethodNode targetMethod) {
        String handlerType;
        DescString handlerDesc = new DescString(this.injectSource.desc);
        DescString targetDesc = new DescString(targetMethod.desc);
        int lvtIndex = 0;
        if ((targetMethod.access & 8) == 0) {
            ++lvtIndex;
        }
        while (handlerDesc.hasNext() && targetDesc.hasNext()) {
            handlerType = handlerDesc.nextType();
            if (handlerType.equals("Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;") || handlerType.equals("Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;")) {
                if (!this.injectSource.desc.startsWith("(Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;)") && !this.injectSource.desc.startsWith("(Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;)")) break;
                return;
            }
            String targetType = targetDesc.nextType();
            if (!handlerType.equals(targetType)) {
                throw new IllegalStateException("Handler method " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " injects into " + targetClass.name + "." + targetMethod.name + targetMethod.desc + ", however " + "the target method defines different arguments than the source method is capturing. The first mismatched argument: \"" + handlerType + "\" defined by the handler where as \"" + targetType + "\" is defined by the target.");
            }
            int refType = targetType.codePointAt(0);
            output.add((AbstractInsnNode)new VarInsnNode(ASMUtil.getLoadOpcode(refType), lvtIndex));
            if (ASMUtil.isCategory2(refType)) {
                output.add((AbstractInsnNode)new InsnNode(93));
                output.add((AbstractInsnNode)new InsnNode(88));
                lvtIndex += 2;
                continue;
            }
            output.add((AbstractInsnNode)new InsnNode(95));
            ++lvtIndex;
        }
        if (targetDesc.hasNext()) {
            throw new IllegalStateException("Handler method " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " injects into " + targetClass.name + "." + targetMethod.name + targetMethod.desc + ", however " + "the target method has more arguments than the source method is capturing.");
        }
        if (handlerDesc.hasNext()) {
            handlerType = handlerDesc.nextType();
            if (handlerType.equals("Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;") || handlerType.equals("Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;")) {
                return;
            }
            throw new IllegalStateException("Handler method " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " injects into " + targetClass.name + "." + targetMethod.name + targetMethod.desc + ", however " + "the target method has less arguments than the source method is wishing to capture. The first extraneous argument is of type: " + handlerType);
        }
        throw new IllegalStateException("Handler method " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " must have a CallbackInfo or a CallbackInfoReturnable in it's arguments. But it does not.");
    }
}

