/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.util.locals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.stianloader.micromixin.transform.internal.MixinMethodStub;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;
import org.stianloader.micromixin.transform.internal.util.DescString;

public class ArgumentCaptureContext {
    @NotNull
    private static final ArgumentCaptureContext NO_CAPTURES = new ArgumentCaptureContext(Collections.<CapturedArgument>emptyList());
    @NotNull
    private final List<CapturedArgument> capturedArguments;

    private static boolean captureLocals(@Nullable List<AnnotationNode> annotations) {
        if (annotations == null) {
            return false;
        }
        for (AnnotationNode annotationNode : annotations) {
            if (!annotationNode.desc.startsWith("Lcom/llamalad7/mixinextras/")) continue;
            if (annotationNode.desc.equals("Lcom/llamalad7/mixinextras/sugar/Local;")) {
                return true;
            }
            throw new MixinParseException("Unknown/Unimplemented annotation: " + annotationNode.desc);
        }
        return false;
    }

    @NotNull
    public static ArgumentType getType(List<AnnotationNode>[] invisibileParameterAnnotations, int argumentIndex) {
        if (invisibileParameterAnnotations == null) {
            return ArgumentType.NORMAL_ARGUMENT;
        }
        List<AnnotationNode> annotations = invisibileParameterAnnotations[argumentIndex];
        if (annotations == null) {
            return ArgumentType.NORMAL_ARGUMENT;
        }
        for (AnnotationNode annotationNode : annotations) {
            if (!annotationNode.desc.startsWith("Lcom/llamalad7/mixinextras/")) continue;
            if (annotationNode.desc.equals("Lcom/llamalad7/mixinextras/sugar/Cancellable;")) {
                return ArgumentType.CANCELLABLE;
            }
            throw new MixinParseException("Unknown/Unimplemented annotation: " + annotationNode.desc);
        }
        return ArgumentType.NORMAL_ARGUMENT;
    }

    @NotNull
    public static ArgumentCaptureContext parseModifyHandler(@NotNull ClassNode owner, @NotNull MethodNode mixinSource, @NotNull String annotationName) {
        DescString dString = new DescString(mixinSource.desc);
        List[] parameterAnnotations = mixinSource.invisibleParameterAnnotations;
        if (parameterAnnotations != null && ArgumentCaptureContext.captureLocals(parameterAnnotations[0])) {
            throw new MixinParseException("The provided modify handler " + owner.name + "." + mixinSource.name + mixinSource.desc + " has an incompatible annotation on the original (or captured) argument that needs to be modified. Note that the first parameter of a modifier handler is ineligible for argument capture when using @" + annotationName);
        }
        if (!dString.hasNext()) {
            throw new MixinParseException("The modifier method " + owner.name + "." + mixinSource.name + mixinSource.desc + " is annotated with @" + annotationName + " but it does not consume the original return value. Modify handlers may not be no-args methods!");
        }
        String returnType = dString.nextType();
        if (!ASMUtil.getReturnType(mixinSource.desc).equals(returnType)) {
            throw new MixinParseException("The modifier method " + owner.name + "." + mixinSource.name + mixinSource.desc + " is annotated with @" + annotationName + " but has an invalid descriptor! Modify handlers must return the same type as they consume - irrespective of class hierarchy.");
        }
        if (!dString.hasNext()) {
            return NO_CAPTURES;
        }
        int offset = 0;
        ArrayList<CapturedArgument> arguments = new ArrayList<CapturedArgument>();
        while (dString.hasNext()) {
            if (parameterAnnotations != null && ArgumentCaptureContext.captureLocals(parameterAnnotations[offset + 1])) {
                throw new MixinParseException("The @" + annotationName + "-annotated modifier method " + owner.name + "." + mixinSource.name + mixinSource.desc + " uses @Local to capture local variables, but this feature is not yet supported.");
            }
            String type = dString.nextType();
            arguments.add(new CapturedArgument(offset++, type));
            if (!ASMUtil.isCategory2(type.codePointAt(0))) continue;
            ++offset;
        }
        return new ArgumentCaptureContext(Collections.unmodifiableList(arguments));
    }

    private ArgumentCaptureContext(@NotNull List<CapturedArgument> arguments) {
        this.capturedArguments = arguments;
    }

    public void appendCaptures(@NotNull ClassNode targetNode, @NotNull MethodNode targetMethod, @NotNull MixinMethodStub sourceStub, @NotNull AbstractInsnNode selectedInjectionPointInsn, @NotNull InsnList output) {
        if (this.capturedArguments.isEmpty()) {
            return;
        }
        ArrayList<String> availableLocals = new ArrayList<String>();
        DescString dString = new DescString(targetMethod.desc);
        while (dString.hasNext()) {
            String arg = dString.nextType();
            availableLocals.add(arg);
            if (!ASMUtil.isCategory2(arg.codePointAt(0))) continue;
            availableLocals.add(null);
        }
        int localOffset = (targetMethod.access & 8) == 0 ? 1 : 0;
        for (CapturedArgument captureArg : this.capturedArguments) {
            if (!captureArg.capturedType.equals(availableLocals.get(captureArg.captureOffset))) {
                throw new IllegalStateException("Unable to capture argument: Descriptor mismatch: Captured argument tries to capture an " + captureArg.capturedType + " at offset " + captureArg.captureOffset + ", but instead there is a " + (String)availableLocals.get(captureArg.captureOffset) + " at this place. Failed mixin stub: " + sourceStub.getOwner().name + "." + sourceStub.getName() + sourceStub.getDesc() + " targets " + targetNode.name + "." + targetMethod.name + targetMethod.desc);
            }
            output.add((AbstractInsnNode)new VarInsnNode(ASMUtil.getLoadOpcode(captureArg.capturedType.codePointAt(0)), localOffset + captureArg.captureOffset));
        }
    }

    private static final class CapturedArgument {
        @NotNull
        private final String capturedType;
        private final int captureOffset;

        public CapturedArgument(int offset, @NotNull String capturedType) {
            this.captureOffset = offset;
            this.capturedType = capturedType;
        }
    }

    public static enum ArgumentType {
        CANCELLABLE,
        NORMAL_ARGUMENT;

    }
}

