/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;

public class PrintUtils {
    private PrintUtils() {
        throw new AssertionError();
    }

    public static final void fastPrettyArguments(@NotNull String desc, @NotNull StringBuilder out) {
        if (desc.codePointAt(1) == 41) {
            out.append("()");
            return;
        }
        out.append('(');
        int index = 1 + PrintUtils.fastPrettySingleDesc(desc, 1, out);
        out.append(" arg0");
        int endIndex = desc.lastIndexOf(41);
        int i = 1;
        while (index != endIndex) {
            out.append(", ");
            index += PrintUtils.fastPrettySingleDesc(desc, index, out);
            out.append(" arg");
            out.append(i);
            ++i;
        }
        out.append(')');
    }

    @Contract(mutates="param4", pure=false, value="null, _, _, _ -> fail; _, null, _, _ -> fail; _, _, _, null -> fail; !null, !null, _, !null -> param4")
    @NotNull
    public static final StringBuilder fastPrettyMethodName(@NotNull String name, @NotNull String methodDesc, int access, @NotNull StringBuilder out) {
        PrintUtils.stringifyAccessMethod(access &= 0xFFFFFFF7, out);
        out.append(' ');
        PrintUtils.fastPrettySingleDesc(methodDesc, methodDesc.lastIndexOf(41) + 1, out);
        out.append(' ');
        out.append(name);
        PrintUtils.fastPrettyArguments(methodDesc, out);
        return out;
    }

    @NotNull
    public static final String prettyBracketedInt(int value, int maxValue, @NotNull StringBuilder sharedBuilder) {
        sharedBuilder.setLength(0);
        sharedBuilder.append('[');
        String string = Integer.toString(value);
        String maxString = Integer.toString(maxValue);
        int count = maxString.length() - string.length();
        while (count-- != 0) {
            sharedBuilder.append(' ');
        }
        return sharedBuilder.append(string).append(']').toString();
    }

    public static final int fastPrettySingleDesc(@NotNull String desc, int startIndex, @NotNull StringBuilder output) {
        switch (desc.codePointAt(startIndex)) {
            case 86: {
                output.append("void");
                return 1;
            }
            case 66: {
                output.append("byte");
                return 1;
            }
            case 90: {
                output.append("boolean");
                return 1;
            }
            case 83: {
                output.append("short");
                return 1;
            }
            case 67: {
                output.append("char");
                return 1;
            }
            case 73: {
                output.append("int");
                return 1;
            }
            case 74: {
                output.append("long");
                return 1;
            }
            case 70: {
                output.append("float");
                return 1;
            }
            case 68: {
                output.append("double");
                return 1;
            }
            case 91: {
                int len = PrintUtils.fastPrettySingleDesc(desc, startIndex + 1, output);
                output.append("[]");
                return ++len;
            }
            case 76: {
                int endIndex = desc.indexOf(59, startIndex);
                int beginIndex = Math.max(startIndex, desc.lastIndexOf(47, endIndex)) + 1;
                output.append(desc, beginIndex, endIndex);
                return endIndex - startIndex + 1;
            }
        }
        throw new IllegalStateException("Unknown type: " + (char)desc.codePointAt(startIndex));
    }

    @NotNull
    public static final String prettySingleDesc(@NotNull String desc, @NotNull StringBuilder sharedBuilder) {
        sharedBuilder.setLength(0);
        PrintUtils.fastPrettySingleDesc(desc, 0, sharedBuilder);
        return sharedBuilder.toString();
    }

    @NotNull
    public static final String prettyType(@NotNull Type type, @NotNull StringBuilder sharedBuilder) {
        return PrintUtils.prettySingleDesc(type.getDescriptor(), sharedBuilder);
    }

    @Contract(mutates="param2", pure=false, value="_, !null -> param2; _, null -> fail")
    @NotNull
    public static final StringBuilder stringifyAccessMethod(int acc, @NotNull StringBuilder out) {
        boolean reqWhitespace = false;
        if (((acc &= 0xFFFDAF3F) & 1) != 0) {
            out.append("public");
            acc &= 0xFFFFFFFE;
            reqWhitespace = true;
        }
        if ((acc & 2) != 0) {
            if (reqWhitespace) {
                out.append(' ');
            } else {
                reqWhitespace = true;
            }
            out.append("private");
            acc &= 0xFFFFFFFD;
        }
        if ((acc & 4) != 0) {
            if (reqWhitespace) {
                out.append(' ');
            } else {
                reqWhitespace = true;
            }
            out.append("protected");
            acc &= 0xFFFFFFFB;
        }
        if ((acc & 8) != 0) {
            if (reqWhitespace) {
                out.append(' ');
            } else {
                reqWhitespace = true;
            }
            out.append("static");
            acc &= 0xFFFFFFF7;
        }
        if ((acc & 0x10) != 0) {
            if (reqWhitespace) {
                out.append(' ');
            } else {
                reqWhitespace = true;
            }
            out.append("final");
            acc &= 0xFFFFFFEF;
        }
        if ((acc & 0x20) != 0) {
            if (reqWhitespace) {
                out.append(' ');
            } else {
                reqWhitespace = true;
            }
            out.append("synchronized");
            acc &= 0xFFFFFFDF;
        }
        if (acc != 0) {
            throw new IllegalStateException("Was not able to fully reduce access modifiers: " + acc);
        }
        return out;
    }

    public static final void fastPrettyPrintCallbackInfo(@NotNull MethodNode targetMethod, @NotNull StringBuilder out) {
        switch (targetMethod.desc.codePointBefore(targetMethod.desc.length())) {
            case 86: {
                out.append("CallbackInfo");
                return;
            }
            case 59: {
                out.append("CallbackInfoReturnable<");
                PrintUtils.fastPrettySingleDesc(targetMethod.desc, targetMethod.desc.lastIndexOf(41) + 1, out);
                out.append('>');
                return;
            }
        }
        out.append("CallbackInfoReturnable<");
        out.append(PrintUtils.getSimpleWrapperClassName(targetMethod.desc.codePointBefore(targetMethod.desc.length())));
        out.append('>');
    }

    @NotNull
    public static final String getSimpleWrapperClassName(int primitiveType) {
        switch (primitiveType) {
            case 66: {
                return "Byte";
            }
            case 90: {
                return "Boolean";
            }
            case 83: {
                return "Short";
            }
            case 67: {
                return "Character";
            }
            case 73: {
                return "Integer";
            }
            case 74: {
                return "Long";
            }
            case 70: {
                return "Float";
            }
            case 68: {
                return "Double";
            }
        }
        throw new IllegalArgumentException(new String(new int[]{primitiveType}, 0, 1) + " is not a valid primitive.");
    }

    @NotNull
    public static final List<String> getExpectedCallbackSignature(@NotNull MethodNode currentHandler, @NotNull MethodNode target, @NotNull Frame<BasicValue> frame, @NotNull StringBuilder sharedBuilder) {
        String localDesc;
        int i;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add("/**");
        lines.add(" * Expected callback signature");
        lines.add(" * /");
        sharedBuilder.setLength(0);
        int access = currentHandler.access;
        PrintUtils.stringifyAccessMethod(access &= 0xFFFFFFF7, sharedBuilder).append(" void ").append(currentHandler.name);
        sharedBuilder.append('(');
        int maxLocals = frame.getLocals();
        int initialFrameSize = ASMUtil.getInitialFrameSize(target);
        int reducedIndex = 0;
        for (i = 0; i < initialFrameSize; ++i) {
            if ((target.access & 8) == 0 && i == 0) continue;
            localDesc = ((BasicValue)frame.getLocal(i)).getType().getDescriptor();
            PrintUtils.fastPrettySingleDesc(localDesc, 0, sharedBuilder);
            sharedBuilder.append(" arg").append(reducedIndex++);
            if (ASMUtil.isCategory2(localDesc.codePointAt(0))) {
                ++i;
            }
            sharedBuilder.append(", ");
        }
        PrintUtils.fastPrettyPrintCallbackInfo(target, sharedBuilder);
        sharedBuilder.append(" ci");
        reducedIndex = 0;
        for (i = initialFrameSize; i < maxLocals; ++i) {
            localDesc = ((BasicValue)frame.getLocal(i)).getType().getDescriptor();
            sharedBuilder.append(", ");
            PrintUtils.fastPrettySingleDesc(localDesc, 0, sharedBuilder);
            if (i < initialFrameSize) {
                sharedBuilder.append(" arg");
            } else {
                if (i == initialFrameSize) {
                    reducedIndex = 0;
                }
                sharedBuilder.append(" local");
            }
            sharedBuilder.append(reducedIndex++);
            if (!ASMUtil.isCategory2(localDesc.codePointAt(0))) continue;
            ++i;
        }
        sharedBuilder.append(") {");
        lines.add(sharedBuilder.toString());
        lines.add("    // Method body");
        lines.add("}");
        lines.add("");
        return lines;
    }
}

