/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.selectors.constant;

import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.stianloader.micromixin.transform.internal.annotation.ConstantSelector;

public class WildcardConstantSelector
extends ConstantSelector {
    private final int type;
    @NotNull
    private final String typeDescriptor;

    public WildcardConstantSelector(@NotNull String typeDescriptor) {
        this.type = typeDescriptor.codePointAt(0);
        this.typeDescriptor = typeDescriptor;
    }

    @Override
    public boolean matchesConstant(@NotNull AbstractInsnNode insn) {
        if (insn instanceof InsnNode) {
            if (this.type == 73) {
                return insn.getOpcode() >= 2 && insn.getOpcode() <= 8;
            }
            if (this.type == 74) {
                return insn.getOpcode() == 9 || insn.getOpcode() == 10;
            }
            if (this.type == 68) {
                return insn.getOpcode() == 14 || insn.getOpcode() == 15;
            }
            if (this.type == 70) {
                return insn.getOpcode() == 11 || insn.getOpcode() == 12 || insn.getOpcode() == 13;
            }
            if (this.type == 76) {
                return insn.getOpcode() == 1;
            }
        } else if (insn instanceof LdcInsnNode) {
            Object ldcCst = ((LdcInsnNode)insn).cst;
            if (this.type == 73) {
                return ldcCst instanceof Integer;
            }
            if (this.type == 74) {
                return ldcCst instanceof Long;
            }
            if (this.type == 68) {
                return ldcCst instanceof Double;
            }
            if (this.type == 70) {
                return ldcCst instanceof Float;
            }
            if (this.type == 76) {
                if (ldcCst instanceof String) {
                    return this.typeDescriptor.equals("Ljava/lang/String;");
                }
                if (ldcCst instanceof Type) {
                    return this.typeDescriptor.equals("Ljava/lang/Class;");
                }
            }
        } else if (insn instanceof IntInsnNode && this.type == 73) {
            return insn.getOpcode() == 16 || insn.getOpcode() == 17;
        }
        return false;
    }
}

