/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.testneo.testenv.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.FIELD})
public @interface AssertMemberNames {
    @NotNull
    public @NotNull AssertMemberName @NotNull [] value();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD})
    @Repeatable(value=AssertMemberNames.class)
    public static @interface AssertMemberName {
        @NotNull
        public AssertConstraint constraint();

        public boolean negate() default false;

        @NotNull
        public String value();
    }

    public static enum AssertConstraint {
        CONTAINS(String::contains),
        IS(String::equals);

        @NotNull
        private @NotNull BiPredicate<@NotNull String, @NotNull String> fn;

        public static boolean test(@NotNull String memberName, @NotNull AssertMemberName assertion) {
            return assertion.constraint().test(memberName, assertion.value(), assertion.negate());
        }

        private AssertConstraint(BiPredicate<String, String> fn) {
            this.fn = fn;
        }

        public boolean test(@NotNull String memberName, @NotNull String witness, boolean negate) {
            return this.fn.test(memberName, witness) ^ negate;
        }
    }
}

