/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.backports;

import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;
import org.stianloader.micromixin.backports.CanonicalOverwriteInjectionInfo;

public class CanonicalOverwriteInjector
extends Injector {
    public CanonicalOverwriteInjector(CanonicalOverwriteInjectionInfo info) {
        super((InjectionInfo)info, "@CanonicalOverwrite");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        int invokeOpcode;
        int retOpcode;
        if (this.isStatic) {
            throw new IllegalStateException("The handler method of a @CanonicalOverwrite may never be static, however in this case the handler method is static. This is not permissible as per the documentation of @CanonicalOverwrite.");
        }
        if (target.isStatic) {
            throw new IllegalStateException("The target method of a @CanonicalOverwrite may not be static, however in this case the target is static. This is not permissible.");
        }
        if (!this.methodNode.desc.equals(target.method.desc)) {
            throw new IllegalStateException("Mismatch between descriptors of handler method ('" + this.methodNode.desc + "') versus target method ('" + target.method.desc + "')");
        }
        int retType = this.methodNode.desc.codePointBefore(this.methodNode.desc.length());
        if (retType == 86) {
            retOpcode = 177;
        } else if (retType == 59) {
            retOpcode = 176;
        } else if (retType == 90 || retType == 73 || retType == 67 || retType == 83 || retType == 66) {
            retOpcode = 172;
        } else if (retType == 70) {
            retOpcode = 174;
        } else if (retType == 74) {
            retOpcode = 173;
        } else {
            throw new IllegalStateException("Unknown return type: " + new String(new int[]{retType}, 0, 1) + " (" + retType + " / 0x" + Integer.toHexString(retType) + ")");
        }
        Type[] args = Type.getArgumentTypes((String)this.methodNode.desc);
        target.method.instructions.clear();
        int localIdx = (target.method.access & 8) == 0 ? 1 : 0;
        if (this.isStatic) {
            invokeOpcode = 184;
        } else {
            target.method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            invokeOpcode = 182;
        }
        for (Type arg : args) {
            target.method.instructions.add((AbstractInsnNode)new VarInsnNode(arg.getOpcode(21), localIdx));
            localIdx += arg.getSize();
        }
        target.method.instructions.add((AbstractInsnNode)new MethodInsnNode(invokeOpcode, target.classNode.name, this.methodNode.name, this.methodNode.desc));
        target.method.instructions.add((AbstractInsnNode)new InsnNode(retOpcode));
        this.info.addCallbackInvocation(this.methodNode);
        boolean shadowedMethodAlreadyPresent = false;
        for (MethodNode targetSiblingMethod : target.classNode.methods) {
            if (!targetSiblingMethod.name.equals(this.info.getMethodName()) || !this.info.getMethod().desc.equals(targetSiblingMethod.desc)) continue;
            shadowedMethodAlreadyPresent = true;
            break;
        }
        if (!shadowedMethodAlreadyPresent) {
            MethodNode shadowedMethod = new MethodNode(1, this.info.getMethodName(), this.info.getMethod().desc, null, this.info.getMethod().exceptions.toArray(new String[0]));
            Map labelClones = Bytecode.cloneLabels((InsnList)target.method.instructions);
            for (AbstractInsnNode insn = target.method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                shadowedMethod.instructions.add(insn.clone(labelClones));
            }
            target.classNode.methods.add(shadowedMethod);
        }
    }
}

