/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.selfmodification.mixins;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.service.IGlobalPropertyService;
import org.spongepowered.asm.service.IPropertyKey;

public class GlobalPropertyServiceMinestom
implements IGlobalPropertyService {
    private final Map<String, IPropertyKey> keys = new HashMap<String, IPropertyKey>();
    private final Map<IPropertyKey, Object> values = new HashMap<IPropertyKey, Object>();

    public IPropertyKey resolveKey(String name) {
        if (name == null) {
            throw new NullPointerException("Argument 'name' should not be null as this implementation does not support keys with null names.");
        }
        IPropertyKey key = this.keys.get(name);
        if (key == null) {
            key = new BasicProperty(name);
            this.keys.put(name, key);
        }
        return key;
    }

    public <T> T getProperty(IPropertyKey key) {
        return (T)this.values.get(key);
    }

    public void setProperty(IPropertyKey key, Object value) {
        this.values.put(key, value);
    }

    public <T> T getProperty(IPropertyKey key, T defaultValue) {
        return (T)this.values.getOrDefault(key, defaultValue);
    }

    public String getPropertyString(IPropertyKey key, String defaultValue) {
        return (String)this.values.getOrDefault(key, defaultValue);
    }

    private static class BasicProperty
    implements IPropertyKey {
        @NotNull
        private final String name;

        public BasicProperty(@NotNull String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BasicProperty)) {
                return false;
            }
            return this.name.equals(((BasicProperty)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "BasicProperty{name='" + this.name + "'}";
        }
    }
}

