/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minestom.server.extras.selfmodification.MinestomRootClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

public final class Utils {
    private static final byte[] SHARED_DUMMY_ARRAY = new byte[4096];
    private static final boolean LOCAL_LOGS = Boolean.getBoolean("org.stianloader.launcher.Utils.localLogs");

    @NotNull
    @ApiStatus.AvailableSince(value="4.0.0-a20240711")
    @Contract(pure=true)
    public static final String applyPlaceholders(@NotNull Object sourceResource, @NotNull String string, int startIndex, @NotNull Map<String, String> placeholders) {
        int indexStart = string.indexOf("${", startIndex);
        if (indexStart == -1) {
            return string;
        }
        int indexEnd = string.indexOf(125, indexStart);
        String property = string.substring(indexStart + 2, indexEnd);
        String replacement = placeholders.get(property);
        if (replacement == null) {
            LoggerFactory.getLogger(Utils.class).warn("Could not expand resource '{}': Unknown property (or a null value for said property): '{}'", sourceResource, (Object)property);
            return Utils.applyPlaceholders(sourceResource, string, indexEnd, placeholders);
        }
        string = string.substring(0, indexStart) + replacement + string.substring(indexEnd + 1);
        return Utils.applyPlaceholders(sourceResource, string, indexStart, placeholders);
    }

    public static final void fastExhaust(@NotNull InputStream in) throws IOException {
        while (in.read(SHARED_DUMMY_ARRAY) != -1) {
        }
    }

    public static final Path getLogDirectory() {
        String appdataFolder;
        if (LOCAL_LOGS) {
            Path logDir = Paths.get("logs", new String[0]);
            try {
                if (Files.notExists(logDir, new LinkOption[0])) {
                    Files.createDirectory(logDir, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return logDir;
        }
        String xdgStateHome = System.getenv("XDG_STATE_HOME");
        if (xdgStateHome != null && !xdgStateHome.isEmpty()) {
            Path p = Paths.get(xdgStateHome, "stianloader");
            try {
                Files.createDirectories(p, new FileAttribute[0]);
                return p;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((appdataFolder = System.getenv("APPDATA")) != null) {
            Path location = Paths.get(appdataFolder, "stianloader");
            try {
                if (!Files.isDirectory(location, new LinkOption[0])) {
                    Files.createDirectory(location, new FileAttribute[0]);
                }
            }
            catch (IOException expected) {
                expected.printStackTrace();
                return Paths.get(".", new String[0]);
            }
            return location;
        }
        String userhome = System.getProperty("user.home");
        if (userhome == null) {
            return Paths.get(".", new String[0]);
        }
        Path location = Paths.get(userhome, ".local");
        if (Files.notExists(location, new LinkOption[0])) {
            return Paths.get(".", new String[0]);
        }
        if (Files.notExists(location = location.resolve("state"), new LinkOption[0])) {
            try {
                if (!Files.isDirectory(location, new LinkOption[0])) {
                    Files.createDirectory(location, new FileAttribute[0]);
                }
            }
            catch (IOException expected) {
                expected.printStackTrace();
                return Paths.get(".", new String[0]);
            }
        }
        location = location.resolve("stianloader");
        try {
            if (!Files.isDirectory(location, new LinkOption[0])) {
                Files.createDirectory(location, new FileAttribute[0]);
            }
        }
        catch (IOException expected) {
            expected.printStackTrace();
            return Paths.get(".", new String[0]);
        }
        return location;
    }

    public static final void startMain(@NotNull Class<?> className, String[] args) {
        try {
            MethodHandles.publicLookup().findStatic(className, "main", MethodType.methodType(Void.TYPE, String[].class)).invokeExact(args);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while invoking main class!", e);
        }
    }

    protected static final void startMixin(String[] args) {
        MixinBootstrap.init();
        MixinBootstrap.getPlatform().inject();
        Mixins.getConfigs().forEach(c -> MinestomRootClassLoader.getInstance().protectedPackages.add(c.getConfig().getMixinPackage()));
    }

    @Nullable
    public static final URI toCodeSourceURI(@Nullable URL url, @NotNull String internalClassName) {
        if (url == null) {
            return null;
        }
        String urlPath = url.getPath();
        if (urlPath.endsWith(".class")) {
            String expectedSuffix;
            String urlProtocol = url.getProtocol();
            if (urlProtocol.equals("jar")) {
                int index0 = urlPath.indexOf(33);
                if (index0 >= 0) {
                    try {
                        return new URI(urlPath.substring(0, index0));
                    }
                    catch (URISyntaxException e) {
                        LoggerFactory.getLogger(Utils.class).warn("Unable to assimilate jar-protocol-URL: '{}'", (Object)url, (Object)e);
                    }
                }
            } else if (urlProtocol.equals("file") && urlPath.endsWith(expectedSuffix = internalClassName.replace('.', '/') + ".class")) {
                try {
                    return new URI("file", null, url.getHost(), url.getPort(), urlPath.substring(0, urlPath.length() - expectedSuffix.length()), null, null);
                }
                catch (URISyntaxException e) {
                    LoggerFactory.getLogger(Utils.class).warn("Unable to assimilate file-protocol-URL: '{}'", (Object)url, (Object)e);
                }
            }
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(Utils.class).debug("Cannot convert URL {} to a URI.", (Object)url, (Object)e);
            return null;
        }
    }

    private Utils() {
    }
}

