/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader;

import de.geolykt.starloader.launcher.Utils;
import de.geolykt.starloader.mod.DirectoryExtensionPrototypeList;
import de.geolykt.starloader.mod.Extension;
import de.geolykt.starloader.mod.ExtensionManager;
import de.geolykt.starloader.mod.ExtensionPrototype;
import de.geolykt.starloader.util.JavaInterop;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import net.minestom.server.extras.selfmodification.MinestomRootClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Starloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Starloader.class);
    private static Starloader instance;
    private final ExtensionManager extensions;
    @NotNull
    private final @NotNull List<@NotNull ? extends ExtensionPrototype> extensionSource;
    @NotNull
    private final Path modDirectory;

    private Starloader(@NotNull DirectoryExtensionPrototypeList modSource) {
        this.extensionSource = modSource;
        this.modDirectory = modSource.getFolder().toPath();
        this.extensions = new ExtensionManager(this.modDirectory.resolve(".picoresolve-cache"));
    }

    private Starloader(@NotNull @NotNull List<@NotNull ? extends ExtensionPrototype> extensionSource, ExtensionManager extensions, @NotNull Path modDir) {
        this.extensionSource = extensionSource;
        this.extensions = extensions;
        this.modDirectory = modDir;
    }

    private void start() {
        this.extensions.loadExtensions(this.extensionSource);
        LOGGER.info("From {} prototypes, {} extensions were loaded.", (Object)this.extensionSource.size(), (Object)this.extensions.getExtensions().size());
        long start = System.currentTimeMillis();
        LOGGER.info("Initializing extension: preinit");
        this.extensions.getExtensions().forEach(Extension::preInitialize);
        LOGGER.info("Initializing extension: init");
        this.extensions.getExtensions().forEach(extension -> {
            extension.initialize();
            LOGGER.info("Initialized extension {}.", (Object)extension.getDescription().getName());
        });
        LOGGER.info("Initializing extension: postinit");
        this.extensions.getExtensions().forEach(Extension::postInitialize);
        LOGGER.info("All Extensions initialized within {}ms", (Object)(System.currentTimeMillis() - start));
        Runtime.getRuntime().addShutdownHook(new Thread(this.extensions::shutdown, "ExtensionsShutdownThread"));
    }

    @ApiStatus.Internal
    public static void start(@NotNull @NotNull List<@NotNull ExtensionPrototype> extensionSource, @NotNull Path modDir) {
        if (instance != null) {
            throw new IllegalStateException("Starloader initialized twice!");
        }
        LOGGER.info("Java version: {}. JavaInterop J9: {}", (Object)System.getProperty("java.version"), (Object)JavaInterop.isJava9());
        LOGGER.info("Storing log files in {}", (Object)Utils.getLogDirectory().toAbsolutePath().toString());
        instance = new Starloader(extensionSource, new ExtensionManager(modDir.resolve(".picoresolve-cache")), modDir);
        instance.start();
    }

    @ApiStatus.Internal
    public static void start(@NotNull DirectoryExtensionPrototypeList modSource) {
        if (instance != null) {
            throw new IllegalStateException("Starloader initialized twice!");
        }
        LOGGER.info("Java version: {}. JavaInterop J9: {}", (Object)System.getProperty("java.version"), (Object)JavaInterop.isJava9());
        LOGGER.info("Storing log files in {}", (Object)Utils.getLogDirectory().toAbsolutePath().toString());
        instance = new Starloader(modSource);
        instance.start();
    }

    public static ExtensionManager getExtensionManager() {
        return Starloader.instance.extensions;
    }

    @Deprecated
    @NotNull
    public static File getExtensionDir() {
        return instance.getModDirectory().toFile();
    }

    @NotNull
    public Path getModDirectory() {
        return this.modDirectory;
    }

    public static Starloader getInstance() {
        return instance;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static {
        if (Starloader.class.getClassLoader().getClass() != MinestomRootClassLoader.class) {
            MinestomRootClassLoader rootCl = MinestomRootClassLoader.getInstance();
            try {
                Class<?> slClass = Class.forName("de.geolykt.starloader.Starloader", false, rootCl);
                if (slClass != Starloader.class) {
                    Field instanceField = slClass.getDeclaredField("instance");
                    Field srcField = slClass.getDeclaredField("extensionSource");
                    Field extField = slClass.getDeclaredField("extensions");
                    Field modDirField = slClass.getDeclaredField("modDirectory");
                    srcField.setAccessible(true);
                    extField.setAccessible(true);
                    modDirField.setAccessible(true);
                    instanceField.setAccessible(true);
                    Object instance = instanceField.get(null);
                    if (instance == null) {
                        throw new IllegalStateException("Unable to find instance of actual the Starloader class (Did it start yet?); This Class instance was loaded by " + Starloader.class.getClassLoader() + ", where as it should've been " + slClass.getClassLoader());
                    }
                    @NotNull List extensionSource = (List)srcField.get(instance);
                    ExtensionManager extensions = (ExtensionManager)extField.get(instance);
                    Path modDir = (Path)modDirField.get(instance);
                    assert (extensionSource != null && modDir != null);
                    Starloader.instance = new Starloader(extensionSource, extensions, modDir);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("This class should be loaded by the root classloader!", e);
            }
        }
    }
}

