/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.transformers;

import de.geolykt.starloader.ras.ReversibleAccessSetterContext;
import de.geolykt.starloader.transformers.ASMTransformer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.LoggerFactory;

public class ReversibleAccessSetterTransformer
extends ASMTransformer {
    @NotNull
    private final ReversibleAccessSetterContext mainContext = new ReversibleAccessSetterContext(ReversibleAccessSetterContext.RASTransformScope.RUNTIME, false);
    @NotNull
    private final ReversibleAccessSetterContext reverseContext = new ReversibleAccessSetterContext(ReversibleAccessSetterContext.RASTransformScope.BUILDTIME, true);

    @Override
    public boolean accept(@NotNull ClassNode node) {
        try {
            this.reverseContext.accept(node);
            this.mainContext.accept(node);
        }
        catch (ReversibleAccessSetterContext.RASTransformFailure failure) {
            LoggerFactory.getLogger(this.getClass()).error("Unable to transform class {}", (Object)node.name, (Object)failure);
        }
        return true;
    }

    @NotNull
    public ReversibleAccessSetterContext getMainContext() {
        return this.mainContext;
    }

    @Override
    public int getPriority() {
        return -10010;
    }

    @NotNull
    public ReversibleAccessSetterContext getReverseContext() {
        return this.reverseContext;
    }

    @Override
    public boolean isValidTarget(@NotNull String internalName) {
        return this.mainContext.isTarget(internalName) || this.reverseContext.isTarget(internalName);
    }
}

