/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.utils.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.Types;
import net.lenni0451.classtransform.utils.annotations.AnnotationUtils;
import net.lenni0451.classtransform.utils.annotations.ClassDefiner;
import net.lenni0451.classtransform.utils.annotations.IParsedAnnotation;
import net.lenni0451.classtransform.utils.tree.ClassTree;
import net.lenni0451.classtransform.utils.tree.IClassProvider;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

@ParametersAreNonnullByDefault
public class AnnotationParser<T extends Annotation> {
    private final Class<T> type;
    private final ClassTree classTree;
    private final IClassProvider classProvider;
    private Map<String, Object> values;
    private List<String> initializedDefaultValues;
    private ClassNode node;

    public static <T extends Annotation> T parse(Class<T> type, TransformerManager transformerManager, Map<String, Object> values) {
        return new AnnotationParser<T>(type, transformerManager.getClassTree(), transformerManager.getClassProvider()).parse(values);
    }

    public static <T extends Annotation> T parse(Class<T> type, ClassTree classTree, IClassProvider classProvider, Map<String, Object> values) {
        return new AnnotationParser<T>(type, classTree, classProvider).parse(values);
    }

    @Deprecated
    public static Map<String, Object> listToMap(@Nullable List<Object> list) {
        return AnnotationUtils.listToMap(list);
    }

    @Deprecated
    public static List<Object> mapToList(@Nullable Map<String, Object> map) {
        return AnnotationUtils.mapToList(map);
    }

    public AnnotationParser(Class<T> type, ClassTree classTree, IClassProvider classProvider) {
        this.type = type;
        this.classTree = classTree;
        this.classProvider = classProvider;
    }

    public T parse(Map<String, Object> values) {
        this.initDefaults(values);
        this.defineBase();
        this.declareMethods();
        try {
            return (T)((Annotation)ClassDefiner.defineAnonymousClass(ASMUtils.toBytes(this.node, this.classTree, this.classProvider)).newInstance(new Class[]{ClassTree.class, IClassProvider.class, Map.class}, new Object[]{this.classTree, this.classProvider, this.values}));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to create instance of '" + this.type.getName() + "'", t);
        }
    }

    private void initDefaults(Map<String, Object> values) {
        this.initializedDefaultValues = new ArrayList<String>();
        for (Method method : this.type.getDeclaredMethods()) {
            Object defaultValue;
            if (values.containsKey(method.getName()) || (defaultValue = method.getDefaultValue()) == null) continue;
            values.put(method.getName(), defaultValue);
            this.initializedDefaultValues.add(method.getName());
        }
        this.values = values;
    }

    private void defineBase() {
        this.node = new ClassNode();
        this.node.visit(52, 1, ClassDefiner.generateClassName("AnnotationWrapper"), null, Types.IN_Object, new String[]{Types.internalName(this.type), Types.internalName(IParsedAnnotation.class)});
        this.node.visitField(2, "classTree", Types.typeDescriptor(ClassTree.class), null, null).visitEnd();
        this.node.visitField(2, "classProvider", Types.typeDescriptor(IClassProvider.class), null, null).visitEnd();
        this.node.visitField(2, "values", Types.typeDescriptor(Map.class), null, null).visitEnd();
        MethodVisitor constructor = this.node.visitMethod(1, "<init>", Types.methodDescriptor(Void.TYPE, ClassTree.class, IClassProvider.class, Map.class), null, null);
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, Types.IN_Object, "<init>", Types.MD_Void, false);
        constructor.visitVarInsn(25, 0);
        constructor.visitVarInsn(25, 1);
        constructor.visitFieldInsn(181, this.node.name, "classTree", Types.typeDescriptor(ClassTree.class));
        constructor.visitVarInsn(25, 0);
        constructor.visitVarInsn(25, 2);
        constructor.visitFieldInsn(181, this.node.name, "classProvider", Types.typeDescriptor(IClassProvider.class));
        constructor.visitVarInsn(25, 0);
        constructor.visitVarInsn(25, 3);
        constructor.visitFieldInsn(181, this.node.name, "values", Types.typeDescriptor(Map.class));
        constructor.visitInsn(177);
        constructor.visitEnd();
        MethodVisitor equals = this.node.visitMethod(1, "equals", Types.methodDescriptor(Boolean.TYPE, Object.class), null, null);
        equals.visitInsn(3);
        equals.visitInsn(172);
        equals.visitEnd();
        MethodVisitor hashCode = this.node.visitMethod(1, "hashCode", Types.methodDescriptor(Integer.TYPE, new Object[0]), null, null);
        hashCode.visitInsn(3);
        hashCode.visitInsn(172);
        hashCode.visitEnd();
        MethodVisitor toString = this.node.visitMethod(1, "toString", Types.methodDescriptor(String.class, new Object[0]), null, null);
        toString.visitLdcInsn((Object)"AnnotationWrapper");
        toString.visitInsn(176);
        toString.visitEnd();
        MethodVisitor annotationType = this.node.visitMethod(1, "annotationType", Types.methodDescriptor(Class.class, new Object[0]), null, null);
        annotationType.visitLdcInsn((Object)Types.type(this.type));
        annotationType.visitInsn(176);
        annotationType.visitEnd();
        MethodVisitor getValues = this.node.visitMethod(1, "getValues", Types.methodDescriptor(Map.class, new Object[0]), null, null);
        getValues.visitVarInsn(25, 0);
        getValues.visitFieldInsn(180, this.node.name, "values", Types.typeDescriptor(Map.class));
        getValues.visitInsn(176);
        getValues.visitEnd();
        MethodVisitor wasSet = this.node.visitMethod(1, "wasSet", Types.methodDescriptor(Boolean.TYPE, String.class), null, null);
        for (String value : this.values.keySet()) {
            if (this.initializedDefaultValues.contains(value)) continue;
            Label jumpAfter = new Label();
            wasSet.visitVarInsn(25, 1);
            wasSet.visitLdcInsn((Object)value);
            wasSet.visitMethodInsn(182, Types.IN_String, "equals", Types.methodDescriptor(Boolean.TYPE, Object.class), false);
            wasSet.visitJumpInsn(153, jumpAfter);
            wasSet.visitInsn(4);
            wasSet.visitInsn(172);
            wasSet.visitLabel(jumpAfter);
        }
        wasSet.visitInsn(3);
        wasSet.visitInsn(172);
        wasSet.visitEnd();
    }

    private void declareMethods() {
        for (Method method : this.type.getDeclaredMethods()) {
            MethodVisitor methodVisitor = this.node.visitMethod(1, method.getName(), Types.methodDescriptor(method, new Object[0]), null, null);
            Object value = this.values.get(method.getName());
            this.visit(methodVisitor, method.getReturnType(), value);
            methodVisitor.visitInsn(ASMUtils.getReturnOpcode(Types.returnType(method)));
            methodVisitor.visitEnd();
        }
    }

    private void visit(MethodVisitor methodVisitor, Class<?> type, Object value) {
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            this.visitBoolean(methodVisitor, value);
        } else if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            this.visitByte(methodVisitor, value);
        } else if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            this.visitShort(methodVisitor, value);
        } else if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            this.visitChar(methodVisitor, value);
        } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            this.visitInt(methodVisitor, value);
        } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            this.visitLong(methodVisitor, value);
        } else if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            this.visitFloat(methodVisitor, value);
        } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            this.visitDouble(methodVisitor, value);
        } else if (type.equals(String.class)) {
            this.visitString(methodVisitor, value);
        } else if (type.equals(Class.class) || type.equals(Type.class)) {
            this.visitClass(methodVisitor, value);
        } else if (type.isEnum()) {
            this.visitEnum(methodVisitor, value);
        } else if (type.isAnnotation() || type.equals(AnnotationNode.class)) {
            this.visitAnnotation(methodVisitor, value);
        } else if (type.isArray() || List.class.isAssignableFrom(type)) {
            this.visitArray(methodVisitor, type.getComponentType(), value);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
    }

    private void visitBoolean(MethodVisitor methodVisitor, Object value) {
        boolean b = (Boolean)value;
        methodVisitor.visitInsn(b ? 4 : 3);
    }

    private void visitByte(MethodVisitor methodVisitor, Object value) {
        byte b = (Byte)value;
        methodVisitor.visitIntInsn(16, (int)b);
    }

    private void visitShort(MethodVisitor methodVisitor, Object value) {
        short s = (Short)value;
        methodVisitor.visitIntInsn(17, (int)s);
    }

    private void visitChar(MethodVisitor methodVisitor, Object value) {
        char c = ((Character)value).charValue();
        methodVisitor.visitIntInsn(17, (int)c);
    }

    private void visitInt(MethodVisitor methodVisitor, Object value) {
        int i = (Integer)value;
        methodVisitor.visitLdcInsn((Object)i);
    }

    private void visitLong(MethodVisitor methodVisitor, Object value) {
        long l = (Long)value;
        methodVisitor.visitLdcInsn((Object)l);
    }

    private void visitFloat(MethodVisitor methodVisitor, Object value) {
        float f = ((Float)value).floatValue();
        methodVisitor.visitLdcInsn((Object)Float.valueOf(f));
    }

    private void visitDouble(MethodVisitor methodVisitor, Object value) {
        double d = (Double)value;
        methodVisitor.visitLdcInsn((Object)d);
    }

    private void visitString(MethodVisitor methodVisitor, Object value) {
        String s = (String)value;
        methodVisitor.visitLdcInsn((Object)s);
    }

    private void visitClass(MethodVisitor methodVisitor, Object value) {
        if (!(value instanceof Class) && !(value instanceof Type)) {
            throw new IllegalArgumentException("Unexpected value class for type 'Class': " + value.getClass());
        }
        this.visitType(methodVisitor, value);
    }

    private void visitEnum(MethodVisitor methodVisitor, Object value) {
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            methodVisitor.visitFieldInsn(178, Types.internalName(e.getDeclaringClass()), e.name(), Types.typeDescriptor(e.getDeclaringClass()));
        } else if (value instanceof String[]) {
            String[] enumValue = (String[])value;
            methodVisitor.visitFieldInsn(178, Types.internalName(enumValue[0]), enumValue[1], enumValue[0]);
        } else {
            throw new IllegalArgumentException("Unexpected value class for type 'Enum': " + value.getClass());
        }
    }

    private void visitAnnotation(MethodVisitor methodVisitor, Object value) {
        Type annotationType;
        if (value instanceof Annotation) {
            annotationType = Types.type(((Annotation)value).annotationType());
        } else if (value instanceof AnnotationNode) {
            annotationType = Types.type(((AnnotationNode)value).desc);
        } else {
            throw new IllegalArgumentException("Unexpected value class for type 'Annotation': " + value.getClass());
        }
        methodVisitor.visitLdcInsn((Object)annotationType);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.node.name, "classTree", Types.typeDescriptor(ClassTree.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.node.name, "classProvider", Types.typeDescriptor(IClassProvider.class));
        methodVisitor.visitTypeInsn(187, Types.internalName(HashMap.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Types.internalName(HashMap.class), "<init>", Types.MD_Void, false);
        if (value instanceof Annotation) {
            Annotation a = (Annotation)value;
            for (Method method : a.annotationType().getDeclaredMethods()) {
                Object returnValue;
                if (!Modifier.isAbstract(method.getModifiers())) continue;
                try {
                    returnValue = method.invoke(value, new Object[0]);
                    if (returnValue == null) {
                        throw new IllegalArgumentException("Null return value for annotation member: " + method.getName());
                    }
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Failed to invoke method '" + method.getName() + "' on annotation '" + a.annotationType().getName() + "'", t);
                }
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)method.getName());
                this.visit(methodVisitor, method.getReturnType(), returnValue);
                this.visitPrimitiveWrap(methodVisitor, method.getReturnType());
                methodVisitor.visitMethodInsn(185, Types.internalName(Map.class), "put", Types.methodDescriptor(Object.class, Object.class, Object.class), true);
                methodVisitor.visitInsn(87);
            }
        } else {
            AnnotationNode a = (AnnotationNode)value;
            Map<String, Object> map = AnnotationUtils.listToMap(a.values);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)entry.getKey());
                this.visit(methodVisitor, entry.getValue().getClass(), entry.getValue());
                this.visitPrimitiveWrap(methodVisitor, entry.getValue().getClass());
                methodVisitor.visitMethodInsn(185, Types.internalName(Map.class), "put", Types.methodDescriptor(Object.class, Object.class, Object.class), true);
                methodVisitor.visitInsn(87);
            }
        }
        methodVisitor.visitMethodInsn(184, Types.internalName(AnnotationParser.class), "parse", Types.methodDescriptor(Annotation.class, Class.class, ClassTree.class, IClassProvider.class, Map.class), false);
        methodVisitor.visitTypeInsn(192, Types.internalName(annotationType));
    }

    private void visitArray(MethodVisitor methodVisitor, Class<?> arrayType, Object value) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            methodVisitor.visitIntInsn(16, array.length);
            methodVisitor.visitTypeInsn(189, Types.internalName(arrayType));
            for (int i = 0; i < array.length; ++i) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)i);
                this.visit(methodVisitor, arrayType, array[i]);
                methodVisitor.visitInsn(83);
            }
        } else if (value instanceof List) {
            List array = (List)value;
            methodVisitor.visitIntInsn(16, array.size());
            methodVisitor.visitTypeInsn(189, Types.internalName(arrayType));
            for (int i = 0; i < array.size(); ++i) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)i);
                this.visit(methodVisitor, arrayType, array.get(i));
                methodVisitor.visitInsn(83);
            }
        } else {
            throw new IllegalArgumentException("Unexpected value class for type 'Array': " + value.getClass());
        }
    }

    private void visitPrimitiveWrap(MethodVisitor methodVisitor, Class<?> type) {
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            methodVisitor.visitMethodInsn(184, Types.IN_Boolean, "valueOf", Types.methodDescriptor(Boolean.class, Boolean.TYPE), false);
        } else if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            methodVisitor.visitMethodInsn(184, Types.IN_Byte, "valueOf", Types.methodDescriptor(Byte.class, Byte.TYPE), false);
        } else if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            methodVisitor.visitMethodInsn(184, Types.IN_Short, "valueOf", Types.methodDescriptor(Short.class, Short.TYPE), false);
        } else if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            methodVisitor.visitMethodInsn(184, Types.IN_Character, "valueOf", Types.methodDescriptor(Character.class, Character.TYPE), false);
        } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            methodVisitor.visitMethodInsn(184, Types.IN_Integer, "valueOf", Types.methodDescriptor(Integer.class, Integer.TYPE), false);
        } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            methodVisitor.visitMethodInsn(184, Types.IN_Long, "valueOf", Types.methodDescriptor(Long.class, Long.TYPE), false);
        } else if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            methodVisitor.visitMethodInsn(184, Types.IN_Float, "valueOf", Types.methodDescriptor(Float.class, Float.TYPE), false);
        } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            methodVisitor.visitMethodInsn(184, Types.IN_Double, "valueOf", Types.methodDescriptor(Double.class, Double.TYPE), false);
        } else if (type.equals(String.class)) {
            methodVisitor.visitMethodInsn(184, Types.IN_String, "valueOf", Types.methodDescriptor(String.class, Object.class), false);
        }
    }

    private void visitType(MethodVisitor methodVisitor, Object typeOrClass) {
        if (Type.VOID_TYPE.equals(typeOrClass) || Void.TYPE.equals(typeOrClass)) {
            methodVisitor.visitFieldInsn(178, Types.IN_Void, "TYPE", "Ljava/lang/Class;");
        } else if (Type.BOOLEAN_TYPE.equals(typeOrClass) || Boolean.TYPE.equals(typeOrClass)) {
            methodVisitor.visitFieldInsn(178, Types.IN_Boolean, "TYPE", "Ljava/lang/Class;");
        } else if (Type.BYTE_TYPE.equals(typeOrClass) || Byte.TYPE.equals(typeOrClass)) {
            methodVisitor.visitFieldInsn(178, Types.IN_Byte, "TYPE", "Ljava/lang/Class;");
        } else if (Type.SHORT_TYPE.equals(typeOrClass) || Short.TYPE.equals(typeOrClass)) {
            methodVisitor.visitFieldInsn(178, Types.IN_Short, "TYPE", "Ljava/lang/Class;");
        } else if (Type.CHAR_TYPE.equals(typeOrClass) || Character.TYPE.equals(typeOrClass)) {
            methodVisitor.visitFieldInsn(178, Types.IN_Character, "TYPE", "Ljava/lang/Class;");
        } else if (Type.INT_TYPE.equals(typeOrClass) || Integer.TYPE.equals(typeOrClass)) {
            methodVisitor.visitFieldInsn(178, Types.IN_Integer, "TYPE", "Ljava/lang/Class;");
        } else if (Type.LONG_TYPE.equals(typeOrClass) || Long.TYPE.equals(typeOrClass)) {
            methodVisitor.visitFieldInsn(178, Types.IN_Long, "TYPE", "Ljava/lang/Class;");
        } else if (Type.FLOAT_TYPE.equals(typeOrClass) || Float.TYPE.equals(typeOrClass)) {
            methodVisitor.visitFieldInsn(178, Types.IN_Float, "TYPE", "Ljava/lang/Class;");
        } else if (Type.DOUBLE_TYPE.equals(typeOrClass) || Double.TYPE.equals(typeOrClass)) {
            methodVisitor.visitFieldInsn(178, Types.IN_Double, "TYPE", "Ljava/lang/Class;");
        } else if (typeOrClass instanceof Class) {
            methodVisitor.visitLdcInsn((Object)Types.type(typeOrClass));
        } else if (typeOrClass instanceof Type) {
            methodVisitor.visitLdcInsn(typeOrClass);
        } else {
            throw new IllegalArgumentException("Unexpected type or class: " + typeOrClass);
        }
    }
}

