/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.utils;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.log.Logger;

@ParametersAreNonnullByDefault
public class HotswapClassLoader
extends ClassLoader {
    private final Map<String, byte[]> hotswapClasses;

    public HotswapClassLoader() {
        ClassLoader.registerAsParallelCapable();
        this.hotswapClasses = new HashMap<String, byte[]>();
    }

    public byte[] getHotswapClass(String name) {
        return this.hotswapClasses.computeIfAbsent(name, n -> ASMUtils.toStacklessBytes(ASMUtils.createEmptyClass(n)));
    }

    public void defineHotswapClass(String name) {
        if (this.hotswapClasses.containsKey(name)) {
            return;
        }
        try {
            byte[] classBytes = this.getHotswapClass(name);
            Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
            clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            Logger.warn("Failed to define hotswap class '{}'. Hotswapping will not work for this transformer", name, t);
        }
    }
}

