/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.types;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.exceptions.MethodNotFoundException;
import net.lenni0451.classtransform.exceptions.SliceException;
import net.lenni0451.classtransform.exceptions.TransformerException;
import net.lenni0451.classtransform.transformer.types.RemovingAnnotationHandler;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.MemberDeclaration;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public abstract class RemovingTargetAnnotationHandler<T extends Annotation>
extends RemovingAnnotationHandler<T> {
    private final Function<T, String[]> targetCombis;

    public RemovingTargetAnnotationHandler(Class<T> annotationClass, Function<T, String[]> targetCombis) {
        super(annotationClass);
        this.targetCombis = targetCombis;
    }

    @Override
    public final void transform(T annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod) {
        for (String targetCombi : this.targetCombis.apply(annotation)) {
            List<MethodNode> targets;
            if (targetCombi.isEmpty()) {
                throw new TransformerException(transformerMethod, transformer, "Target is empty");
            }
            if (targetCombi.matches("^(?>L([^;]+);|([^.]+)\\.)([^(]+)(\\([^)]*\\).+)$")) {
                MemberDeclaration declaration = ASMUtils.splitMemberDeclaration(targetCombi);
                if (declaration == null) {
                    throw new TransformerException(transformerMethod, transformer, "Target is not a valid method declaration");
                }
                if (!transformedClass.name.equals(declaration.getOwner())) continue;
                targetCombi = declaration.getName() + declaration.getDesc();
            }
            if ((targets = ASMUtils.getMethodsFromCombi(transformedClass, targetCombi)).isEmpty()) {
                throw new MethodNotFoundException(transformedClass, transformer, targetCombi);
            }
            for (MethodNode target : targets) {
                try {
                    this.transform(annotation, transformerManager, transformedClass, transformer, ASMUtils.cloneMethod(transformerMethod), target);
                }
                catch (SliceException e) {
                    throw new TransformerException(transformerMethod, transformer, "- " + e.getMessage());
                }
            }
        }
    }

    public abstract void transform(T var1, TransformerManager var2, ClassNode var3, ClassNode var4, MethodNode var5, MethodNode var6);
}

