/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.annotations.injection.CWrapCatch;
import net.lenni0451.classtransform.exceptions.TransformerException;
import net.lenni0451.classtransform.targets.IInjectionTarget;
import net.lenni0451.classtransform.transformer.coprocessor.AnnotationCoprocessorList;
import net.lenni0451.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.CTargetImpl;
import net.lenni0451.classtransform.utils.Codifier;
import net.lenni0451.classtransform.utils.Types;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@ParametersAreNonnullByDefault
public class CWrapCatchAnnotationHandler
extends RemovingTargetAnnotationHandler<CWrapCatch> {
    public CWrapCatchAnnotationHandler() {
        super(CWrapCatch.class, CWrapCatch::value);
    }

    @Override
    public void transform(CWrapCatch annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        AnnotationCoprocessorList coprocessors = transformerManager.getCoprocessors();
        transformerMethod = coprocessors.preprocess(transformerManager, transformedClass, target, transformer, transformerMethod);
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        Type[] args = Types.argumentTypes(transformerMethod.desc);
        Type returnType = Types.returnType(transformerMethod.desc);
        if (args.length != 1) {
            throw new TransformerException(transformerMethod, transformer, "must have one argument (Exception to catch)").help(Codifier.of(transformerMethod).params(null, Types.type(Exception.class)));
        }
        MethodNode copiedTransformerMethod = null;
        ArrayList<MethodInsnNode> transformerMethodCalls = new ArrayList<MethodInsnNode>();
        if (annotation.target().isEmpty()) {
            MethodInsnNode transformerCall;
            Type targetReturnType = Types.returnType(target.desc);
            if (!ASMUtils.compareType(targetReturnType, returnType)) {
                throw new TransformerException(transformerMethod, transformer, "must have the same return type as the target method").help(Codifier.of(transformerMethod).returnType(targetReturnType));
            }
            boolean cast = !targetReturnType.equals((Object)returnType);
            Type exceptionType = args[0];
            copiedTransformerMethod = this.renameAndCopy(transformerMethod, target, transformer, transformedClass, "CWrapCatch");
            LabelNode start = new LabelNode();
            LabelNode end_handler = new LabelNode();
            target.instructions.insertBefore(target.instructions.getFirst(), (AbstractInsnNode)start);
            target.instructions.add((AbstractInsnNode)end_handler);
            if (Modifier.isStatic(target.access)) {
                transformerCall = new MethodInsnNode(184, transformedClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(transformedClass.access));
            } else {
                target.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                target.instructions.add((AbstractInsnNode)new InsnNode(95));
                transformerCall = new MethodInsnNode(Modifier.isInterface(transformedClass.access) ? 185 : 182, transformedClass.name, transformerMethod.name, transformerMethod.desc);
            }
            target.instructions.add((AbstractInsnNode)transformerCall);
            if (cast) {
                target.instructions.add((AbstractInsnNode)new TypeInsnNode(192, Types.returnType(target.desc).getInternalName()));
            }
            target.instructions.add((AbstractInsnNode)new InsnNode(ASMUtils.getReturnOpcode(returnType)));
            target.tryCatchBlocks.add(new TryCatchBlockNode(start, end_handler, end_handler, exceptionType.getInternalName()));
            transformerMethodCalls.add(transformerCall);
        } else {
            Map<String, IInjectionTarget> injectionTargets = transformerManager.getInjectionTargets();
            List<AbstractInsnNode> targetInstructions = injectionTargets.get("INVOKE").getTargets(injectionTargets, target, CTargetImpl.invoke(annotation.target(), annotation.ordinal()), annotation.slice());
            for (AbstractInsnNode instruction : targetInstructions) {
                MethodInsnNode transformerCall;
                Type instructionReturnType = Types.returnType(((MethodInsnNode)instruction).desc);
                if (!ASMUtils.compareType(instructionReturnType, returnType)) {
                    throw new TransformerException(transformerMethod, transformer, "must have the same return type as the target instruction").help(Codifier.of(transformerMethod).returnType(instructionReturnType));
                }
                boolean cast = !instructionReturnType.equals((Object)returnType);
                Type exceptionType = args[0];
                if (copiedTransformerMethod == null) {
                    copiedTransformerMethod = this.renameAndCopy(transformerMethod, target, transformer, transformedClass, "CWrapCatch");
                }
                InsnList insertAfter = new InsnList();
                LabelNode start = new LabelNode();
                LabelNode endHandler = new LabelNode();
                LabelNode jumpAfter = new LabelNode();
                target.instructions.insertBefore(instruction, (AbstractInsnNode)start);
                insertAfter.add((AbstractInsnNode)new JumpInsnNode(167, jumpAfter));
                insertAfter.add((AbstractInsnNode)endHandler);
                if (Modifier.isStatic(target.access)) {
                    transformerCall = new MethodInsnNode(184, transformedClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(transformedClass.access));
                } else {
                    insertAfter.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insertAfter.add((AbstractInsnNode)new InsnNode(95));
                    transformerCall = new MethodInsnNode(Modifier.isInterface(transformedClass.access) ? 185 : 182, transformedClass.name, transformerMethod.name, transformerMethod.desc);
                }
                insertAfter.add((AbstractInsnNode)transformerCall);
                if (cast) {
                    insertAfter.add((AbstractInsnNode)new TypeInsnNode(192, Types.returnType(target.desc).getInternalName()));
                }
                insertAfter.add((AbstractInsnNode)new InsnNode(ASMUtils.getReturnOpcode(returnType)));
                insertAfter.add((AbstractInsnNode)jumpAfter);
                target.instructions.insert(instruction, insertAfter);
                target.tryCatchBlocks.add(new TryCatchBlockNode(start, endHandler, endHandler, exceptionType.getInternalName()));
                transformerMethodCalls.add(transformerCall);
            }
        }
        coprocessors.postprocess(transformerManager, transformedClass, target, transformerMethodCalls, transformer, copiedTransformerMethod);
    }
}

