/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.mod;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class ExtensionPrototype {
    @Nullable
    private final @UnmodifiableView Map<String, String> definedProperties;
    public boolean enabled;
    public final List<URL> originURLs;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public ExtensionPrototype(List<URL> originURLs) {
        this(originURLs, false, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public ExtensionPrototype(List<URL> originURLs, boolean enabled) {
        this(originURLs, enabled, null);
    }

    @ApiStatus.AvailableSince(value="4.0.0-a20240711")
    @Contract(pure=true)
    public ExtensionPrototype(List<URL> originURLs, boolean enabled, @Nullable Map<String, String> properties) {
        this.originURLs = originURLs;
        this.enabled = enabled;
        if (properties != null) {
            properties = Collections.unmodifiableMap(properties);
        }
        this.definedProperties = properties;
    }

    @Nullable
    @ApiStatus.AvailableSince(value="4.0.0-a20240711")
    @Contract(pure=true)
    public @UnmodifiableView Map<String, String> getDefinedProperties() {
        return this.definedProperties;
    }

    public String toString() {
        return "ExtensionPrototype[URLs=" + this.originURLs + "]";
    }
}

