/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.impl.redirect;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.Types;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@ParametersAreNonnullByDefault
public interface IRedirectTarget {
    public void inject(ClassNode var1, MethodNode var2, ClassNode var3, MethodNode var4, AbstractInsnNode var5, List<MethodInsnNode> var6);

    default public InsnList[] getLoadStoreOpcodes(@Nullable String owner, String desc, int freeVarIndex) {
        Type[] argumentTypes;
        InsnList storeOpcodes = new InsnList();
        InsnList loadOpcodes = new InsnList();
        if (owner != null) {
            Type ownerType = Types.type(owner);
            storeOpcodes.add((AbstractInsnNode)new VarInsnNode(ASMUtils.getStoreOpcode(ownerType), freeVarIndex));
            loadOpcodes.add((AbstractInsnNode)new VarInsnNode(ASMUtils.getLoadOpcode(ownerType), freeVarIndex));
            freeVarIndex += ownerType.getSize();
        }
        for (Type argumentType : argumentTypes = Types.argumentTypes(desc)) {
            int storeOpcode = ASMUtils.getStoreOpcode(argumentType);
            int loadOpcode = ASMUtils.getLoadOpcode(argumentType);
            storeOpcodes.add((AbstractInsnNode)new VarInsnNode(storeOpcode, freeVarIndex));
            loadOpcodes.add((AbstractInsnNode)new VarInsnNode(loadOpcode, freeVarIndex));
            freeVarIndex += argumentType.getSize();
        }
        InsnList reversedStoreOpcodes = new InsnList();
        for (int i = storeOpcodes.size() - 1; i >= 0; --i) {
            reversedStoreOpcodes.add(storeOpcodes.get(i));
        }
        return new InsnList[]{reversedStoreOpcodes, loadOpcodes};
    }
}

