/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform;

import javax.annotation.Nullable;

public class InjectionCallback {
    private final boolean cancellable;
    private boolean cancelled;
    private Object returnValue;
    private boolean returnValueSet;

    public InjectionCallback(boolean cancellable) {
        this.cancellable = cancellable;
    }

    public InjectionCallback(boolean cancellable, @Nullable Object returnValue) {
        this.cancellable = cancellable;
        this.returnValue = returnValue;
        this.returnValueSet = true;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        if (cancelled && !this.cancellable) {
            throw new IllegalArgumentException("Cannot cancel a non-cancellable callback");
        }
        this.cancelled = cancelled;
    }

    @Nullable
    public Object getReturnValue() {
        if (!this.returnValueSet) {
            throw new IllegalStateException("Return value not set");
        }
        return this.returnValue;
    }

    @Nullable
    public <T> T castReturnValue() {
        return (T)this.getReturnValue();
    }

    public void setReturnValue(@Nullable Object returnValue) {
        this.setCancelled(true);
        this.returnValue = returnValue;
        this.returnValueSet = true;
    }
}

