/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class Types {
    public static final Type T_Object = Type.getType(Object.class);
    public static final String IN_Object = Types.internalName(Object.class);
    public static final String IN_String = Types.internalName(String.class);
    public static final String IN_Void = Types.internalName(Void.class);
    public static final String IN_Boolean = Types.internalName(Boolean.class);
    public static final String IN_Byte = Types.internalName(Byte.class);
    public static final String IN_Short = Types.internalName(Short.class);
    public static final String IN_Character = Types.internalName(Character.class);
    public static final String IN_Integer = Types.internalName(Integer.class);
    public static final String IN_Long = Types.internalName(Long.class);
    public static final String IN_Float = Types.internalName(Float.class);
    public static final String IN_Double = Types.internalName(Double.class);
    public static final String MD_Void = Types.methodDescriptor(Void.TYPE, new Object[0]);
    public static final String MN_Init = "<init>";
    public static final String MN_Clinit = "<clinit>";

    public static boolean isPrimitive(Type type) {
        if (type.equals((Object)Type.VOID_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return true;
        }
        return type.equals((Object)Type.DOUBLE_TYPE);
    }

    public static Type type(Object ob) {
        if (ob instanceof String) {
            String s = (String)ob;
            try {
                return Type.getType((String)s);
            }
            catch (Throwable t) {
                return Type.getObjectType((String)s);
            }
        }
        if (ob instanceof Class) {
            return Type.getType((Class)((Class)ob));
        }
        if (ob instanceof Field) {
            return Type.getType(((Field)ob).getType());
        }
        if (ob instanceof Method) {
            return Type.getType((Method)((Method)ob));
        }
        if (ob instanceof Constructor) {
            return Type.getType((Constructor)((Constructor)ob));
        }
        if (ob instanceof Type) {
            return (Type)ob;
        }
        throw new IllegalArgumentException("Unable to convert " + Types.asString(ob) + " into a type");
    }

    public static Type returnType(Object ob) {
        if (ob instanceof String) {
            return Type.getReturnType((String)((String)ob));
        }
        if (ob instanceof Method) {
            return Type.getReturnType((Method)((Method)ob));
        }
        if (ob instanceof MethodNode) {
            return Type.getReturnType((String)((MethodNode)ob).desc);
        }
        if (ob instanceof MethodInsnNode) {
            return Type.getReturnType((String)((MethodInsnNode)ob).desc);
        }
        if (ob instanceof Type) {
            return ((Type)ob).getReturnType();
        }
        throw new IllegalArgumentException("Unable to get return type of " + Types.asString(ob));
    }

    public static Type[] argumentTypes(Object ob) {
        if (ob instanceof String) {
            return Type.getArgumentTypes((String)((String)ob));
        }
        if (ob instanceof Method) {
            return Type.getArgumentTypes((Method)((Method)ob));
        }
        if (ob instanceof MethodNode) {
            return Type.getArgumentTypes((String)((MethodNode)ob).desc);
        }
        if (ob instanceof MethodInsnNode) {
            return Type.getArgumentTypes((String)((MethodInsnNode)ob).desc);
        }
        throw new IllegalArgumentException("Unable to get argument types of " + ob);
    }

    public static String internalName(Object ob) {
        try {
            return Types.type(ob).getInternalName();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Unable to get internal name of " + Types.asString(ob), t);
        }
    }

    public static String typeDescriptor(Object ob) {
        try {
            return Types.type(ob).getDescriptor();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Unable to convert " + Types.asString(ob) + " into a descriptor", t);
        }
    }

    public static String methodDescriptor(Object returnType, Object ... arguments) {
        if (returnType instanceof Method) {
            if (arguments.length != 0) {
                throw new IllegalArgumentException("Expected arguments to be empty");
            }
            return Type.getMethodDescriptor((Method)((Method)returnType));
        }
        if (returnType instanceof Constructor) {
            if (arguments.length != 0) {
                throw new IllegalArgumentException("Expected arguments to be empty");
            }
            return Type.getConstructorDescriptor((Constructor)((Constructor)returnType));
        }
        StringBuilder out = new StringBuilder("(");
        for (Object argument : arguments) {
            out.append(Types.typeDescriptor(argument));
        }
        out.append(")").append(Types.typeDescriptor(returnType));
        return out.toString();
    }

    private static String asString(@Nullable Object ob) {
        if (ob == null) {
            return "null";
        }
        return ob.toString();
    }
}

