/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.mappings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.mappings.InfoFiller;
import net.lenni0451.classtransform.mappings.MapperConfig;
import net.lenni0451.classtransform.mappings.annotation.AnnotationRemap;
import net.lenni0451.classtransform.mappings.annotation.RemapType;
import net.lenni0451.classtransform.mappings.dynamic.IDynamicRemapper;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.FailStrategy;
import net.lenni0451.classtransform.utils.MemberDeclaration;
import net.lenni0451.classtransform.utils.Types;
import net.lenni0451.classtransform.utils.annotations.AnnotationUtils;
import net.lenni0451.classtransform.utils.log.Logger;
import net.lenni0451.classtransform.utils.mappings.MapRemapper;
import net.lenni0451.classtransform.utils.mappings.Remapper;
import net.lenni0451.classtransform.utils.mappings.SuperMappingFiller;
import net.lenni0451.classtransform.utils.tree.ClassTree;
import net.lenni0451.classtransform.utils.tree.IClassProvider;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public abstract class AMapper {
    private final MapperConfig config;
    protected final MapRemapper remapper;
    private boolean initialized = false;
    private ClassTree superMappingsTree = null;

    public AMapper(MapperConfig config) {
        this.config = config;
        this.remapper = new MapRemapper();
    }

    public final synchronized void load() {
        if (this.initialized) {
            return;
        }
        try {
            this.init();
            this.initialized = true;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to initialize mappings", t);
        }
    }

    public final String mapClassName(String className) {
        return ASMUtils.dot(this.remapper.mapType(ASMUtils.slash(className)));
    }

    @Deprecated
    public final ClassNode mapClass(ClassTree classTree, IClassProvider classProvider, ClassNode target, ClassNode transformer) {
        Field field = ClassTree.class.getDeclaredField("transformerManager");
        field.setAccessible(true);
        TransformerManager transformerManager = (TransformerManager)field.get(classTree);
        if (transformerManager == null) {
            transformerManager = new TransformerManager(classProvider);
            field = TransformerManager.class.getDeclaredField("classTree");
            field.setAccessible(true);
            field.set(transformerManager, classTree);
        }
        return this.mapClass(transformerManager, target, transformer);
    }

    public final ClassNode mapClass(TransformerManager transformerManager, ClassNode target, ClassNode transformer) {
        this.fillTransformerSuperMappings(transformerManager, transformer);
        ArrayList<AnnotationHolder> annotationsToRemap = new ArrayList<AnnotationHolder>();
        this.checkAnnotations(transformer, transformer.visibleAnnotations, annotationsToRemap);
        this.checkAnnotations(transformer, transformer.invisibleAnnotations, annotationsToRemap);
        for (FieldNode field : transformer.fields) {
            this.checkAnnotations(field, field.visibleAnnotations, annotationsToRemap);
            this.checkAnnotations(field, field.invisibleAnnotations, annotationsToRemap);
        }
        for (MethodNode method : transformer.methods) {
            this.checkAnnotations(method, method.visibleAnnotations, annotationsToRemap);
            this.checkAnnotations(method, method.invisibleAnnotations, annotationsToRemap);
        }
        for (AnnotationHolder annotation : annotationsToRemap) {
            Class<?> annotationClass;
            try {
                annotationClass = Class.forName(Types.type(((AnnotationHolder)annotation).annotation.desc).getClassName());
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            try {
                Map<String, Object> annotationMap = AnnotationUtils.listToMap(((AnnotationHolder)annotation).annotation.values);
                this.mapAnnotation(annotation.holder, annotationClass, annotationMap, transformerManager, target, transformer);
                ((AnnotationHolder)annotation).annotation.values = AnnotationUtils.mapToList(annotationMap);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to remap annotation '" + ((AnnotationHolder)annotation).annotation.desc + "' from transformer '" + transformer.name + "'", e);
            }
        }
        if (this.config.remapTransformer) {
            return Remapper.remap(transformer, this.remapper);
        }
        return transformer;
    }

    public MapRemapper getRemapper() {
        return this.remapper;
    }

    protected abstract void init() throws Throwable;

    protected List<String> readLines(File f) throws IOException {
        return this.readLines(new FileInputStream(f));
    }

    protected List<String> readLines(InputStream is) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            List<String> list = br.lines().collect(Collectors.toList());
            return list;
        }
    }

    private ClassTree getSuperMappingsTree(TransformerManager transformerManager) {
        if (!transformerManager.getClassTree().canTransform()) {
            return transformerManager.getClassTree();
        }
        if (this.superMappingsTree == null) {
            this.superMappingsTree = new ClassTree();
        }
        return this.superMappingsTree;
    }

    private void fillTransformerSuperMappings(TransformerManager transformerManager, ClassNode transformer) {
        block5: {
            if (!this.config.fillSuperMappings) {
                return;
            }
            try {
                SuperMappingFiller.fillTransformerSuperMembers(transformer, this.remapper, this.getSuperMappingsTree(transformerManager), transformerManager.getClassProvider());
            }
            catch (Throwable t) {
                if (FailStrategy.CONTINUE.equals((Object)this.config.superMappingsFailStrategy)) {
                    Logger.warn("Unable to fill super mappings for class '{}'. Trying without", transformer.name, t);
                }
                if (FailStrategy.CANCEL.equals((Object)this.config.superMappingsFailStrategy)) {
                    throw new RuntimeException("Unable to fill super mappings for class '" + transformer.name + "'", t);
                }
                if (!FailStrategy.EXIT.equals((Object)this.config.superMappingsFailStrategy)) break block5;
                System.exit(-1);
            }
        }
    }

    private void fillSuperMembers(String className, TransformerManager transformerManager) {
        block5: {
            if (!this.config.fillSuperMappings) {
                return;
            }
            try {
                SuperMappingFiller.fillSuperMembers(className, this.remapper, this.getSuperMappingsTree(transformerManager), transformerManager.getClassProvider());
            }
            catch (Throwable t) {
                if (FailStrategy.CONTINUE.equals((Object)this.config.superMappingsFailStrategy)) {
                    Logger.warn("Unable to fill super mappings for class '{}'. Trying without", className, t);
                }
                if (FailStrategy.CANCEL.equals((Object)this.config.superMappingsFailStrategy)) {
                    throw new RuntimeException("Unable to fill super mappings for class '" + className + "'", t);
                }
                if (!FailStrategy.EXIT.equals((Object)this.config.superMappingsFailStrategy)) break block5;
                System.exit(-1);
            }
        }
    }

    private void mapAnnotation(Object holder, Class<?> annotation, Map<String, Object> values, TransformerManager transformerManager, ClassNode target, ClassNode transformer) throws ClassNotFoundException {
        for (Method method : annotation.getDeclaredMethods()) {
            Object value;
            AnnotationRemap remap = method.getDeclaredAnnotation(AnnotationRemap.class);
            if (remap == null) continue;
            RemapType remapType = remap.value();
            if (remapType.equals((Object)RemapType.DYNAMIC)) {
                try {
                    IDynamicRemapper dynamicRemapper = remap.dynamicRemapper().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    remapType = dynamicRemapper.dynamicRemap(this, annotation, values, method, transformerManager, target, transformer);
                    if (remapType == null || remapType.equals((Object)RemapType.DYNAMIC)) {
                        continue;
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unable to create instance of dynamic remapper '" + remap.dynamicRemapper().getName() + "'", t);
                }
            }
            if (remapType.equals((Object)RemapType.SHORT_MEMBER)) {
                InfoFiller.fillInfo(this.remapper, holder, remap, method, values, target, transformer);
            }
            if (this.remapper.isEmpty() || (value = values.get(method.getName())) == null) continue;
            if (remapType.equals((Object)RemapType.ANNOTATION)) {
                Object nodes;
                if (value instanceof AnnotationNode) {
                    AnnotationNode node = (AnnotationNode)value;
                    Type type = Type.getType((String)node.desc);
                    Map<String, Object> nodeMap = AnnotationUtils.listToMap(node.values);
                    this.mapAnnotation(holder, Class.forName(type.getClassName()), nodeMap, transformerManager, target, transformer);
                    node.values = AnnotationUtils.mapToList(nodeMap);
                    continue;
                }
                if (value instanceof AnnotationNode[]) {
                    nodes = (AnnotationNode[])value;
                    for (AnnotationNode node : nodes) {
                        Type type = Type.getType((String)node.desc);
                        Map<String, Object> nodeMap = AnnotationUtils.listToMap(node.values);
                        this.mapAnnotation(holder, Class.forName(type.getClassName()), nodeMap, transformerManager, target, transformer);
                        node.values = AnnotationUtils.mapToList(nodeMap);
                    }
                    continue;
                }
                if (value instanceof List) {
                    nodes = (List)value;
                    Iterator type = nodes.iterator();
                    while (type.hasNext()) {
                        AnnotationNode node = (AnnotationNode)type.next();
                        Type type2 = Type.getType((String)node.desc);
                        Map<String, Object> nodeMap = AnnotationUtils.listToMap(node.values);
                        this.mapAnnotation(holder, Class.forName(type2.getClassName()), nodeMap, transformerManager, target, transformer);
                        node.values = AnnotationUtils.mapToList(nodeMap);
                    }
                    continue;
                }
                throw new IllegalStateException("Unexpected value type '" + value.getClass().getName() + "' for annotation '" + annotation.getName() + "' value '" + annotation.getName() + "'");
            }
            if (value instanceof String) {
                String s2 = (String)value;
                values.put(method.getName(), this.remap(remapType, s2, transformerManager));
                continue;
            }
            if (value instanceof String[]) {
                String[] strings = (String[])value;
                for (int i = 0; i < strings.length; ++i) {
                    strings[i] = this.remap(remapType, strings[i], transformerManager);
                }
                continue;
            }
            if (value instanceof List) {
                RemapType finalRemapType = remapType;
                List list = (List)value;
                list.replaceAll(s -> this.remap(finalRemapType, (String)s, transformerManager));
                continue;
            }
            throw new IllegalStateException("Unexpected value type '" + value.getClass().getName() + "' for annotation '" + annotation.getName() + "' value '" + annotation.getName() + "'");
        }
    }

    private String remap(RemapType type, String s, TransformerManager transformerManager) {
        switch (type) {
            case SHORT_MEMBER: {
                return s;
            }
            case MEMBER: {
                String desc;
                String name;
                MemberDeclaration member = ASMUtils.splitMemberDeclaration(s);
                if (member == null) {
                    throw new IllegalStateException("Invalid member declaration '" + s + "'");
                }
                this.fillSuperMembers(member.getOwner(), transformerManager);
                String owner = this.remapper.mapType(member.getOwner());
                if (member.isFieldMapping()) {
                    name = this.remapper.mapFieldName(member.getOwner(), member.getName(), member.getDesc());
                    desc = this.remapper.mapDesc(member.getDesc());
                } else {
                    name = this.remapper.mapMethodName(member.getOwner(), member.getName(), member.getDesc());
                    desc = this.remapper.mapMethodDesc(member.getDesc());
                }
                return Type.getObjectType((String)owner).getDescriptor() + name + (member.isFieldMapping() ? ":" : "") + desc;
            }
            case DESCRIPTOR: {
                if (s.startsWith("(")) {
                    return this.remapper.mapMethodDesc(s);
                }
                return this.remapper.mapDesc(s);
            }
            case CLASS: {
                return ASMUtils.dot(this.remapper.mapType(ASMUtils.slash(s)));
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
    }

    private void checkAnnotations(Object holder, @Nullable List<AnnotationNode> annotations, List<AnnotationHolder> out) {
        if (annotations == null) {
            return;
        }
        for (AnnotationNode annotation : annotations) {
            out.add(new AnnotationHolder(holder, annotation));
        }
    }

    private static class AnnotationHolder {
        private final Object holder;
        private final AnnotationNode annotation;

        private AnnotationHolder(Object holder, AnnotationNode annotation) {
            this.holder = holder;
            this.annotation = annotation;
        }
    }
}

