/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.util;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DescString {
    private char[] asArray;
    private final String desc;
    private int startIndex = 0;

    public DescString(String desc) {
        int begin = 1;
        int end = desc.lastIndexOf(41);
        this.desc = desc.substring(begin, end);
    }

    public boolean hasNext() {
        return this.desc.length() != this.startIndex;
    }

    public int nextReferenceType() {
        int type = this.desc.codePointAt(this.startIndex);
        if (type == 76) {
            this.startIndex = this.desc.indexOf(59, this.startIndex) + 1;
        } else if (type == 91) {
            if (this.asArray == null) {
                this.asArray = this.desc.toCharArray();
            }
            int typePosition = -1;
            for (int i = this.startIndex + 1; i < this.asArray.length; ++i) {
                if (this.asArray[i] == '[') continue;
                typePosition = i;
                break;
            }
            this.startIndex = this.asArray[typePosition] == 'L' ? this.desc.indexOf(59, this.startIndex) + 1 : ++typePosition;
        } else {
            ++this.startIndex;
        }
        return type;
    }

    @NotNull
    public String nextType() {
        char type = this.desc.charAt(this.startIndex);
        if (type == 'L') {
            int endPos = this.desc.indexOf(59, this.startIndex) + 1;
            String ret = this.desc.substring(this.startIndex, endPos);
            this.startIndex = endPos;
            return ret;
        }
        if (type == '[') {
            if (this.asArray == null) {
                this.asArray = this.desc.toCharArray();
            }
            int typePosition = -1;
            for (int i = this.startIndex + 1; i < this.asArray.length; ++i) {
                if (this.asArray[i] == '[') continue;
                typePosition = i;
                break;
            }
            if (this.asArray[typePosition] == 'L') {
                int endPos = this.desc.indexOf(59, this.startIndex) + 1;
                String ret = this.desc.substring(this.startIndex, endPos);
                this.startIndex = endPos;
                return ret;
            }
            String ret = this.desc.substring(this.startIndex, ++typePosition);
            this.startIndex = typePosition;
            return ret;
        }
        ++this.startIndex;
        return Character.toString(type);
    }

    public void reset() {
        this.startIndex = 0;
    }
}

