/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.ClassNode;
import nilloader.api.lib.asm.tree.FieldInsnNode;
import nilloader.api.lib.asm.tree.FieldNode;
import nilloader.api.lib.asm.tree.InsnList;
import nilloader.api.lib.asm.tree.InsnNode;
import nilloader.api.lib.asm.tree.LabelNode;
import nilloader.api.lib.asm.tree.MethodInsnNode;
import nilloader.api.lib.asm.tree.MethodNode;
import nilloader.api.lib.asm.tree.TypeAnnotationNode;
import nilloader.api.lib.asm.tree.VarInsnNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.api.MixinLoggingFacade;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.api.SlicedInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.MixinStub;
import org.stianloader.micromixin.transform.internal.selectors.MixinTargetSelector;
import org.stianloader.micromixin.transform.internal.util.DescString;
import org.stianloader.micromixin.transform.internal.util.InjectionPointReference;

public class ASMUtil {
    public static final String CALLBACK_INFO_NAME = "org/spongepowered/asm/mixin/injection/callback/CallbackInfo";
    public static final String CALLBACK_INFO_DESC = "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;";
    public static final String CALLBACK_INFO_RETURNABLE_NAME = "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable";
    public static final String CALLBACK_INFO_RETURNABLE_DESC = "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;";
    public static final int CI_LEN = "org/spongepowered/asm/mixin/injection/callback/CallbackInfo".length();
    public static final int CIR_LEN = "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable".length();
    public static final String ROLL_ANNOT_DESC = "Lorg/stianloader/micromixin/internal/Roll;";
    public static final String UNROLL_ANNOT_DESC = "Lorg/stianloader/micromixin/internal/Unroll;";

    @NotNull
    public static AbstractInsnNode afterInstruction(@NotNull AbstractInsnNode insn) {
        AbstractInsnNode next;
        for (next = insn.getNext(); next != null && next.getOpcode() == -1; next = next.getNext()) {
        }
        if (next == null) {
            return insn;
        }
        return next;
    }

    @NotNull
    public static Collection<InjectionPointReference> enumerateTargets(@NotNull Collection<MixinTargetSelector> selectors, @NotNull Collection<SlicedInjectionPointSelector> ats, @NotNull ClassNode target, @NotNull MixinStub mixinSource, @NotNull MethodNode injectMethodSource, int require, int expect, int allow, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder, @NotNull MixinLoggingFacade logger) {
        HashMap<AbstractInsnNode, InjectionPointReference> matched = new HashMap<AbstractInsnNode, InjectionPointReference>();
        for (MixinTargetSelector selector : selectors) {
            for (SlicedInjectionPointSelector at : ats) {
                MethodNode targetMethod = selector.selectMethod(target, mixinSource);
                if (targetMethod == null) continue;
                if (targetMethod.name.equals("<init>") && !at.supportsConstructors()) {
                    throw new IllegalStateException("Illegal mixin: " + mixinSource.sourceNode.name + "." + injectMethodSource.name + injectMethodSource.desc + " targets " + target.name + ".<init>" + targetMethod.desc + ", which is a constructor. However the selector @At(\"" + at.getQualifiedSelectorName() + "\") does not support usage within a constructor.");
                }
                if ((targetMethod.access & 8) != 0) {
                    if ((injectMethodSource.access & 8) == 0) {
                        throw new IllegalStateException("Illegal mixin: " + mixinSource.sourceNode.name + "." + injectMethodSource.name + injectMethodSource.desc + " targets " + target.name + "." + targetMethod.name + targetMethod.desc + " target is static, but the mixin is not.");
                    }
                    if ((injectMethodSource.access & 1) != 0) {
                        throw new IllegalStateException("Illegal mixin: " + mixinSource.sourceNode.name + "." + injectMethodSource.name + injectMethodSource.desc + " targets " + target.name + "." + targetMethod.name + targetMethod.desc + " target is static, but the mixin is public. A mixin may not be static and public at the same time for whatever odd reasons.");
                    }
                } else if ((injectMethodSource.access & 8) != 0) {
                    throw new IllegalStateException("Illegal mixin: " + mixinSource.sourceNode.name + "." + injectMethodSource.name + injectMethodSource.desc + " targets " + target.name + "." + targetMethod.name + targetMethod.desc + " target is not static, but the callback handler is.");
                }
                ArrayDeque<String> path = new ArrayDeque<String>();
                path.add(mixinSource.sourceNode.name);
                path.add(injectMethodSource.name + injectMethodSource.desc);
                at.verifySlices(Collections.asLifoQueue(path), targetMethod, remapper, sharedBuilder);
                for (AbstractInsnNode abstractInsnNode : at.getMatchedInstructions(targetMethod, remapper, sharedBuilder)) {
                    if (abstractInsnNode.getOpcode() == -1) {
                        throw new IllegalStateException("Selector " + at + " matched virtual instruction " + abstractInsnNode.getClass() + ". Declaring mixin " + mixinSource.sourceNode.name + "." + injectMethodSource.name + injectMethodSource.desc + " targets " + target.name + "." + targetMethod.name + targetMethod.desc);
                    }
                    matched.put(abstractInsnNode, new InjectionPointReference(abstractInsnNode, abstractInsnNode, targetMethod, at));
                }
            }
        }
        if (matched.size() < require) {
            throw new IllegalStateException("Illegal mixin: " + mixinSource.sourceNode.name + "." + injectMethodSource.name + injectMethodSource.desc + " requires at least" + require + " injection points but only found " + matched.size() + ".");
        }
        if (matched.size() < expect) {
            logger.warn(ASMUtil.class, "Potentially outdated mixin: {}.{} {} expects {} injection points but only found {}.", mixinSource.sourceNode.name, injectMethodSource.name, injectMethodSource.desc, expect, matched.size());
        }
        if (allow > 0 && matched.size() > allow) {
            throw new IllegalStateException("Illegal mixin: " + mixinSource.sourceNode.name + "." + injectMethodSource.name + injectMethodSource.desc + " allows up to " + allow + " injection points but " + matched.size() + " injection points were selected.");
        }
        Collection<InjectionPointReference> refs = matched.values();
        assert (refs != null);
        return refs;
    }

    public static int getArgumentCount(@NotNull String methodDesc) {
        DescString dstring = new DescString(methodDesc);
        int count = 0;
        while (dstring.hasNext()) {
            dstring.nextType();
            ++count;
        }
        return count;
    }

    @Nullable
    public static FieldNode getField(@NotNull ClassNode node, @NotNull String name, @NotNull String desc) {
        for (FieldNode field : node.fields) {
            if (!field.name.equals(name) || !field.desc.equals(desc)) continue;
            return field;
        }
        return null;
    }

    public static int getInitialFrameSize(@NotNull MethodNode method) {
        int initialFrameSize = 0;
        if ((method.access & 8) == 0) {
            ++initialFrameSize;
        }
        DescString descString = new DescString(method.desc);
        while (descString.hasNext()) {
            ++initialFrameSize;
            if (!ASMUtil.isCategory2(descString.nextReferenceType())) continue;
            ++initialFrameSize;
        }
        return initialFrameSize;
    }

    public static int getInputOperandCount(@NotNull AbstractInsnNode insn) {
        if (insn instanceof MethodInsnNode) {
            return ASMUtil.getArgumentCount(((MethodInsnNode)insn).desc) + (insn.getOpcode() == 184 ? 0 : 1);
        }
        if (insn instanceof FieldInsnNode) {
            if (insn.getOpcode() == 178) {
                return 0;
            }
            if (insn.getOpcode() == 179 || insn.getOpcode() == 180) {
                return 1;
            }
            return 2;
        }
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @NotNull
    public static List<String> getInputOperandTypes(AbstractInsnNode insn) {
        if (insn instanceof MethodInsnNode) {
            ArrayList<String> list = new ArrayList<String>();
            if (insn.getOpcode() != 184) {
                list.add("L" + ((MethodInsnNode)insn).owner + ";");
            }
            DescString dString = new DescString(((MethodInsnNode)insn).desc);
            while (dString.hasNext()) {
                list.add(dString.nextType());
            }
            return list;
        }
        if (insn instanceof FieldInsnNode) {
            if (insn.getOpcode() == 178) {
                return Collections.emptyList();
            }
            if (insn.getOpcode() == 179) {
                return Collections.singletonList(((FieldInsnNode)insn).desc);
            }
            if (insn.getOpcode() == 180) {
                return Collections.singletonList("L" + ((FieldInsnNode)insn).owner + ";");
            }
            List<String> list = Arrays.asList("L" + ((FieldInsnNode)insn).owner + ";", ((FieldInsnNode)insn).desc);
            if (list == null) {
                throw new AssertionError();
            }
            return list;
        }
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @NotNull
    public static LabelNode getLabelNodeBefore(@NotNull AbstractInsnNode insn, @NotNull InsnList merge) {
        AbstractInsnNode lookbehind = insn.getPrevious();
        while (lookbehind.getOpcode() == -1 && !(lookbehind instanceof LabelNode)) {
            if ((lookbehind = lookbehind.getPrevious()) != null) continue;
            LabelNode l = new LabelNode();
            merge.insert((AbstractInsnNode)l);
            return l;
        }
        if (lookbehind instanceof LabelNode) {
            return (LabelNode)lookbehind;
        }
        LabelNode l = new LabelNode();
        merge.insertBefore(insn, (AbstractInsnNode)l);
        return l;
    }

    @Nullable
    public static String getLastType(@NotNull String methodDesc) {
        DescString dstring = new DescString(methodDesc);
        String last = null;
        while (dstring.hasNext()) {
            last = dstring.nextType();
        }
        return last;
    }

    public static int getLoadOpcode(int descReturnType) {
        switch (descReturnType) {
            case 76: 
            case 91: {
                return 25;
            }
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                return 21;
            }
            case 74: {
                return 22;
            }
            case 70: {
                return 23;
            }
            case 68: {
                return 24;
            }
        }
        throw new IllegalStateException("Unknown return type: " + descReturnType + " (" + (char)descReturnType + ")");
    }

    public static int getLoadOpcodeFromMethodDesc(@NotNull String methodDesc) {
        return ASMUtil.getLoadOpcode(ASMUtil.getReturnComputationalType(methodDesc));
    }

    @Nullable
    public static MethodNode getMethod(@NotNull ClassNode node, @NotNull String name, @NotNull String desc) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals(name) || !method.desc.equals(desc)) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public static AbstractInsnNode getNext(AbstractInsnNode insn) {
        AbstractInsnNode next = insn.getNext();
        while (next.getOpcode() == -1) {
            next = next.getNext();
        }
        return next;
    }

    @NotNull
    public static String getRedirectHandlerSignature(@NotNull AbstractInsnNode insn) {
        switch (insn.getType()) {
            case 5: {
                MethodInsnNode minsn = (MethodInsnNode)insn;
                if (minsn.getOpcode() == 184) {
                    return minsn.desc;
                }
                return "(L" + minsn.owner + ";" + minsn.desc.substring(1);
            }
            case 4: {
                FieldInsnNode fInsn = (FieldInsnNode)insn;
                if (fInsn.getOpcode() == 178) {
                    return "()" + fInsn.desc;
                }
                if (fInsn.getOpcode() == 179) {
                    return "(" + fInsn.desc + ")V";
                }
                if (fInsn.getOpcode() == 181) {
                    return "(L" + fInsn.owner + ";" + fInsn.desc + ")V";
                }
                if (fInsn.getOpcode() == 180) {
                    return "(L" + fInsn.owner + ";)" + fInsn.desc;
                }
                throw new AssertionError((Object)("Unknown opcode: " + fInsn.getOpcode()));
            }
        }
        throw new UnsupportedOperationException("Instruction cannot be redirected (yet): " + insn + " of type " + insn.getType() + " (opcode " + insn.getOpcode() + ")");
    }

    public static int getReturnComputationalType(@NotNull String methodDesc) {
        return methodDesc.codePointAt(methodDesc.lastIndexOf(41) + 1);
    }

    public static int getReturnOpcode(int descReturnType) {
        switch (descReturnType) {
            case 86: {
                return 177;
            }
            case 76: 
            case 91: {
                return 176;
            }
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                return 172;
            }
            case 74: {
                return 173;
            }
            case 70: {
                return 174;
            }
            case 68: {
                return 175;
            }
        }
        throw new IllegalStateException("Unknown return type: " + descReturnType + " (" + (char)descReturnType + ")");
    }

    public static int getReturnOpcode(@NotNull String methodDesc) {
        return ASMUtil.getReturnOpcode(ASMUtil.getReturnComputationalType(methodDesc));
    }

    @NotNull
    public static String getReturnType(String methodDesc) {
        return methodDesc.substring(methodDesc.lastIndexOf(41) + 1);
    }

    public static int getShallowStashConfiguration(List<String> headTypes, int uniformDepth) {
        int foregroundBeginIndex = headTypes.size() - uniformDepth;
        if (foregroundBeginIndex == 0) {
            if (uniformDepth == 0) {
                return 0;
            }
            if (ASMUtil.isCategory2(headTypes.get(0).codePointAt(0)) || uniformDepth >= 2 && !ASMUtil.isCategory2(headTypes.get(1).codePointAt(0))) {
                return 2;
            }
            return 1;
        }
        int backgroundStack = ASMUtil.isCategory2(headTypes.get(foregroundBeginIndex - 1).codePointAt(0)) || foregroundBeginIndex != 1 && !ASMUtil.isCategory2(headTypes.get(foregroundBeginIndex - 2).codePointAt(0)) ? 2 : 1;
        int foregroundStack = ASMUtil.isCategory2(headTypes.get(foregroundBeginIndex).codePointAt(0)) || uniformDepth >= 2 && !ASMUtil.isCategory2(headTypes.get(foregroundBeginIndex + 1).codePointAt(0)) ? 2 : 1;
        return backgroundStack << 2 | foregroundStack;
    }

    public static int getStoreOpcode(int descReturnType) {
        switch (descReturnType) {
            case 76: 
            case 91: {
                return 58;
            }
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                return 54;
            }
            case 74: {
                return 55;
            }
            case 70: {
                return 56;
            }
            case 68: {
                return 57;
            }
        }
        throw new IllegalStateException("Unknown return type: " + descReturnType + " (" + (char)descReturnType + ")");
    }

    public static int getStoreOpcodeFromMethodDesc(@NotNull String methodDesc) {
        return ASMUtil.getStoreOpcode(ASMUtil.getReturnComputationalType(methodDesc));
    }

    @NotNull
    public static String getTargetDesc(@NotNull MethodNode method, @NotNull StringBuilder sharedBuilder) {
        sharedBuilder.setLength(0);
        sharedBuilder.append('(');
        DescString dstring = new DescString(method.desc);
        boolean ciPresent = false;
        while (dstring.hasNext()) {
            String selected = dstring.nextType();
            if (!selected.equals(CALLBACK_INFO_RETURNABLE_DESC) && !selected.equals(CALLBACK_INFO_DESC)) continue;
            ciPresent = true;
            break;
        }
        sharedBuilder.append(")V");
        if (!ciPresent) {
            throw new MixinParseException("Method " + method.name + method.desc + " should have a CallbackInfo or a CallbackInfoReturnable as one of it's arguments. But it does not.");
        }
        return sharedBuilder.toString();
    }

    public static boolean hasField(@NotNull ClassNode node, @NotNull String name, @NotNull String desc) {
        return ASMUtil.getField(node, name, desc) != null;
    }

    public static boolean hasMethod(@NotNull ClassNode node, @NotNull String name, @NotNull String desc) {
        return ASMUtil.getMethod(node, name, desc) != null;
    }

    public static boolean hasReducedAccess(int witnessAccess, int testAccess) {
        if ((witnessAccess & 1) != 0) {
            return (testAccess & 1) == 0;
        }
        if ((witnessAccess & 4) != 0) {
            return (testAccess & 5) == 0;
        }
        if ((witnessAccess & 2) != 0) {
            return false;
        }
        return (testAccess & 2) != 0;
    }

    public static boolean isBetween(AbstractInsnNode start, AbstractInsnNode end, @NotNull AbstractInsnNode insn) {
        AbstractInsnNode walkerInsn = start;
        while ((walkerInsn = walkerInsn.getNext()) != null && walkerInsn != insn) {
        }
        if (walkerInsn == null) {
            return false;
        }
        while ((walkerInsn = walkerInsn.getNext()) != null && walkerInsn != end) {
        }
        return walkerInsn != null;
    }

    public static boolean isCategory2(int descType) {
        return descType == 74 || descType == 68;
    }

    public static boolean isCategory2VarInsn(int opcode) {
        return opcode == 57 || opcode == 24 || opcode == 22 || opcode == 55;
    }

    public static boolean isLoad(int opcode) {
        return 21 <= opcode && opcode <= 25;
    }

    public static boolean isReturn(int opcode) {
        return 172 <= opcode && opcode <= 177;
    }

    public static boolean isStore(int opcode) {
        return 54 <= opcode && opcode <= 58;
    }

    public static void moveStackHead(MethodNode method, @NotNull AbstractInsnNode beginMoveInsn, @NotNull AbstractInsnNode endRollbackInsn, @NotNull List<String> headTypes, int uniformDepth, @NotNull InsnList moveOut, @NotNull InsnList rollbackOut) {
        int shallowStashConfig = ASMUtil.getShallowStashConfiguration(headTypes, uniformDepth);
        if (shallowStashConfig == 0) {
            return;
        }
        int shallowStashedElements = shallowStashConfig & 3;
        boolean cat2StashedElem = shallowStashedElements == 2 && ASMUtil.isCategory2(headTypes.get(headTypes.size() - uniformDepth).codePointAt(0));
        int deepStashedElementIndex = headTypes.size() - uniformDepth + (cat2StashedElem ? 1 : shallowStashedElements);
        LinkedHashSet<Integer> reusableLocals = new LinkedHashSet<Integer>();
        int highestLVTIndex = 0;
        LinkedHashSet<Integer> unusableLocals = new LinkedHashSet<Integer>();
        for (AbstractInsnNode insnNode = method.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (insnNode.getType() != 2) continue;
            int local = ((VarInsnNode)insnNode).var;
            boolean cat2 = ASMUtil.isCategory2VarInsn(insnNode.getOpcode());
            highestLVTIndex = Math.max(highestLVTIndex, cat2 ? local + 1 : local);
            List annots = insnNode.invisibleTypeAnnotations;
            if (annots == null) continue;
            boolean annotated = false;
            for (TypeAnnotationNode annot : annots) {
                if (!annot.desc.equals(ROLL_ANNOT_DESC) && !annot.desc.equals(UNROLL_ANNOT_DESC)) continue;
                annotated = true;
                if (cat2) {
                    reusableLocals.add(local);
                    reusableLocals.add(local + 1);
                    break;
                }
                reusableLocals.add(local);
                break;
            }
            if (annotated) continue;
            if (cat2) {
                unusableLocals.add(local);
                unusableLocals.add(local + 1);
                continue;
            }
            unusableLocals.add(local);
        }
        reusableLocals.removeAll(unusableLocals);
        for (int i = headTypes.size() - 1; i >= deepStashedElementIndex; --i) {
            int type = headTypes.get(i).codePointAt(0);
            boolean cat2 = ASMUtil.isCategory2(type);
            int localIndex = -1;
            Iterator it = reusableLocals.iterator();
            while (it.hasNext()) {
                int l0 = (Integer)it.next();
                if (cat2 && !reusableLocals.contains(l0 + 1)) continue;
                localIndex = l0;
                reusableLocals.remove(l0);
                if (!cat2) break;
                reusableLocals.remove(l0 + 1);
                break;
            }
            if (localIndex < 0) {
                ++highestLVTIndex;
                localIndex = highestLVTIndex++;
                if (cat2) {
                    // empty if block
                }
            }
            VarInsnNode storeInsn = new VarInsnNode(ASMUtil.getStoreOpcode(type), localIndex);
            VarInsnNode loadInsn = new VarInsnNode(ASMUtil.getLoadOpcode(type), localIndex);
            loadInsn.invisibleTypeAnnotations = new ArrayList();
            storeInsn.invisibleTypeAnnotations = new ArrayList();
            loadInsn.invisibleTypeAnnotations.add(new TypeAnnotationNode(0x49000000, null, ROLL_ANNOT_DESC));
            storeInsn.invisibleTypeAnnotations.add(new TypeAnnotationNode(0x49000000, null, UNROLL_ANNOT_DESC));
            rollbackOut.insert((AbstractInsnNode)loadInsn);
            moveOut.add((AbstractInsnNode)storeInsn);
        }
        switch (shallowStashConfig) {
            case 1: 
            case 2: {
                break;
            }
            case 5: {
                rollbackOut.insert((AbstractInsnNode)new InsnNode(87));
                rollbackOut.insert((AbstractInsnNode)new InsnNode(90));
                moveOut.add((AbstractInsnNode)new InsnNode(90));
                moveOut.add((AbstractInsnNode)new InsnNode(87));
                break;
            }
            case 6: {
                rollbackOut.insert((AbstractInsnNode)new InsnNode(87));
                rollbackOut.insert((AbstractInsnNode)new InsnNode(91));
                moveOut.add((AbstractInsnNode)new InsnNode(93));
                moveOut.add((AbstractInsnNode)new InsnNode(88));
                break;
            }
            case 9: {
                rollbackOut.insert((AbstractInsnNode)new InsnNode(88));
                rollbackOut.insert((AbstractInsnNode)new InsnNode(93));
                moveOut.add((AbstractInsnNode)new InsnNode(91));
                moveOut.add((AbstractInsnNode)new InsnNode(87));
                break;
            }
            case 10: {
                rollbackOut.insert((AbstractInsnNode)new InsnNode(88));
                rollbackOut.insert((AbstractInsnNode)new InsnNode(94));
                moveOut.add((AbstractInsnNode)new InsnNode(94));
                moveOut.add((AbstractInsnNode)new InsnNode(88));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown shallow stash config value: " + shallowStashConfig);
            }
        }
    }

    public static int popReturn(@NotNull String methodDesc) {
        switch (methodDesc.codePointBefore(methodDesc.length())) {
            case 59: 
            case 66: 
            case 67: 
            case 70: 
            case 73: 
            case 83: 
            case 90: {
                return 87;
            }
            case 68: 
            case 74: {
                return 88;
            }
            case 86: {
                return 0;
            }
        }
        throw new IllegalStateException("Unable to infer the required pop opcode corresponding to the return type of method descriptor: " + methodDesc);
    }

    public static AbstractInsnNode shiftInsn(AbstractInsnNode insn, int offset) {
        if (offset == 0) {
            return insn;
        }
        if (offset < 0) {
            while (offset++ != 0 && insn != null) {
                for (insn = insn.getPrevious(); insn != null && insn.getOpcode() == -1; insn = insn.getPrevious()) {
                }
            }
        } else {
            while (offset-- != 0 && insn != null) {
                insn = ASMUtil.getNext(insn);
            }
        }
        if (insn == null) {
            throw new IllegalStateException("Instruction shifted out of bounds. Perhaps the offset is too large?");
        }
        return insn;
    }

    public static int toOperandDepth(List<String> headTypes, int uniformDepth) {
        int operandDepth = 0;
        for (int i = 0; i < uniformDepth; ++i) {
            if (ASMUtil.isCategory2(headTypes.get(headTypes.size() - i).codePointAt(0))) {
                operandDepth += 2;
                continue;
            }
            ++operandDepth;
        }
        return operandDepth;
    }

    public static int toUniformDepth(List<String> headTypes, int operandDepth) {
        int uniformDepth = 0;
        int popDepth = 0;
        int i = headTypes.size() - 1;
        while (popDepth < operandDepth) {
            popDepth = ASMUtil.isCategory2(headTypes.get(i).codePointAt(0)) ? (popDepth += 2) : ++popDepth;
            --i;
            ++uniformDepth;
        }
        return uniformDepth;
    }
}

