/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import java.util.Arrays;
import java.util.List;
import nilloader.api.lib.asm.Type;
import nilloader.api.lib.asm.tree.AnnotationNode;
import nilloader.api.lib.asm.tree.ClassNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.internal.MemberDesc;
import org.stianloader.micromixin.transform.internal.MixinParseException;

public class MixinDescAnnotation {
    @Nullable
    public final Type owner;
    @NotNull
    public final String value;
    @Nullable
    public final Type[] args;
    @Nullable
    public final Type ret;
    @NotNull
    public final MemberDesc targetMethod;
    @NotNull
    public final MemberDesc targetField;

    private MixinDescAnnotation(@Nullable Type owner, @NotNull String value, @Nullable Type[] args, @Nullable Type ret, @NotNull MemberDesc targetMethod, @NotNull MemberDesc targetField) {
        this.owner = owner;
        this.value = value;
        this.args = args;
        this.ret = ret;
        this.targetMethod = targetMethod;
        this.targetField = targetField;
    }

    @NotNull
    public static MixinDescAnnotation parse(@NotNull ClassNode node, @NotNull AnnotationNode atValue) {
        String value = null;
        Type ret = null;
        Type owner = null;
        Type[] args = null;
        for (int i = 0; i < atValue.values.size(); i += 2) {
            String name = (String)atValue.values.get(i);
            Object val = atValue.values.get(i + 1);
            if (name.equals("value")) {
                value = (String)val;
                continue;
            }
            if (name.equals("ret")) {
                ret = (Type)val;
                continue;
            }
            if (name.equals("owner")) {
                owner = (Type)val;
                continue;
            }
            if (name.equals("args")) {
                Type[] hack;
                args = hack = ((List)val).toArray(new Type[0]);
                continue;
            }
            throw new MixinParseException("Unimplemented key in @Desc: " + name);
        }
        if (value == null) {
            throw new MixinParseException("The required field \"value\" is missing.");
        }
        if (value.contains("(") || value.contains(".")) {
            throw new MixinParseException("[(.] present in \"value\"");
        }
        String splicedMethodDesc = "()V";
        if (ret != null) {
            splicedMethodDesc = splicedMethodDesc.substring(0, splicedMethodDesc.lastIndexOf(41) + 1) + ret.getDescriptor();
        }
        if (args != null) {
            String splicedArgs = "(";
            for (void var11_14 : args) {
                splicedArgs = splicedArgs + var11_14.getDescriptor();
            }
            splicedMethodDesc = splicedArgs + splicedMethodDesc.substring(splicedMethodDesc.lastIndexOf(41));
        }
        String ownerName = owner != null ? owner.getInternalName() : node.name;
        MemberDesc targetMethod = new MemberDesc(ownerName, value, splicedMethodDesc);
        MemberDesc targetField = new MemberDesc(ownerName, value, ret == null ? "V" : ret.getDescriptor());
        return new MixinDescAnnotation(owner, value, args, ret, targetMethod, targetField);
    }

    public String toString() {
        return "MixinDescAnnotation[value = \"" + this.value + "\", args = " + Arrays.toString(this.args) + ", ret = \"" + this.ret + ", targetField = \"" + this.targetField + "\", targetMethod = \"" + this.targetMethod + "\"]";
    }
}

