/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.MethodNode;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.api.InjectionPointSelector;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.internal.selectors.inject.TailInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;

public class SlicedInjectionPointSelector {
    @Nullable
    private final SlicedInjectionPointSelector from;
    private final int offset;
    @NotNull
    private final InjectionPointSelector selector;
    @Nullable
    private final SlicedInjectionPointSelector to;
    private final boolean unsafe;

    public SlicedInjectionPointSelector(@NotNull InjectionPointSelector selector, @Nullable SlicedInjectionPointSelector from, @Nullable SlicedInjectionPointSelector to, int shift, boolean unsafe) {
        this.selector = selector;
        this.from = from;
        this.to = to;
        this.offset = shift;
        this.unsafe = unsafe;
    }

    @Nullable
    public AbstractInsnNode getAfterSelected(@NotNull MethodNode method, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        AbstractInsnNode first = this.getFirstInsn(method, remapper, sharedBuilder);
        if (first == null) {
            return null;
        }
        AbstractInsnNode selected = ASMUtil.afterInstruction(first);
        AbstractInsnNode afterSelected = selected.getNext();
        if (afterSelected == null) {
            return selected;
        }
        return afterSelected;
    }

    @Nullable
    public AbstractInsnNode getFirstInsn(@NotNull MethodNode method, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        AbstractInsnNode insn = this.selector.getFirstInsn(method, this.from, this.to, remapper, sharedBuilder);
        if (this.offset == 0) {
            return insn;
        }
        return ASMUtil.shiftInsn(insn, this.offset);
    }

    @Deprecated
    @Nullable
    public SlicedInjectionPointSelector getFrom() {
        return this.from;
    }

    @NotNull
    public Collection<? extends AbstractInsnNode> getMatchedInstructions(@NotNull MethodNode method, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        Collection<? extends AbstractInsnNode> nodes = this.selector.getMatchedInstructions(method, this.from, this.to, remapper, sharedBuilder);
        if (this.offset == 0 || nodes.isEmpty()) {
            return nodes;
        }
        ArrayList<AbstractInsnNode> shiftedInsns = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode abstractInsnNode : nodes) {
            shiftedInsns.add(ASMUtil.shiftInsn(abstractInsnNode, this.offset));
        }
        return shiftedInsns;
    }

    @Contract(pure=true)
    public int getOffset() {
        return this.offset;
    }

    @NotNull
    @Contract(pure=true)
    public String getQualifiedSelectorName() {
        return this.selector.fullyQualifiedName;
    }

    @Deprecated
    @NotNull
    public InjectionPointSelector getSelector() {
        return this.selector;
    }

    @Deprecated
    @Nullable
    public SlicedInjectionPointSelector getTo() {
        return this.to;
    }

    @Contract(pure=true)
    public boolean isUnsafe() {
        return this.unsafe;
    }

    @Contract(pure=true)
    public boolean supportsConstructors() {
        return this.unsafe || this.selector == TailInjectionPointSelector.INSTANCE;
    }

    @Deprecated
    public boolean supportsRedirect() {
        return this.selector.supportsRedirect();
    }

    @NotNull
    public String toString() {
        return "SlicedInjectionPointSelector[" + this.selector.fullyQualifiedName + ", from = " + this.from + ", to = " + this.to + ", off = " + this.offset + ", unsafe = " + this.unsafe + "]";
    }

    public void verifySlices(@NotNull Queue<String> path, @NotNull MethodNode method, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        SlicedInjectionPointSelector to;
        SlicedInjectionPointSelector from = this.from;
        if (from != null) {
            path.add("from");
            from.verifySlices(path, method, remapper, sharedBuilder);
            path.remove();
        }
        if ((to = this.to) != null) {
            path.add("to");
            to.verifySlices(path, method, remapper, sharedBuilder);
            path.remove();
        }
        try {
            AbstractInsnNode fromInsn = method.instructions.getFirst();
            AbstractInsnNode toInsn = method.instructions.getLast();
            if (from != null) {
                fromInsn = from.getFirstInsn(method, remapper, sharedBuilder);
            }
            if (to != null) {
                toInsn = to.getFirstInsn(method, remapper, sharedBuilder);
            }
            if (fromInsn == null) {
                throw new IllegalStateException("Slice does not apply: 'from' is a null instruction (wrong target method?). From slice: " + this.from);
            }
            if (toInsn == null) {
                throw new IllegalStateException("Slice does not apply: 'to' is a null instruction (wrong target method?). To slice: " + this.to);
            }
            for (AbstractInsnNode insn = toInsn.getNext(); insn != null; insn = insn.getNext()) {
                if (insn != fromInsn) continue;
                throw new IllegalStateException("Invalid slice ordering: 'from' is after 'to' - check whether the target method is correct and whether the slices are indeed correct");
            }
            this.getFirstInsn(method, remapper, sharedBuilder);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Invalid injection point selector at path: " + path + " while targetting method " + method.name + method.desc, e);
        }
    }
}

