/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import nilloader.api.lib.asm.ClassVisitor;
import nilloader.api.lib.asm.tree.ClassNode;
import nilloader.api.lib.asm.util.CheckClassAdapter;
import nilloader.api.lib.asm.util.Textifier;
import nilloader.api.lib.asm.util.TraceClassVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.api.BytecodeProvider;
import org.stianloader.micromixin.transform.api.InjectionPointSelectorFactory;
import org.stianloader.micromixin.transform.api.MixinConfig;
import org.stianloader.micromixin.transform.api.MixinLoggingFacade;
import org.stianloader.micromixin.transform.api.ModularityAttached;
import org.stianloader.micromixin.transform.api.supertypes.ClassWrapperPool;
import org.stianloader.micromixin.transform.internal.DefaultMixinLogger;
import org.stianloader.micromixin.transform.internal.HandlerContextHelper;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.MixinStub;
import org.stianloader.micromixin.transform.internal.selectors.inject.ConstantInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.FieldInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.HeadInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.InvokeInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.LoadInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.ReturnInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.StoreInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.TailInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.util.Objects;

public class MixinTransformer<M> {
    private static final boolean DEBUG = Boolean.getBoolean("org.stianloader.micromixin.debug");
    @NotNull
    private final BytecodeProvider<M> bytecodeProvider;
    private boolean delayParseExceptions = Boolean.getBoolean("org.stianloader.micromixin.delayedParseException");
    @NotNull
    private final InjectionPointSelectorFactory injectionPointSelectors = new InjectionPointSelectorFactory();
    @NotNull
    private MixinLoggingFacade logger = new DefaultMixinLogger(DEBUG);
    private boolean mergeClassFileVersions = true;
    @NotNull
    private final Map<ModularityAttached<M, String>, ClassNode> mixinNodes = new HashMap<ModularityAttached<M, String>, ClassNode>();
    @NotNull
    private final Map<ModularityAttached<M, String>, MixinConfig> mixins = new HashMap<ModularityAttached<M, String>, MixinConfig>();
    @NotNull
    private final Map<ModularityAttached<M, String>, MixinStub> mixinStubs = new HashMap<ModularityAttached<M, String>, MixinStub>();
    @NotNull
    private final Map<String, TreeSet<MixinStub>> mixinTargets = new HashMap<String, TreeSet<MixinStub>>();
    @NotNull
    private final Map<ModularityAttached<M, String>, MixinConfig> packageDeclarations = new HashMap<ModularityAttached<M, String>, MixinConfig>();
    @NotNull
    private final ClassWrapperPool pool;

    public MixinTransformer(@NotNull BytecodeProvider<M> bytecodeProvider, @NotNull ClassWrapperPool pool) {
        this.bytecodeProvider = bytecodeProvider;
        this.pool = pool;
        this.injectionPointSelectors.register(ConstantInjectionPointSelector.PROVIDER);
        this.injectionPointSelectors.register(HeadInjectionPointSelector.INSTANCE);
        this.injectionPointSelectors.register(InvokeInjectionPointSelector.PROVIDER);
        this.injectionPointSelectors.register(ReturnInjectionPointSelector.INSTANCE);
        this.injectionPointSelectors.register(TailInjectionPointSelector.INSTANCE);
        this.injectionPointSelectors.register(FieldInjectionPointSelector.PROVIDER);
        this.injectionPointSelectors.register(LoadInjectionPointSelector.INSTANCE);
        this.injectionPointSelectors.register(StoreInjectionPointSelector.INSTANCE);
    }

    public void addMixin(M attachment, @NotNull MixinConfig config) {
        Objects.requireNonNull(config, "config must not be null");
        if (this.isMixin(attachment, config.mixinPackage)) {
            throw new IllegalStateException("Two mixin configurations within the same modularity attachment (" + attachment + ") target the same package (" + config.mixinPackage + ").");
        }
        this.packageDeclarations.put(new ModularityAttached<M, String>(attachment, config.mixinPackage), config);
        this.getLogger().debug(MixinTransformer.class, "Registering mixin package {} under modularity attachment {}", config.mixinPackage, attachment);
        StringBuilder sharedBuilder = new StringBuilder();
        for (String mixin : config.mixins) {
            ModularityAttached<M, String> mixinRef = new ModularityAttached<M, String>(attachment, config.mixinPackage + "/" + mixin);
            if (this.mixins.containsKey(mixinRef)) {
                throw new IllegalStateException("Two mixin configurations within the same modularity attachment (" + attachment + ") use the same class (" + (String)mixinRef.value + ").");
            }
            this.mixins.put(mixinRef, config);
            try {
                ClassNode node = this.bytecodeProvider.getClassNode(attachment, (String)mixinRef.value);
                MixinStub stub = MixinStub.parse(config.priority, node, this, sharedBuilder);
                this.mixinNodes.put(mixinRef, node);
                this.mixinStubs.put(mixinRef, stub);
                HashSet<String> targets = new HashSet<String>();
                for (String desc : stub.header.targets) {
                    if (!targets.add(desc)) continue;
                    TreeSet<MixinStub> val = this.mixinTargets.get(desc);
                    if (val == null) {
                        val = new TreeSet();
                        this.mixinTargets.put(desc, val);
                    }
                    val.add(stub);
                }
                this.getLogger().debug(MixinTransformer.class, "Registering mixin {} under modularity attachment {}, the mixin target following classes: {}", mixinRef.value, attachment, targets);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Broken mixin: " + (String)mixinRef.value + " (attached via " + attachment + ")", e);
            }
            catch (MixinParseException e) {
                throw new IllegalStateException("Broken mixin: " + (String)mixinRef.value + " (attached via " + attachment + ")", e);
            }
        }
    }

    @NotNull
    @Contract(pure=true)
    public InjectionPointSelectorFactory getInjectionPointSelectors() {
        return this.injectionPointSelectors;
    }

    @NotNull
    public MixinLoggingFacade getLogger() {
        return this.logger;
    }

    @NotNull
    public ClassWrapperPool getPool() {
        return this.pool;
    }

    public boolean isDelayingParseExceptions() {
        return this.delayParseExceptions;
    }

    public boolean isMergingClassFileVersions() {
        return this.mergeClassFileVersions;
    }

    @Deprecated
    public boolean isMergeingClassFileVersions() {
        return this.mergeClassFileVersions;
    }

    public boolean isMixin(M attachment, @NotNull String internalName) {
        ModularityAttached<M, String> attached = new ModularityAttached<M, String>(attachment, internalName);
        if (this.packageDeclarations.containsKey(attached)) {
            return true;
        }
        int slashIndex = internalName.lastIndexOf(47);
        if (slashIndex == -1) {
            return false;
        }
        return this.isMixin(attachment, internalName.substring(0, slashIndex));
    }

    public boolean isMixinTarget(@NotNull String name) {
        return this.mixinTargets.containsKey(name);
    }

    public void setDelayParseExceptions(boolean delayParseExceptions) {
        this.delayParseExceptions = delayParseExceptions;
    }

    public void setLogger(@NotNull MixinLoggingFacade logger) {
        this.logger = logger;
    }

    public void setMergeClassFileVersions(boolean mergeClassFileVersions) {
        this.mergeClassFileVersions = mergeClassFileVersions;
    }

    public void transform(@NotNull ClassNode in) {
        Iterable mixins = this.mixinTargets.get(in.name);
        if (mixins == null) {
            return;
        }
        this.logger.debug(MixinTransformer.class, "Transforming class {} using following stubs: {}", in.name, mixins);
        HandlerContextHelper hctx = HandlerContextHelper.from(in);
        StringBuilder sharedBuilder = new StringBuilder();
        for (MixinStub stub : mixins) {
            boolean previewSource;
            boolean previewOrigin;
            try {
                this.logger.debug(MixinTransformer.class, "Applying mixin {} to transforming classnode {}.", stub.sourceNode.name, in.name);
                stub.applyTo(in, hctx, sharedBuilder);
            }
            catch (Throwable t) {
                if (t instanceof Error && !(t instanceof AssertionError)) {
                    throw (Error)t;
                }
                if (DEBUG) {
                    StringWriter sw = new StringWriter();
                    TraceClassVisitor tcv = new TraceClassVisitor(null, new Textifier(), new PrintWriter(sw));
                    in.accept((ClassVisitor)tcv);
                    this.getLogger().info(MixinTransformer.class, "Disassembled class file:\n{}", sw);
                }
                throw new RuntimeException("Failed to apply mixin stub originating from " + stub.sourceNode.name + " to node " + in.name, t);
            }
            if (!this.isMergeingClassFileVersions()) continue;
            int adjustOrigin = in.version & 0xFFFF;
            int adjustSource = stub.sourceNode.version & 0xFFFF;
            if (adjustOrigin < adjustSource) {
                in.version = stub.sourceNode.version;
                continue;
            }
            if (adjustOrigin != adjustSource || !((previewOrigin = (in.version & 0xFFFF0000) == -65536) | (previewSource = (stub.sourceNode.version & 0xFFFF0000) == -65536))) continue;
            in.version |= 0xFFFF0000;
        }
        hctx.lineAllocator.exportToSMAP("Mixin").applyTo(in, sharedBuilder);
        if (DEBUG) {
            try {
                CheckClassAdapter cca = new CheckClassAdapter(null);
                in.accept((ClassVisitor)cca);
            }
            catch (Throwable t) {
                this.getLogger().error(MixinTransformer.class, "Invalidly transformed class: {}", in.name, t);
                StringWriter sw = new StringWriter();
                TraceClassVisitor tcv = new TraceClassVisitor(new PrintWriter(sw));
                in.accept((ClassVisitor)tcv);
                this.getLogger().info(MixinTransformer.class, "Disassembled class file:\n", sw);
            }
        }
    }
}

