/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.ClassNode;
import nilloader.api.lib.asm.tree.MethodInsnNode;
import nilloader.api.lib.asm.tree.MethodNode;
import nilloader.api.lib.asm.tree.TypeInsnNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.internal.HandlerContextHelper;
import org.stianloader.micromixin.transform.internal.MixinMethodStub;
import org.stianloader.micromixin.transform.internal.MixinStub;
import org.stianloader.micromixin.transform.internal.annotation.MixinAnnotation;
import org.stianloader.micromixin.transform.internal.util.CodeCopyUtil;

public class VirtualConstructorMergeAnnotation
extends MixinAnnotation<MixinMethodStub> {
    @NotNull
    private static MethodInsnNode getConstructorInvokeInsn(@NotNull ClassNode node, @NotNull MethodNode source) {
        AbstractInsnNode insn = source.instructions.getFirst();
        if (insn == null) {
            throw new IllegalStateException("Constructor " + node.name + "." + source.name + source.desc + " is empty. Did you accidentally use ClassReader.SKIP_CODE?");
        }
        int newDepth = 0;
        while (insn != null) {
            if (insn.getOpcode() != 183) {
                if (insn.getOpcode() == 187 && (((TypeInsnNode)insn).desc.equals(node.superName) || ((TypeInsnNode)insn).desc.equals(node.name))) {
                    ++newDepth;
                }
                insn = insn.getNext();
                continue;
            }
            if (((MethodInsnNode)insn).name.equals("<init>") && (((MethodInsnNode)insn).owner.equals(node.superName) || ((MethodInsnNode)insn).owner.equals(node.name))) {
                AbstractInsnNode prev;
                for (prev = insn.getPrevious(); prev != null && prev.getOpcode() == -1; prev = prev.getPrevious()) {
                }
                if (prev == null) {
                    throw new IllegalStateException("The first instruction of a mixin is a constructor invocation. This does not make much sense!");
                }
                if (newDepth == 0) break;
                --newDepth;
                insn = insn.getNext();
                continue;
            }
            insn = insn.getNext();
        }
        if (insn == null) {
            throw new NullPointerException("Instructions exhausted for " + node.name + "." + source.name + source.desc + ", depth: " + newDepth + "; Overall instructions count: " + source.instructions.size());
        }
        return (MethodInsnNode)insn;
    }

    @Override
    public void apply(@NotNull ClassNode to, @NotNull HandlerContextHelper hctx, @NotNull MixinStub sourceStub, @NotNull MixinMethodStub source, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        if (!source.method.desc.equals("()V")) {
            throw new IllegalStateException("Illegal mixin: " + sourceStub.sourceNode.name + "." + source.method.name + source.method.desc + ". Expected no-args constructor!");
        }
        AbstractInsnNode firstInsn = VirtualConstructorMergeAnnotation.getConstructorInvokeInsn(source.owner, source.method).getNext();
        if (firstInsn == null) {
            return;
        }
        AbstractInsnNode lastInsn = source.method.instructions.getLast();
        if (lastInsn == null) {
            throw new AssertionError();
        }
        for (MethodNode m : to.methods) {
            if (!m.name.equals("<init>")) continue;
            MethodInsnNode targetInsn = VirtualConstructorMergeAnnotation.getConstructorInvokeInsn(to, m);
            if (!targetInsn.owner.equals(to.superName)) continue;
            CodeCopyUtil.copyTo(source.method, firstInsn, lastInsn, sourceStub, m, (AbstractInsnNode)targetInsn, to, remapper, hctx.lineAllocator, true, false);
        }
    }

    @Override
    public void collectMappings(@NotNull MixinMethodStub source, @NotNull ClassNode target, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
    }
}

