/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import nilloader.api.lib.asm.tree.AnnotationNode;
import nilloader.api.lib.asm.tree.ClassNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.api.MixinLoggingFacade;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.internal.ClassMemberStub;
import org.stianloader.micromixin.transform.internal.MixinFieldStub;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.annotation.AbstractOverlayAnnotation;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;

public class MixinUniqueAnnotation<T extends ClassMemberStub>
extends AbstractOverlayAnnotation<T> {
    private static final AtomicLong UID_COUNTER = new AtomicLong((long)new Random().nextInt() + 0x100000000L);
    private final boolean silent;
    @NotNull
    private final MixinLoggingFacade logger;
    @NotNull
    private final String uniquePrefix = "$unique$" + Long.toHexString(UID_COUNTER.getAndIncrement()) + "$";

    private MixinUniqueAnnotation(boolean silent, @NotNull MixinLoggingFacade logger) {
        this.silent = silent;
        this.logger = logger;
    }

    @NotNull
    public static <T0 extends ClassMemberStub> MixinUniqueAnnotation<T0> parse(@NotNull AnnotationNode annotation, @NotNull MixinLoggingFacade logger) {
        boolean silent = false;
        if (annotation.values != null) {
            for (int i = 0; i < annotation.values.size(); i += 2) {
                String name = (String)annotation.values.get(i);
                if (!name.equals("silent")) {
                    throw new MixinParseException("Unimplemented option for @Unique: " + name);
                }
                silent = (Boolean)annotation.values.get(i + 1);
            }
        }
        return new MixinUniqueAnnotation(silent, logger);
    }

    @Override
    public void collectMappings(@NotNull T source, @NotNull ClassNode target, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        if (source instanceof MixinFieldStub && (((MixinFieldStub)source).field.access & 1) != 0) {
            return;
        }
        super.collectMappings(source, target, remapper, sharedBuilder);
    }

    @Override
    public boolean handleCollision(@NotNull T source, @NotNull ClassNode target, int access) {
        if ((source.getAccess() & 1) != 0) {
            if (!this.silent) {
                this.logger.warn(MixinUniqueAnnotation.class, "{}.{} {} is public and annotated through @Unique. Furthermore, it collides with something already present in the class and as such the original mapping was discarded. Use silent=true in the @Unique annotation to supress this warning", source.getOwner().name, source.getName(), source.getDesc());
            }
            return false;
        }
        this.logger.error(MixinUniqueAnnotation.class, "Unable to transform  {}.{} {} due to @Unique collision. Ensure that you do not have multiple Micromixin instances running.", source.getOwner().name, source.getName(), source.getDesc());
        throw new UnsupportedOperationException("Unique prefix (\"" + this.uniquePrefix + "\") does not suffice. Note: restarting the application usually suffices as that regenerates the unique prefix for the member.");
    }

    @Override
    @NotNull
    public String getDesiredName(@NotNull T source, @NotNull ClassNode target, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        String name = source.getName();
        String desc = source.getDesc();
        if (desc.charAt(0) == '(') {
            if ((source.getAccess() & 1) != 0) {
                return name;
            }
            if (!ASMUtil.hasMethod(target, name, desc = remapper.getRemappedMethodDescriptor(desc, sharedBuilder))) {
                return name;
            }
        } else {
            if ((source.getAccess() & 1) != 0) {
                return name;
            }
            if (!ASMUtil.hasField(target, name, desc = remapper.getRemappedFieldDescriptor(desc, sharedBuilder))) {
                return name;
            }
        }
        return this.uniquePrefix + name;
    }
}

