/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nilloader.api.lib.asm.Handle;
import nilloader.api.lib.asm.Type;
import nilloader.api.lib.asm.tree.AnnotationNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.internal.util.MemberRenameMap;
import org.stianloader.micromixin.transform.internal.util.Objects;

public final class SimpleRemapper {
    private final MemberRenameMap fieldRenames = new MemberRenameMap();
    private final MemberRenameMap methodRenames = new MemberRenameMap();
    private final Map<String, String> oldToNewClassName = new HashMap<String, String>();

    @NotNull
    public String getRemappedClassName(@NotNull String name) {
        String s = this.oldToNewClassName.get(name);
        if (s == null) {
            return name;
        }
        return s;
    }

    @Nullable
    public String getRemappedClassNameFast(@NotNull String name) {
        return this.oldToNewClassName.get(name);
    }

    @NotNull
    public String getRemappedFieldDescriptor(@NotNull String fieldDesc, @NotNull StringBuilder sharedBuilder) {
        sharedBuilder.setLength(0);
        return this.remapSingleDesc(fieldDesc, sharedBuilder);
    }

    @NotNull
    public String getRemappedFieldName(@NotNull String ownerName, @NotNull String fieldName, @NotNull String fieldDesc) {
        return this.fieldRenames.optGet(ownerName, fieldDesc, fieldName);
    }

    @NotNull
    public String getRemappedMethodDescriptor(@NotNull String methodDesc, @NotNull StringBuilder sharedBuilder) {
        sharedBuilder.setLength(0);
        if (!this.remapSignature(methodDesc, sharedBuilder)) {
            return methodDesc;
        }
        return sharedBuilder.toString();
    }

    @NotNull
    public String getRemappedMethodName(@NotNull String ownerName, @NotNull String methodName, @NotNull String methodDesc) {
        return this.methodRenames.optGet(ownerName, methodDesc, methodName);
    }

    private void remapAnnotation(AnnotationNode annotation, StringBuilder sharedStringBuilder) {
        String internalName = annotation.desc.substring(1, annotation.desc.length() - 1);
        String newInternalName = this.oldToNewClassName.get(internalName);
        if (newInternalName != null) {
            annotation.desc = 'L' + newInternalName + ';';
        }
        if (annotation.values != null) {
            int size = annotation.values.size();
            for (int i = 0; i < size; ++i) {
                String bitvoid = (String)annotation.values.get(i++);
                this.remapAnnotationValue(annotation.values.get(i), i, annotation.values, sharedStringBuilder);
            }
        }
    }

    private void remapAnnotationValue(Object value, int index, List<Object> values, StringBuilder sharedStringBuilder) {
        if (value instanceof Type) {
            String type = ((Type)value).getDescriptor();
            sharedStringBuilder.setLength(0);
            if (this.remapSignature(type, sharedStringBuilder)) {
                values.set(index, Type.getType(sharedStringBuilder.toString()));
            }
        } else if (value instanceof String[]) {
            String[] enumvals = (String[])value;
            String descriptor = enumvals[0];
            String name = Objects.requireNonNull(enumvals[1]);
            String internalName = descriptor.substring(1, descriptor.length() - 1);
            enumvals[1] = this.fieldRenames.optGet(internalName, descriptor, name);
            String newInternalName = this.oldToNewClassName.get(internalName);
            if (newInternalName != null) {
                enumvals[0] = 'L' + newInternalName + ';';
            }
        } else if (value instanceof AnnotationNode) {
            this.remapAnnotation((AnnotationNode)value, sharedStringBuilder);
        } else if (value instanceof List) {
            List valueList = (List)value;
            int size = valueList.size();
            for (int i = 0; i < size; ++i) {
                this.remapAnnotationValue(valueList.get(i), i, valueList, sharedStringBuilder);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remapBSMArg(Object[] bsmArgs, int index, StringBuilder sharedStringBuilder) {
        Object bsmArg = bsmArgs[index];
        if (bsmArg instanceof Type) {
            Type type = (Type)bsmArg;
            sharedStringBuilder.setLength(0);
            if (type.getSort() == 11) {
                if (!this.remapSignature(type.getDescriptor(), sharedStringBuilder)) return;
                bsmArgs[index] = Type.getMethodType(sharedStringBuilder.toString());
                return;
            } else {
                String remappedVal;
                if (type.getSort() != 10) throw new IllegalArgumentException("Unexpected bsm arg Type sort. Sort = " + type.getSort() + "; type = " + type);
                String oldVal = type.getInternalName();
                if (oldVal == (remappedVal = this.remapInternalName(oldVal, sharedStringBuilder))) return;
                bsmArgs[index] = Type.getObjectType(remappedVal);
            }
            return;
        } else if (bsmArg instanceof Handle) {
            boolean modified;
            Handle handle = (Handle)bsmArg;
            String oldName = handle.getName();
            String hOwner = handle.getOwner();
            String newName = this.methodRenames.optGet(hOwner, handle.getDesc(), oldName);
            String newOwner = this.oldToNewClassName.get(hOwner);
            boolean bl = modified = oldName != newName;
            if (newOwner != null) {
                hOwner = newOwner;
                modified = true;
            }
            String desc = handle.getDesc();
            sharedStringBuilder.setLength(0);
            if (this.remapSignature(desc, sharedStringBuilder)) {
                desc = sharedStringBuilder.toString();
                modified = true;
            }
            if (!modified) return;
            bsmArgs[index] = new Handle(handle.getTag(), hOwner, newName, desc, handle.isInterface());
            return;
        } else {
            if (bsmArg instanceof String) return;
            throw new IllegalArgumentException("Unexpected bsm arg class at index " + index + " for " + Arrays.toString(bsmArgs) + ". Class is " + bsmArg.getClass().getName());
        }
    }

    public void remapClassName(@NotNull String oldName, @NotNull String newName) {
        this.oldToNewClassName.put(oldName, newName);
    }

    public void remapClassNames(Map<String, String> mappings) {
        this.oldToNewClassName.putAll(mappings);
    }

    public void remapField(@NotNull String owner, @NotNull String desc, @NotNull String oldName, @NotNull String newName) {
        this.fieldRenames.put(owner, desc, oldName, newName);
    }

    @NotNull
    public String remapInternalName(@NotNull String internalName, @NotNull StringBuilder sharedStringBuilder) {
        if (internalName.codePointAt(0) == 91) {
            return this.remapSingleDesc(internalName, sharedStringBuilder);
        }
        String remapped = this.oldToNewClassName.get(internalName);
        if (remapped != null) {
            return remapped;
        }
        return internalName;
    }

    public void remapMethod(@NotNull String owner, @NotNull String desc, @NotNull String oldName, @NotNull String newName) {
        this.methodRenames.put(owner, desc, oldName, newName);
    }

    public boolean remapSignature(String signature, StringBuilder out) {
        return this.remapSignature(out, signature, 0, signature.length());
    }

    private boolean remapSignature(StringBuilder signatureOut, String signature, int start, int end) {
        if (start == end) {
            return false;
        }
        int type = signature.codePointAt(start++);
        switch (type) {
            case 76: 
            case 84: {
                int codepoint;
                int endObject = start;
                do {
                    if ((codepoint = signature.codePointAt(++endObject)) != 59) continue;
                    String name = signature.substring(start, endObject);
                    String newName = this.oldToNewClassName.get(name);
                    boolean modified = false;
                    if (newName != null) {
                        name = newName;
                        modified = true;
                    }
                    signatureOut.appendCodePoint(type);
                    signatureOut.append(name);
                    signatureOut.append(';');
                    return modified |= this.remapSignature(signatureOut, signature, ++endObject, end);
                } while (codepoint != 60);
                int openingBrackets = 1;
                int endGenerics = endObject;
                while (true) {
                    if ((codepoint = signature.codePointAt(++endGenerics)) == 62) {
                        if (--openingBrackets != 0) continue;
                        break;
                    }
                    if (codepoint != 60) continue;
                    ++openingBrackets;
                }
                String name = signature.substring(start, endObject);
                String newName = this.oldToNewClassName.get(name);
                boolean modified = false;
                if (newName != null) {
                    name = newName;
                    modified = true;
                }
                signatureOut.append('L');
                signatureOut.append(name);
                signatureOut.append('<');
                modified |= this.remapSignature(signatureOut, signature, endObject + 1, endGenerics++);
                signatureOut.append('>');
                signatureOut.appendCodePoint(signature.codePointAt(endGenerics));
                return modified |= this.remapSignature(signatureOut, signature, ++endGenerics, end);
            }
        }
        signatureOut.appendCodePoint(type);
        return this.remapSignature(signatureOut, signature, start, end);
    }

    @NotNull
    public String remapSingleDesc(@NotNull String input, @NotNull StringBuilder sharedBuilder) {
        int indexofL = input.indexOf(76);
        if (indexofL == -1) {
            return input;
        }
        int length = input.length();
        String internalName = input.substring(indexofL + 1, length - 1);
        String newInternalName = this.oldToNewClassName.get(internalName);
        if (newInternalName == null) {
            return input;
        }
        sharedBuilder.setLength(indexofL + 1);
        sharedBuilder.setCharAt(indexofL, 'L');
        while (indexofL != 0) {
            sharedBuilder.setCharAt(--indexofL, '[');
        }
        sharedBuilder.append(newInternalName);
        sharedBuilder.append(';');
        return sharedBuilder.toString();
    }

    public void removeMethodRemap(@NotNull String owner, @NotNull String desc, @NotNull String name) {
        this.methodRenames.remove(owner, desc, name);
    }
}

