/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.nilmm;

import java.io.IOException;
import java.io.InputStream;
import nilloader.NilAgent;
import nilloader.api.ClassTransformer;
import nilloader.api.lib.asm.ClassReader;
import nilloader.api.lib.asm.ClassVisitor;
import nilloader.api.lib.asm.tree.ClassNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.api.BytecodeProvider;
import org.stianloader.micromixin.transform.api.MixinConfig;
import org.stianloader.micromixin.transform.api.MixinTransformer;
import org.stianloader.micromixin.transform.api.supertypes.ClassWrapperPool;
import org.stianloader.nilmm.BytecodeProviderClassWrapperProvider;
import org.stianloader.nilmm.MixinASMTransformer;
import org.stianloader.nilmm.NilMixinLoggingFacade;

public class NilMicromixin
implements Runnable {
    @NotNull
    private static final BytecodeProvider<ClassLoader> BYTECODE_PROVIDER = new BytecodeProvider<ClassLoader>(){

        @Override
        @NotNull
        public ClassNode getClassNode(ClassLoader modularityAttachment, @NotNull String internalName) throws ClassNotFoundException {
            try {
                InputStream in = modularityAttachment.getResourceAsStream(internalName.replace('.', '/') + ".class");
                if (in == null) {
                    throw new ClassNotFoundException("Resource not found in specified classloader (" + modularityAttachment + ")");
                }
                ClassReader reader = new ClassReader(in);
                ClassNode node = new ClassNode();
                reader.accept((ClassVisitor)node, 0);
                return node;
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Unable to read reasource from the specified classloader (" + modularityAttachment + ")", e);
            }
        }
    };
    @NotNull
    private static final ClassLoader LOADER = ClassWrapperPool.class.getClassLoader();
    @NotNull
    public static final BytecodeProviderClassWrapperProvider CLASS_WRAPPER_PROVIDER = new BytecodeProviderClassWrapperProvider(BYTECODE_PROVIDER).addClassloader(LOADER);
    @NotNull
    public static final ClassWrapperPool CLASS_WRAPPER_POOL = new ClassWrapperPool().addProvider(CLASS_WRAPPER_PROVIDER);
    public static final MixinTransformer<ClassLoader> TRANSFORMER = new MixinTransformer<ClassLoader>(BYTECODE_PROVIDER, CLASS_WRAPPER_POOL);

    @Override
    public void run() {
        NilAgent.registerTransformer((ClassTransformer)new MixinASMTransformer(TRANSFORMER));
    }

    public static void addMixin(@NotNull ClassLoader loader, @NotNull String mixinContents) throws MixinConfig.InvalidMixinConfigException {
        TRANSFORMER.addMixin(loader, MixinConfig.fromString(mixinContents));
    }

    static {
        if (!Boolean.getBoolean("org.stianloader.nilmm.stdio")) {
            TRANSFORMER.setLogger(new NilMixinLoggingFacade());
        }
    }
}

