/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.nilmm;

import nilloader.api.ClassTransformer;
import nilloader.api.lib.asm.ClassReader;
import nilloader.api.lib.asm.ClassVisitor;
import nilloader.api.lib.asm.ClassWriter;
import nilloader.api.lib.asm.tree.ClassNode;
import org.stianloader.micromixin.transform.api.MixinTransformer;

public class MixinASMTransformer
implements ClassTransformer {
    private final MixinTransformer<ClassLoader> transformer;

    public MixinASMTransformer(MixinTransformer<ClassLoader> transformer) {
        this.transformer = transformer;
    }

    public byte[] transform(String className, byte[] originalData) {
        assert (className != null);
        if (!this.transformer.isMixinTarget(className)) {
            return originalData;
        }
        try {
            ClassReader reader = new ClassReader(originalData);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            this.transformer.transform(node);
            ClassWriter writer = new ClassWriter(reader, 2){

                @Override
                protected String getCommonSuperClass(String type1, String type2) {
                    return MixinASMTransformer.this.transformer.getPool().getCommonSuperClass(MixinASMTransformer.this.transformer.getPool().get(type1), MixinASMTransformer.this.transformer.getPool().get(type2)).getName();
                }
            };
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Throwable t) {
            if (!Boolean.getBoolean("org.stianloader.nilmm.stdio")) {
                this.transformer.getLogger().error(MixinASMTransformer.class, "Unable to transform class", t);
            } else {
                t.printStackTrace();
                t.printStackTrace(System.out);
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException("Unable to transform class", t);
        }
    }
}

