/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.util.smap;

import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.internal.util.smap.AbstractSMAPSection;

public class LineSection
extends AbstractSMAPSection {
    private final List<LineInfo> lineInfos;

    public LineSection(List<LineInfo> lineInfos) {
        this.lineInfos = lineInfos;
    }

    @Override
    @NotNull
    public StringBuilder pushContents(@NotNull StringBuilder sharedBuilder) {
        sharedBuilder.append("*L\r");
        for (LineInfo info : this.lineInfos) {
            info.pushContents(sharedBuilder);
        }
        return sharedBuilder;
    }

    public static class LineInfo {
        private final int inputStartLine;
        private final int lineFileId;
        private final int inputLineCount;
        private final int outputStartLine;
        private final int outputLineIncrement;

        public LineInfo(int inputStartLine, int lineFileId, int inputLineCount, int outputLineIncrement, int outputStartLine) {
            this.inputStartLine = inputStartLine;
            this.lineFileId = lineFileId;
            this.inputLineCount = inputLineCount;
            this.outputLineIncrement = outputLineIncrement;
            this.outputStartLine = outputStartLine;
        }

        @NotNull
        @Contract(mutates="param1", pure=false, value="!null -> param1; null -> fail")
        public StringBuilder pushContents(@NotNull StringBuilder sharedBuilder) {
            sharedBuilder.append(this.inputStartLine).appendCodePoint(35).append(this.lineFileId).appendCodePoint(44);
            sharedBuilder.append(this.inputLineCount).appendCodePoint(58).append(this.outputStartLine).appendCodePoint(44);
            sharedBuilder.append(this.outputLineIncrement).appendCodePoint(13);
            return sharedBuilder;
        }
    }
}

