/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.internal.MemberDesc;

public class MemberRenameMap {
    private final Map<MemberDesc, String> renames = new HashMap<MemberDesc, String>();

    public void clear() {
        this.renames.clear();
    }

    @Nullable
    public String get(@NotNull String owner, @NotNull String descriptor, @NotNull String oldName) {
        return this.renames.get(new MemberDesc(owner, oldName, descriptor));
    }

    @NotNull
    public String getOrDefault(@NotNull String owner, @NotNull String descriptor, @NotNull String oldName, @NotNull String defaultValue) {
        return this.renames.getOrDefault(new MemberDesc(owner, oldName, descriptor), defaultValue);
    }

    @NotNull
    public String optGet(@NotNull String owner, @NotNull String descriptor, @NotNull String oldName) {
        return this.renames.getOrDefault(new MemberDesc(owner, oldName, descriptor), oldName);
    }

    public void put(@NotNull String owner, @NotNull String descriptor, @NotNull String name, @NotNull String newName) {
        MemberDesc ref = new MemberDesc(owner, name, descriptor);
        String oldMapping = this.renames.get(ref);
        if (oldMapping == null) {
            this.renames.put(ref, Objects.requireNonNull(newName, "newName cannot be null."));
        } else if (!oldMapping.equals(newName)) {
            throw new IllegalStateException("Overriding member rename for member " + ref.toString());
        }
    }

    public void remove(@NotNull String owner, @NotNull String desc, @NotNull String name) {
        this.renames.remove(new MemberDesc(owner, name, desc));
    }

    public int size() {
        return this.renames.size();
    }

    public void putAllIfAbsent(MemberRenameMap other) {
        other.renames.forEach(this.renames::putIfAbsent);
    }
}

