/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import nilloader.api.lib.asm.Handle;
import nilloader.api.lib.asm.Type;
import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.ClassNode;
import nilloader.api.lib.asm.tree.FieldInsnNode;
import nilloader.api.lib.asm.tree.IincInsnNode;
import nilloader.api.lib.asm.tree.InsnList;
import nilloader.api.lib.asm.tree.InsnNode;
import nilloader.api.lib.asm.tree.IntInsnNode;
import nilloader.api.lib.asm.tree.InvokeDynamicInsnNode;
import nilloader.api.lib.asm.tree.JumpInsnNode;
import nilloader.api.lib.asm.tree.LabelNode;
import nilloader.api.lib.asm.tree.LdcInsnNode;
import nilloader.api.lib.asm.tree.LineNumberNode;
import nilloader.api.lib.asm.tree.LookupSwitchInsnNode;
import nilloader.api.lib.asm.tree.MethodInsnNode;
import nilloader.api.lib.asm.tree.MethodNode;
import nilloader.api.lib.asm.tree.MultiANewArrayInsnNode;
import nilloader.api.lib.asm.tree.TableSwitchInsnNode;
import nilloader.api.lib.asm.tree.TryCatchBlockNode;
import nilloader.api.lib.asm.tree.TypeInsnNode;
import nilloader.api.lib.asm.tree.VarInsnNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.internal.MixinStub;
import org.stianloader.micromixin.transform.internal.util.LabelNodeMapper;
import org.stianloader.micromixin.transform.internal.util.Objects;
import org.stianloader.micromixin.transform.internal.util.smap.MultiplexLineNumberAllocator;

public class CodeCopyUtil {
    @NotNull
    private static final String remapDesc(String desc, @NotNull ClassNode a, @NotNull ClassNode b) {
        return desc.replace("L" + a.name + ";", "L" + b.name + ";");
    }

    public static void copyTo(@NotNull MethodNode source, @NotNull MixinStub sourceStub, @NotNull MethodNode copyTarget, @NotNull AbstractInsnNode endInInsn, @NotNull ClassNode targetOwner, @NotNull SimpleRemapper remapper, @NotNull MultiplexLineNumberAllocator lineAllocator) {
        AbstractInsnNode copyTargetStart;
        AbstractInsnNode copySourceStart = source.instructions.getFirst();
        if (copySourceStart == null) {
            throw new IllegalStateException("Source instruction list is empty!");
        }
        for (copyTargetStart = copyTarget.instructions.getLast(); copyTargetStart != null && copyTargetStart.getOpcode() == -1; copyTargetStart = copyTargetStart.getPrevious()) {
        }
        if (copyTargetStart == null) {
            throw new IllegalStateException("Target instruction list is empty!");
        }
        if (copyTargetStart.getOpcode() != 172 && copyTargetStart.getOpcode() != 173 && copyTargetStart.getOpcode() != 174 && copyTargetStart.getOpcode() != 175 && copyTargetStart.getOpcode() != 176 && copyTargetStart.getOpcode() != 177) {
            throw new IllegalStateException("Invalid copy target: " + targetOwner.name + "." + copyTarget.name + copyTarget.desc + ": Last instruction should be a XRETURN opcode.");
        }
        CodeCopyUtil.copyTo(source, copySourceStart, endInInsn, sourceStub, copyTarget, copyTargetStart, targetOwner, remapper, lineAllocator, true, false);
    }

    @NotNull
    public static MethodNode copyHandler(@NotNull MethodNode source, @NotNull MixinStub sourceStub, @NotNull ClassNode target, @NotNull String handlerName, @NotNull SimpleRemapper remapper, @NotNull MultiplexLineNumberAllocator lineAllocator) {
        ClassNode sourceClass = sourceStub.sourceNode;
        MethodNode handler = new MethodNode();
        handler.name = handlerName;
        handler.desc = CodeCopyUtil.remapDesc(source.desc, sourceClass, target);
        handler.exceptions = source.exceptions;
        handler.access = source.access;
        AbstractInsnNode sourceStartInsn = source.instructions.getFirst();
        AbstractInsnNode sourceEndInsn = source.instructions.getLast();
        if (sourceStartInsn == null || sourceEndInsn == null) {
            throw new IllegalStateException("The source method is empty!");
        }
        LabelNode prevOutInsn = new LabelNode();
        handler.instructions.add((AbstractInsnNode)prevOutInsn);
        CodeCopyUtil.copyTo(source, sourceStartInsn, sourceEndInsn, sourceStub, handler, (AbstractInsnNode)prevOutInsn, target, remapper, lineAllocator, false, true);
        target.methods.add(handler);
        return handler;
    }

    private static Object duplicateRemapBSMArg(Object[] bsmArgs, int index, @NotNull StringBuilder sharedStringBuilder, @NotNull SimpleRemapper remapper) {
        Object bsmArg = bsmArgs[index];
        if (bsmArg instanceof Type) {
            Type type = (Type)bsmArg;
            sharedStringBuilder.setLength(0);
            if (type.getSort() == 11) {
                if (remapper.remapSignature(type.getDescriptor(), sharedStringBuilder)) {
                    return Type.getMethodType(sharedStringBuilder.toString());
                }
            } else if (type.getSort() == 10) {
                String remappedVal;
                String oldVal = type.getInternalName();
                if (oldVal != (remappedVal = remapper.remapInternalName(oldVal, sharedStringBuilder))) {
                    return Type.getObjectType(remappedVal);
                }
            } else {
                throw new IllegalArgumentException("Unexpected bsm arg Type sort. Sort = " + type.getSort() + "; type = " + type);
            }
            return bsmArg;
        }
        if (bsmArg instanceof Handle) {
            boolean modified;
            Handle handle = (Handle)bsmArg;
            String oldName = handle.getName();
            String hOwner = handle.getOwner();
            String newOwner = remapper.getRemappedClassNameFast(hOwner);
            String newName = remapper.getRemappedMethodName(hOwner, oldName, handle.getDesc());
            boolean bl = modified = oldName != newName;
            if (newOwner != null) {
                hOwner = newOwner;
                modified = true;
            }
            String desc = handle.getDesc();
            sharedStringBuilder.setLength(0);
            if (remapper.remapSignature(desc, sharedStringBuilder)) {
                desc = sharedStringBuilder.toString();
                modified = true;
            }
            if (modified) {
                return new Handle(handle.getTag(), hOwner, newName, desc, handle.isInterface());
            }
            return bsmArg;
        }
        if (bsmArg instanceof String) {
            return bsmArg;
        }
        throw new IllegalArgumentException("Unexpected bsm arg class at index " + index + " for " + Arrays.toString(bsmArgs) + ". Class is " + bsmArg.getClass().getName());
    }

    @Nullable
    private static AbstractInsnNode duplicateRemap(@NotNull AbstractInsnNode in, @NotNull SimpleRemapper remapper, @NotNull LabelNodeMapper labelNodeMapper, @NotNull StringBuilder sharedBuilder, boolean invalidInvokestaticRemapping) {
        switch (in.getType()) {
            case 0: {
                return new InsnNode(in.getOpcode());
            }
            case 1: {
                return new IntInsnNode(in.getOpcode(), ((IntInsnNode)in).operand);
            }
            case 2: {
                return new VarInsnNode(in.getOpcode(), ((VarInsnNode)in).var);
            }
            case 3: {
                return new TypeInsnNode(in.getOpcode(), remapper.remapInternalName(((TypeInsnNode)in).desc, sharedBuilder));
            }
            case 4: {
                FieldInsnNode fieldInsn = (FieldInsnNode)in;
                return new FieldInsnNode(fieldInsn.getOpcode(), remapper.remapInternalName(fieldInsn.owner, sharedBuilder), remapper.getRemappedFieldName(fieldInsn.owner, fieldInsn.name, fieldInsn.desc), remapper.getRemappedFieldDescriptor(fieldInsn.desc, sharedBuilder));
            }
            case 5: {
                MethodInsnNode methodInsn = (MethodInsnNode)in;
                if (invalidInvokestaticRemapping && methodInsn.getOpcode() == 184) {
                    return new MethodInsnNode(methodInsn.getOpcode(), remapper.remapInternalName(methodInsn.owner, sharedBuilder), methodInsn.name, remapper.getRemappedMethodDescriptor(methodInsn.desc, sharedBuilder), methodInsn.itf);
                }
                return new MethodInsnNode(methodInsn.getOpcode(), remapper.remapInternalName(methodInsn.owner, sharedBuilder), remapper.getRemappedMethodName(methodInsn.owner, methodInsn.name, methodInsn.desc), remapper.getRemappedMethodDescriptor(methodInsn.desc, sharedBuilder), methodInsn.itf);
            }
            case 6: {
                InvokeDynamicInsnNode indyInsn = (InvokeDynamicInsnNode)in;
                Object[] bsmArgs = indyInsn.bsmArgs;
                int arglen = bsmArgs.length;
                Object[] bsmArgsCopy = new Object[arglen];
                for (int i = 0; i < arglen; ++i) {
                    bsmArgsCopy[i] = CodeCopyUtil.duplicateRemapBSMArg(bsmArgs, i, sharedBuilder, remapper);
                }
                String desc = indyInsn.desc;
                sharedBuilder.setLength(0);
                if (remapper.remapSignature(indyInsn.desc, sharedBuilder)) {
                    desc = sharedBuilder.toString();
                }
                return new InvokeDynamicInsnNode(indyInsn.name, desc, indyInsn.bsm, bsmArgsCopy);
            }
            case 7: {
                return new JumpInsnNode(in.getOpcode(), labelNodeMapper.apply(((JumpInsnNode)in).label));
            }
            case 8: {
                return labelNodeMapper.apply((LabelNode)in);
            }
            case 9: {
                if (((LdcInsnNode)in).cst instanceof Type) {
                    return new LdcInsnNode((Object)Type.getType(remapper.remapSingleDesc(((Type)((LdcInsnNode)in).cst).getDescriptor(), sharedBuilder)));
                }
                return new LdcInsnNode(((LdcInsnNode)in).cst);
            }
            case 10: {
                return new IincInsnNode(((IincInsnNode)in).var, ((IincInsnNode)in).incr);
            }
            case 11: {
                TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)in;
                LabelNode defaultLabel = labelNodeMapper.apply(tableSwitchInsn.dflt);
                LabelNode[] handlerLabels = new LabelNode[tableSwitchInsn.labels.size()];
                int i = 0;
                for (LabelNode label : tableSwitchInsn.labels) {
                    handlerLabels[i++] = labelNodeMapper.apply(label);
                }
                return new TableSwitchInsnNode(tableSwitchInsn.min, tableSwitchInsn.max, defaultLabel, handlerLabels);
            }
            case 12: {
                LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)in;
                LabelNode defaultLabel = labelNodeMapper.apply(lookupSwitchInsn.dflt);
                LabelNode[] handlerLabels = new LabelNode[lookupSwitchInsn.labels.size()];
                int i = 0;
                for (LabelNode label : lookupSwitchInsn.labels) {
                    handlerLabels[i++] = labelNodeMapper.apply(label);
                }
                i = 0;
                int[] keys = new int[lookupSwitchInsn.keys.size()];
                for (Integer key : lookupSwitchInsn.keys) {
                    keys[i++] = key;
                }
                return new LookupSwitchInsnNode(defaultLabel, keys, handlerLabels);
            }
            case 13: {
                return new MultiANewArrayInsnNode(remapper.remapSingleDesc(((MultiANewArrayInsnNode)in).desc, sharedBuilder), ((MultiANewArrayInsnNode)in).dims);
            }
            case 14: {
                return null;
            }
            case 15: {
                LineNumberNode lnn = (LineNumberNode)in;
                return new LineNumberNode(lnn.line, labelNodeMapper.apply(lnn.start));
            }
        }
        throw new IllegalStateException("Unsupported instruction type: " + in.getType() + " (insn of class " + in.getClass() + "); Opcode: " + in.getOpcode());
    }

    public static void copyTo(@NotNull MethodNode source, @NotNull AbstractInsnNode startInInsn, @NotNull AbstractInsnNode endInInsn, @NotNull MixinStub sourceStub, @NotNull MethodNode output, @NotNull AbstractInsnNode previousOutInsn, @NotNull ClassNode targetClass, @NotNull SimpleRemapper remapper, @NotNull MultiplexLineNumberAllocator lineAllocator) {
        CodeCopyUtil.copyTo(source, startInInsn, endInInsn, sourceStub, output, previousOutInsn, targetClass, remapper, lineAllocator, false, false);
    }

    public static void copyTo(@NotNull MethodNode source, @NotNull AbstractInsnNode startInInsn, @NotNull AbstractInsnNode endInInsn, @NotNull MixinStub sourceStub, @NotNull MethodNode output, @NotNull AbstractInsnNode previousOutInsn, @NotNull ClassNode targetClass, @NotNull SimpleRemapper remapper, @NotNull MultiplexLineNumberAllocator lineAllocator, boolean transformReturnToJump, boolean invalidInvokestaticRemapping) {
        AbstractInsnNode inInsn = startInInsn.getPrevious();
        Objects.requireNonNull(endInInsn, "endInInsn must not be null");
        InsnList copiedInstructions = new InsnList();
        final HashMap labelMap = new HashMap();
        HashSet<LabelNode> declaredLabels = new HashSet<LabelNode>();
        StringBuilder sharedBuilder = new StringBuilder();
        LabelNode endLabel = new LabelNode();
        LabelNodeMapper labelMapper = new LabelNodeMapper(){

            @Override
            @NotNull
            public LabelNode apply(LabelNode label) {
                LabelNode l = (LabelNode)labelMap.get(label);
                if (l == null) {
                    l = new LabelNode();
                    labelMap.put(label, l);
                }
                return l;
            }
        };
        do {
            if (inInsn == null) {
                inInsn = startInInsn;
            } else if ((inInsn = inInsn.getNext()) == null) {
                throw new IllegalStateException("Instructions exhausted without reaching endInInsn!");
            }
            if (inInsn.getOpcode() == 177 && transformReturnToJump) {
                copiedInstructions.add((AbstractInsnNode)new JumpInsnNode(167, endLabel));
                continue;
            }
            if (inInsn instanceof LabelNode) {
                declaredLabels.add((LabelNode)inInsn);
            } else if (inInsn instanceof LineNumberNode) {
                LineNumberNode inLineNumberNode = (LineNumberNode)inInsn;
                copiedInstructions.add((AbstractInsnNode)lineAllocator.reserve(sourceStub.sourceNode, inLineNumberNode, labelMapper.apply(inLineNumberNode.start)));
                continue;
            }
            AbstractInsnNode insn = CodeCopyUtil.duplicateRemap(inInsn, remapper, labelMapper, sharedBuilder, invalidInvokestaticRemapping);
            if (insn == null) continue;
            copiedInstructions.add(insn);
        } while (inInsn != endInInsn);
        List tryCatchBlocks = source.tryCatchBlocks;
        if (tryCatchBlocks != null) {
            for (TryCatchBlockNode node : tryCatchBlocks) {
                boolean start = labelMap.containsKey(node.start);
                boolean end = labelMap.containsKey(node.end);
                boolean handler = labelMap.containsKey(node.handler);
                if (start != end || end != handler) {
                    throw new AssertionError((Object)("Attempted to chop of a try-catch block of " + sourceStub.sourceNode.name + "." + source.name + source.desc + ". Start chopped: " + !start + ", end chopped: " + !end + ", handler chopped: " + !handler + ". This is likely a bug in the micromixin library."));
                }
                if (!start) continue;
                String htype = node.type;
                if (htype != null) {
                    remapper.remapInternalName(htype, sharedBuilder);
                }
                if (output.tryCatchBlocks == null) {
                    output.tryCatchBlocks = new ArrayList();
                }
                output.tryCatchBlocks.add(new TryCatchBlockNode((LabelNode)labelMap.get(node.start), (LabelNode)labelMap.get(node.end), (LabelNode)labelMap.get(node.handler), htype));
            }
        }
        if (declaredLabels.size() < labelMap.size()) {
            throw new AssertionError((Object)(labelMap.size() - declaredLabels.size() + " more label(s) were chopped of while copying " + sourceStub.sourceNode.name + "." + source.name + source.desc + " to " + targetClass.name + "." + output.name + output.desc + ". This is likely a bug in the micromixin library."));
        }
        if (transformReturnToJump) {
            copiedInstructions.add((AbstractInsnNode)endLabel);
        }
        output.instructions.insert(previousOutInsn, copiedInstructions);
    }
}

