/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.selectors.constant;

import nilloader.api.lib.asm.Type;
import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.LdcInsnNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.internal.annotation.ConstantSelector;

public class ClassConstantSelector
extends ConstantSelector {
    @NotNull
    private final String value;

    public ClassConstantSelector(@NotNull String value) {
        this.value = value;
    }

    @Override
    public boolean matchesConstant(@NotNull AbstractInsnNode insn) {
        if (insn.getOpcode() != 18) {
            return false;
        }
        LdcInsnNode ldcInsn = (LdcInsnNode)insn;
        if (!(ldcInsn.cst instanceof Type)) {
            return false;
        }
        return ((Type)ldcInsn.cst).getDescriptor().equals(this.value);
    }
}

