/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.ClassNode;
import nilloader.api.lib.asm.tree.InsnNode;
import nilloader.api.lib.asm.tree.LabelNode;
import nilloader.api.lib.asm.tree.MethodNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.internal.HandlerContextHelper;
import org.stianloader.micromixin.transform.internal.MixinMethodStub;
import org.stianloader.micromixin.transform.internal.MixinStub;
import org.stianloader.micromixin.transform.internal.annotation.MixinAnnotation;
import org.stianloader.micromixin.transform.internal.util.CodeCopyUtil;

public class VirtualClInitMergeAnnotation
extends MixinAnnotation<MixinMethodStub> {
    @NotNull
    private final MethodNode src;

    public VirtualClInitMergeAnnotation(@NotNull MethodNode src) {
        this.src = src;
    }

    @Override
    public void apply(@NotNull ClassNode to, @NotNull HandlerContextHelper hctx, @NotNull MixinStub sourceStub, @NotNull MixinMethodStub source, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        MethodNode target = null;
        for (MethodNode method : to.methods) {
            if (!method.name.equals("<clinit>") || !method.desc.equals("()V")) continue;
            target = method;
            break;
        }
        if (target == null) {
            target = new MethodNode(9, "<clinit>", "()V", null, null);
            target.instructions.add((AbstractInsnNode)new InsnNode(177));
        }
        AbstractInsnNode nextOutInsn = target.instructions.getLast();
        while (nextOutInsn.getOpcode() == -1) {
            nextOutInsn = nextOutInsn.getPrevious();
        }
        if (nextOutInsn.getOpcode() != 177) {
            throw new IllegalStateException("Invalid clinit block: " + to.name + "." + target.name + target.desc + ": Last instruction should be a RETURN opcode.");
        }
        AbstractInsnNode previousOutInsn = nextOutInsn.getPrevious();
        if (previousOutInsn == null) {
            previousOutInsn = new LabelNode();
            target.instructions.insertBefore(nextOutInsn, previousOutInsn);
        }
        AbstractInsnNode startInInsn = this.src.instructions.getFirst();
        AbstractInsnNode endInInsn = this.src.instructions.getLast();
        if (startInInsn == null || endInInsn == null) {
            throw new IllegalStateException("abstract clinit method: " + source.owner.name + "." + source.getName() + source.getDesc());
        }
        CodeCopyUtil.copyTo(this.src, startInInsn, endInInsn, sourceStub, target, previousOutInsn, to, remapper, hctx.lineAllocator, true, false);
    }

    @Override
    public void collectMappings(@NotNull MixinMethodStub source, @NotNull ClassNode target, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
    }
}

