/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.AnnotationNode;
import nilloader.api.lib.asm.tree.ClassNode;
import nilloader.api.lib.asm.tree.InsnList;
import nilloader.api.lib.asm.tree.InsnNode;
import nilloader.api.lib.asm.tree.MethodInsnNode;
import nilloader.api.lib.asm.tree.MethodNode;
import nilloader.api.lib.asm.tree.VarInsnNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.api.MixinLoggingFacade;
import org.stianloader.micromixin.transform.api.MixinTransformer;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.api.SlicedInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.HandlerContextHelper;
import org.stianloader.micromixin.transform.internal.MixinMethodStub;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.MixinStub;
import org.stianloader.micromixin.transform.internal.annotation.MixinAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinAtAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinDescAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinSliceAnnotation;
import org.stianloader.micromixin.transform.internal.selectors.DescSelector;
import org.stianloader.micromixin.transform.internal.selectors.MixinTargetSelector;
import org.stianloader.micromixin.transform.internal.selectors.StringSelector;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;
import org.stianloader.micromixin.transform.internal.util.CodeCopyUtil;
import org.stianloader.micromixin.transform.internal.util.DescString;
import org.stianloader.micromixin.transform.internal.util.InjectionPointReference;
import org.stianloader.micromixin.transform.internal.util.Objects;

public class MixinModifyArgAnnotation
extends MixinAnnotation<MixinMethodStub> {
    private final int allow;
    @NotNull
    public final Collection<SlicedInjectionPointSelector> at;
    @NotNull
    public final Collection<MixinTargetSelector> selectors;
    @NotNull
    private final MethodNode injectSource;
    private final int require;
    private final int expect;
    private final int index;
    @NotNull
    private final MixinLoggingFacade logger;

    private MixinModifyArgAnnotation(@NotNull Collection<SlicedInjectionPointSelector> at, @NotNull Collection<MixinTargetSelector> selectors, @NotNull MethodNode injectSource, int require, int expect, int allow, @NotNull MixinLoggingFacade logger, int index) {
        this.at = at;
        this.selectors = selectors;
        this.injectSource = injectSource;
        this.require = require;
        this.expect = expect;
        this.allow = allow;
        this.logger = logger;
        this.index = index;
    }

    @Override
    public void apply(@NotNull ClassNode to, @NotNull HandlerContextHelper hctx, @NotNull MixinStub sourceStub, @NotNull MixinMethodStub source, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        MethodNode handlerNode = CodeCopyUtil.copyHandler(this.injectSource, sourceStub, to, hctx.generateUniqueLocalPrefix() + this.injectSource.name, remapper, hctx.lineAllocator);
        Collection<InjectionPointReference> matched = ASMUtil.enumerateTargets(this.selectors, this.at, to, sourceStub, this.injectSource, this.require, this.expect, this.allow, remapper, sharedBuilder, this.logger);
        String argumentType = ASMUtil.getReturnType(this.injectSource.desc);
        for (InjectionPointReference entry : matched) {
            int handlerInvokeOpcode;
            MethodNode method = entry.targetedMethod;
            if (entry.shiftedInstruction.getType() != 5) {
                throw new IllegalStateException("The argument modifier method " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " targets an instruction that isn't in the INVOKEx (except INVOKEDYNAMIC) family of instructions. The targeted instruction is in " + to.name + "." + method.name + method.desc);
            }
            String targetDesc = ((MethodInsnNode)entry.shiftedInstruction).desc;
            InsnList inject = new InsnList();
            ArrayList<String> arguments = new ArrayList<String>();
            int argIndex = this.index;
            DescString dString = new DescString(targetDesc);
            int i = 0;
            while (dString.hasNext()) {
                String arg = dString.nextType();
                if (this.index == -1) {
                    if (argumentType.equals(arg)) {
                        if (argIndex != -1) {
                            throw new IllegalStateException("The argument modifier method " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " targets an instruction with the descriptor of " + targetDesc + " (within " + to.name + "." + method.name + method.desc + "), however the automatic argument index is too ambiguous if matching " + argumentType + '.');
                        }
                        argIndex = i;
                    }
                } else if (i == argIndex && !argumentType.equals(arg)) {
                    throw new IllegalStateException("The argument modifier method " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " targets an instruction with the descriptor of " + targetDesc + " (within " + to.name + "." + method.name + method.desc + "), however the argument index " + argIndex + " does not have the expected argument type " + argumentType + ", but rather " + arg);
                }
                arguments.add(arg);
                ++i;
            }
            if (argIndex == -1) {
                throw new IllegalStateException("The argument modifier method " + sourceStub.sourceNode.name + "." + this.injectSource.name + this.injectSource.desc + " targets an instruction with the descriptor of " + targetDesc + " (within " + to.name + "." + method.name + method.desc + "), however the automatic argument index did not find any argument matching " + argumentType + '.');
            }
            InsnList rollbackInsns = new InsnList();
            int uniformDepth = arguments.size() - argIndex - 1;
            if (uniformDepth != 0) {
                ASMUtil.moveStackHead(method, entry.shiftedInstruction, entry.shiftedInstruction, arguments, uniformDepth, inject, rollbackInsns);
            }
            if ((handlerNode.access & 8) == 0) {
                handlerInvokeOpcode = 182;
                inject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                if (ASMUtil.isCategory2(argumentType.codePointAt(0))) {
                    inject.add((AbstractInsnNode)new InsnNode(91));
                    inject.add((AbstractInsnNode)new InsnNode(87));
                } else {
                    inject.add((AbstractInsnNode)new InsnNode(95));
                }
            } else {
                handlerInvokeOpcode = 184;
            }
            inject.add((AbstractInsnNode)new MethodInsnNode(handlerInvokeOpcode, to.name, handlerNode.name, handlerNode.desc));
            inject.add(rollbackInsns);
            method.instructions.insertBefore(entry.shiftedInstruction, inject);
        }
    }

    @Override
    public void collectMappings(@NotNull MixinMethodStub source, @NotNull ClassNode target, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
    }

    @NotNull
    public static MixinModifyArgAnnotation parse(@NotNull ClassNode node, @NotNull MethodNode method, @NotNull AnnotationNode annot, @NotNull MixinTransformer<?> transformer, @NotNull StringBuilder sharedBuilder) throws MixinParseException {
        if ((method.access & 8) != 0 && (method.access & 2) == 0) {
            throw new MixinParseException("The return value modifier method " + node.name + "." + method.name + method.desc + " is static, but isn't private. Consider making the method private.");
        }
        DescString descString = new DescString(method.desc);
        if (!descString.hasNext()) {
            throw new MixinParseException("The return value modifier method " + node.name + "." + method.name + method.desc + " is annotated with @ModifyArg but it does not consume the original argument value. Argument modifiers may not be no-args methods!");
        }
        String argType = descString.nextType();
        if (descString.hasNext()) {
            throw new MixinParseException("The return value modifier method " + node.name + "." + method.name + method.desc + " is annotated with @ModifyArg but it has more than a single argument! Note that argument modifiers are ineligble for argument and local capture.");
        }
        if (!ASMUtil.getReturnType(method.desc).equals(argType)) {
            throw new MixinParseException("The return value modifier method " + node.name + "." + method.name + method.desc + " is annotated with @ModifyArg but has an invalid descriptor! Argument modifiers must return the same type as they consume - irrespective of class hierarchy.");
        }
        ArrayList<MixinAtAnnotation> at = new ArrayList<MixinAtAnnotation>();
        ArrayList<MixinSliceAnnotation> slice = new ArrayList<MixinSliceAnnotation>();
        Collection<MixinDescAnnotation> target = null;
        String[] targetSelectors = null;
        int require = -1;
        int expect = -1;
        int index = -1;
        int allow = -1;
        for (int i = 0; i < annot.values.size(); i += 2) {
            String name = (String)annot.values.get(i);
            Object val = annot.values.get(i + 1);
            if (name.equals("at")) {
                AnnotationNode atValue = (AnnotationNode)val;
                if (atValue == null) {
                    throw new NullPointerException();
                }
                try {
                    at.add(MixinAtAnnotation.parse(node, atValue, transformer.getInjectionPointSelectors()));
                    continue;
                }
                catch (MixinParseException mixinParseException) {
                    throw new MixinParseException("Unable to parse @At annotation defined by " + node.name + "." + method.name + method.desc, mixinParseException);
                }
            }
            if (name.equals("target")) {
                if (target != null) {
                    throw new MixinParseException("Duplicate \"target\" field in @ModifyArg.");
                }
                target = new ArrayList();
                List atValues = (List)val;
                for (AnnotationNode atValue : atValues) {
                    if (atValue == null) {
                        throw new NullPointerException();
                    }
                    MixinDescAnnotation parsed = MixinDescAnnotation.parse(node, atValue);
                    target.add(parsed);
                }
                target = Collections.unmodifiableCollection(target);
                continue;
            }
            if (name.equals("method")) {
                String[] hack;
                if (targetSelectors != null) {
                    throw new MixinParseException("Duplicate \"method\" field in @ModifyArg.");
                }
                targetSelectors = hack = ((List)val).toArray(new String[0]);
                continue;
            }
            if (name.equals("require")) {
                require = (Integer)val;
                continue;
            }
            if (name.equals("expect")) {
                expect = (Integer)val;
                continue;
            }
            if (name.equals("allow")) {
                allow = (Integer)val;
                continue;
            }
            if (name.equals("index")) {
                index = (Integer)val;
                continue;
            }
            if (name.equals("slice")) {
                AnnotationNode sliceValue = (AnnotationNode)val;
                if (sliceValue == null) {
                    throw new NullPointerException();
                }
                try {
                    slice.add(MixinSliceAnnotation.parse(node, sliceValue, transformer.getInjectionPointSelectors()));
                    continue;
                }
                catch (MixinParseException mixinParseException) {
                    throw new MixinParseException("Unable to parse @Slice annotation defined by " + node.name + "." + method.name + method.desc, mixinParseException);
                }
            }
            throw new MixinParseException("Unimplemented key in @ModifyArg: " + name);
        }
        ArrayList<MixinTargetSelector> selectors = new ArrayList<MixinTargetSelector>();
        if (target != null) {
            for (MixinDescAnnotation desc : target) {
                selectors.add(new DescSelector(Objects.requireNonNull(desc)));
            }
        }
        if (targetSelectors != null) {
            for (void var18_25 : targetSelectors) {
                selectors.add(new StringSelector((String)Objects.requireNonNull(var18_25)));
            }
        }
        if (selectors.isEmpty()) {
            throw new MixinParseException("No available selectors: Mixin " + node.name + "." + method.name + method.desc + " does not match anything and is not a valid mixin.");
        }
        if (allow < require) {
            allow = -1;
        }
        Collection<SlicedInjectionPointSelector> slicedAts = Collections.unmodifiableCollection(MixinAtAnnotation.bake(at, slice));
        return new MixinModifyArgAnnotation(slicedAts, Collections.unmodifiableCollection(selectors), method, require, expect, allow, transformer.getLogger(), index);
    }
}

