/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nilloader.api.lib.asm.Type;
import nilloader.api.lib.asm.tree.AnnotationNode;
import nilloader.api.lib.asm.tree.ClassNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.api.InjectionPointSelector;
import org.stianloader.micromixin.transform.api.InjectionPointSelectorFactory;
import org.stianloader.micromixin.transform.api.InjectionPointTargetConstraint;
import org.stianloader.micromixin.transform.api.SlicedInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.annotation.ConstantSelector;
import org.stianloader.micromixin.transform.internal.annotation.MixinDescAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinSliceAnnotation;
import org.stianloader.micromixin.transform.internal.selectors.DescSelector;
import org.stianloader.micromixin.transform.internal.selectors.MixinTargetSelector;
import org.stianloader.micromixin.transform.internal.selectors.StringSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.ClassConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.DoubleConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.FloatConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.IntConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.LongConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.NullConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.StringConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.ConstantInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.HeadInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.TailInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.util.Objects;

public class MixinAtAnnotation {
    @NotNull
    public static final MixinAtAnnotation HEAD = new MixinAtAnnotation("HEAD", HeadInjectionPointSelector.INSTANCE, "", 0, false);
    @NotNull
    public static final MixinAtAnnotation TAIL = new MixinAtAnnotation("TAIL", TailInjectionPointSelector.INSTANCE, "", 0, true);
    @NotNull
    public final InjectionPointSelector injectionPointSelector;
    private final int shift;
    @NotNull
    public final String slice;
    private final boolean unsafe;
    @NotNull
    public final String value;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<SlicedInjectionPointSelector> bake(@NotNull List<MixinAtAnnotation> ats, @NotNull List<MixinSliceAnnotation> slices) throws MixinParseException {
        ArrayList<SlicedInjectionPointSelector> baked = new ArrayList<SlicedInjectionPointSelector>(ats.size());
        HashMap dependents = new HashMap();
        HashMap<String, MixinSliceAnnotation> name2slice = new HashMap<String, MixinSliceAnnotation>();
        for (MixinAtAnnotation at : ats) {
            void var7_7;
            List list = (List)dependents.get(at.slice);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                dependents.put(at.slice, arrayList);
            }
            var7_7.add(at);
        }
        HashMap sliceDependenciesShallow = new HashMap();
        for (MixinSliceAnnotation mixinSliceAnnotation : slices) {
            List dependencies;
            if (name2slice.put(mixinSliceAnnotation.id, mixinSliceAnnotation) != null) {
                throw new MixinParseException("At least two slices with the id '" + mixinSliceAnnotation.id + "' have been defined, but duplicate slice IDs are not permitted.");
            }
            LinkedHashSet<String> deps = new LinkedHashSet<String>();
            sliceDependenciesShallow.put(mixinSliceAnnotation.id, deps);
            if (!mixinSliceAnnotation.id.equals("") || !mixinSliceAnnotation.from.slice.equals("")) {
                dependencies = (ArrayList)dependents.get(mixinSliceAnnotation.from.slice);
                if (dependencies == null) {
                    dependencies = new ArrayList();
                    dependents.put(mixinSliceAnnotation.from.slice, dependencies);
                }
                ats.add(mixinSliceAnnotation.from);
                deps.add(mixinSliceAnnotation.from.slice);
            }
            if (mixinSliceAnnotation.id.equals("") && mixinSliceAnnotation.to.slice.equals("")) continue;
            dependencies = (List)dependents.get(mixinSliceAnnotation.to.slice);
            if (dependencies == null) {
                dependencies = new ArrayList();
                dependents.put(mixinSliceAnnotation.to.slice, dependencies);
            }
            ats.add(mixinSliceAnnotation.to);
            deps.add(mixinSliceAnnotation.to.slice);
        }
        if (!name2slice.containsKey("")) {
            name2slice.put("", new MixinSliceAnnotation("", HEAD, TAIL));
        }
        for (Map.Entry entry : dependents.entrySet()) {
            if (name2slice.containsKey(entry.getKey())) continue;
            throw new MixinParseException("A slice with the id of '" + (String)entry.getKey() + "' is requested but never defined. Is there a typo in your slice IDs?");
        }
        final HashMap sliceDependenciesDeep = new HashMap();
        HashSet hashSet = new HashSet(sliceDependenciesShallow.keySet());
        HashSet<String> stale2 = new HashSet<String>();
        HashMap<String, String> subdeps2 = new HashMap<String, String>();
        while (!hashSet.isEmpty()) {
            for (String sliceId : hashSet) {
                HashMap<String, String> subdeps = (HashMap<String, String>)sliceDependenciesDeep.get(sliceId);
                if (subdeps == null) {
                    subdeps = new HashMap<String, String>();
                    sliceDependenciesDeep.put(sliceId, subdeps);
                }
                for (String dep : subdeps.keySet()) {
                    Set subsubdep = (Set)sliceDependenciesShallow.get(dep);
                    if (subsubdep.contains(sliceId)) {
                        String path = " '" + dep + "' -> '" + sliceId + "'";
                        String parent = (String)subdeps.get(dep);
                        while (parent != null) {
                            path = " '" + parent + "' ->" + path;
                            parent = (String)subdeps.get(dep);
                        }
                        throw new MixinParseException("Slice dependency circularity: Slice id '" + sliceId + "' directly or indirectly depends on itself. Dependency chain path:" + path + ". Please verify that all @Slice and @At annotations are properly set up. Note that multiple paths may exist, this noted path just happens to be one.");
                    }
                    for (String d : subsubdep) {
                        if (subdeps.containsKey(d)) continue;
                        subdeps2.put(d, dep);
                    }
                }
                if (subdeps2.isEmpty()) continue;
                subdeps.putAll(subdeps2);
                subdeps2.clear();
                stale2.add(sliceId);
            }
            hashSet.clear();
            hashSet.addAll(stale2);
            stale2.clear();
        }
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int s2;
                int s1 = ((Map)sliceDependenciesDeep.get(o1)).size();
                if (s1 != (s2 = ((Map)sliceDependenciesDeep.get(o2)).size())) {
                    return s2 - s1;
                }
                return o1.compareTo(o2);
            }
        });
        treeSet.addAll(sliceDependenciesDeep.keySet());
        HashSet<String> evaluatedSlices = new HashSet<String>();
        HashMap<String, SlicedInjectionPointSelector> sliceFrom = new HashMap<String, SlicedInjectionPointSelector>();
        HashMap<String, SlicedInjectionPointSelector> sliceTo = new HashMap<String, SlicedInjectionPointSelector>();
        for (String slice : treeSet) {
            evaluatedSlices.add(slice);
            if (!evaluatedSlices.containsAll(((Map)sliceDependenciesDeep.get(slice)).keySet())) {
                throw new IllegalStateException("Slice " + slice + " depends on non-evaluated slices. This is an internal algorithmic error - please report this issue to the micromixin maintainers.");
            }
            MixinSliceAnnotation sliceAnnot = (MixinSliceAnnotation)name2slice.get(slice);
            SlicedInjectionPointSelector from = null;
            SlicedInjectionPointSelector to = null;
            if (sliceAnnot.from != HEAD) {
                SlicedInjectionPointSelector fromFrom = (SlicedInjectionPointSelector)sliceFrom.get(sliceAnnot.from.slice);
                SlicedInjectionPointSelector fromTo = (SlicedInjectionPointSelector)sliceTo.get(sliceAnnot.from.slice);
                from = new SlicedInjectionPointSelector(sliceAnnot.from.injectionPointSelector, fromFrom, fromTo, sliceAnnot.from.shift, sliceAnnot.from.unsafe);
            }
            if (sliceAnnot.to != TAIL) {
                SlicedInjectionPointSelector toFrom = (SlicedInjectionPointSelector)sliceFrom.get(sliceAnnot.to.slice);
                SlicedInjectionPointSelector toTo = (SlicedInjectionPointSelector)sliceTo.get(sliceAnnot.to.slice);
                to = new SlicedInjectionPointSelector(sliceAnnot.to.injectionPointSelector, toFrom, toTo, sliceAnnot.to.shift, sliceAnnot.to.unsafe);
            }
            sliceFrom.put(slice, from);
            sliceTo.put(slice, to);
        }
        for (MixinAtAnnotation annot : ats) {
            SlicedInjectionPointSelector from = (SlicedInjectionPointSelector)sliceFrom.get(annot.slice);
            SlicedInjectionPointSelector to = (SlicedInjectionPointSelector)sliceTo.get(annot.slice);
            baked.add(new SlicedInjectionPointSelector(annot.injectionPointSelector, from, to, annot.shift, annot.unsafe));
        }
        return baked;
    }

    @NotNull
    public static SlicedInjectionPointSelector bake(@NotNull MixinAtAnnotation at, @Nullable MixinSliceAnnotation slice) {
        if (slice == null) {
            return new SlicedInjectionPointSelector(at.injectionPointSelector, null, null, at.shift, at.unsafe);
        }
        SlicedInjectionPointSelector from = null;
        SlicedInjectionPointSelector to = null;
        if (slice.from != HEAD) {
            from = new SlicedInjectionPointSelector(slice.from.injectionPointSelector, null, null, at.shift, at.unsafe);
        }
        if (slice.to != TAIL) {
            to = new SlicedInjectionPointSelector(slice.to.injectionPointSelector, null, null, at.shift, at.unsafe);
        }
        return new SlicedInjectionPointSelector(at.injectionPointSelector, from, to, at.shift, at.unsafe);
    }

    @NotNull
    public static MixinAtAnnotation parse(@NotNull ClassNode mixinSource, @NotNull AnnotationNode atValue, @NotNull InjectionPointSelectorFactory factory) throws MixinParseException {
        String slice = "";
        String value = null;
        List args = null;
        MixinTargetSelector constraint = null;
        int shift = 0;
        for (int i = 0; i < atValue.values.size(); i += 2) {
            String name = (String)atValue.values.get(i);
            Object val = atValue.values.get(i + 1);
            if (name.equals("value")) {
                value = ((String)val).toUpperCase(Locale.ROOT);
                continue;
            }
            if (name.equals("args")) {
                List temp;
                args = temp = (List)val;
                continue;
            }
            if (name.equals("target")) {
                constraint = new StringSelector((String)Objects.requireNonNull(val));
                continue;
            }
            if (name.equals("slice")) {
                slice = (String)Objects.requireNonNull(val);
                continue;
            }
            if (name.equals("desc")) {
                constraint = new DescSelector(MixinDescAnnotation.parse(mixinSource, Objects.requireNonNull((AnnotationNode)val)));
                continue;
            }
            if (name.equals("shift")) {
                Object[] enumValue = (String[])val;
                if (!enumValue[0].equals("Lorg/spongepowered/asm/mixin/injection/At$Shift;")) {
                    throw new MixinParseException("Unimplemented enum type for @At.shift: " + Arrays.toString(enumValue));
                }
                if (enumValue[1].equals("NONE")) {
                    shift = 0;
                    continue;
                }
                if (((String)enumValue[1]).equals("BEFORE")) {
                    shift = -1;
                    continue;
                }
                if (((String)enumValue[1]).equals("AFTER")) {
                    shift = 1;
                    continue;
                }
                throw new MixinParseException("Unimplemented enum value for @At.shift: " + Arrays.toString(enumValue));
            }
            throw new MixinParseException("Unimplemented key in @At: " + name);
        }
        if (value == null) {
            throw new MixinParseException("The required field \"value\" is missing.");
        }
        return new MixinAtAnnotation(value, factory.get(value).create(args, (InjectionPointTargetConstraint)((Object)constraint)), slice, shift, false);
    }

    @NotNull
    public static MixinAtAnnotation parseConstantAnnotation(@NotNull ClassNode mixinSource, @NotNull AnnotationNode constantValue) throws MixinParseException {
        String slice = "";
        ConstantSelector selector = null;
        for (int i = 0; i < constantValue.values.size(); i += 2) {
            String name = (String)constantValue.values.get(i);
            Object val = constantValue.values.get(i + 1);
            if (name.equals("nullValue")) {
                if (selector != null) {
                    throw new MixinParseException("@Constant may not have multiple value selectors (this is likely a flaw of micromxin).");
                }
                if (((Boolean)val).booleanValue()) {
                    selector = NullConstantSelector.INSTANCE;
                    continue;
                }
                throw new MixinParseException("@Constant may not have nullValue=false within the micromixin implementation (this is likely a flaw of micromxin).");
            }
            if (name.equals("intValue")) {
                if (selector != null) {
                    throw new MixinParseException("@Constant may not have multiple value selectors (this is likely a flaw of micromxin).");
                }
                selector = new IntConstantSelector((Integer)val);
                continue;
            }
            if (name.equals("stringValue")) {
                if (selector != null) {
                    throw new MixinParseException("@Constant may not have multiple value selectors (this is likely a flaw of micromxin).");
                }
                selector = new StringConstantSelector(Objects.requireNonNull((String)val));
                continue;
            }
            if (name.equals("classValue")) {
                if (selector != null) {
                    throw new MixinParseException("@Constant may not have multiple value selectors (this is likely a flaw of micromxin).");
                }
                selector = new ClassConstantSelector(Objects.requireNonNull((Type)val).getDescriptor());
                continue;
            }
            if (name.equals("doubleValue")) {
                if (selector != null) {
                    throw new MixinParseException("@Constant may not have multiple value selectors (this is likely a flaw of micromxin).");
                }
                selector = new DoubleConstantSelector((Double)val);
                continue;
            }
            if (name.equals("floatValue")) {
                if (selector != null) {
                    throw new MixinParseException("@Constant may not have multiple value selectors (this is likely a flaw of micromxin).");
                }
                selector = new FloatConstantSelector(((Float)val).floatValue());
                continue;
            }
            if (name.equals("longValue")) {
                if (selector != null) {
                    throw new MixinParseException("@Constant may not have multiple value selectors (this is likely a flaw of micromxin).");
                }
                selector = new LongConstantSelector((Long)val);
                continue;
            }
            if (name.equals("slice")) {
                slice = (String)Objects.requireNonNull(val);
                continue;
            }
            throw new MixinParseException("Unimplemented key in @Constant: " + name);
        }
        if (selector == null) {
            throw new MixinParseException("The @Constant annotation requires any of the following required fields: [nullValue, stringValue, intValue, classValue, doubleValue].");
        }
        return new MixinAtAnnotation("CONSTANT", new ConstantInjectionPointSelector(selector), slice, 0, false);
    }

    public MixinAtAnnotation(@NotNull String value, @NotNull InjectionPointSelector selector, @NotNull String slice, int shift, boolean unsafe) {
        this.value = value;
        this.injectionPointSelector = selector;
        this.slice = slice;
        this.shift = shift;
        this.unsafe = unsafe;
    }
}

