/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import java.util.List;
import nilloader.api.lib.asm.tree.AbstractInsnNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.selectors.constant.ClassConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.DoubleConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.FloatConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.IntConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.LongConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.NullConstantSelector;
import org.stianloader.micromixin.transform.internal.selectors.constant.StringConstantSelector;

public abstract class ConstantSelector {
    @NotNull
    public static ConstantSelector parse(@NotNull List<String> args) {
        for (String s : args) {
            int equalIndex = s.indexOf(61);
            if (equalIndex == -1) continue;
            String key = s.substring(0, equalIndex);
            String value = s.substring(equalIndex + 1);
            if (key.equals("nullValue") && value.equals("true")) {
                return NullConstantSelector.INSTANCE;
            }
            if (key.equals("intValue")) {
                return new IntConstantSelector(Integer.parseInt(value));
            }
            if (key.equals("stringValue")) {
                return new StringConstantSelector(value);
            }
            if (key.equals("classValue")) {
                return new ClassConstantSelector(value);
            }
            if (key.equals("doubleValue")) {
                return new DoubleConstantSelector(Double.parseDouble(value));
            }
            if (key.equals("floatValue")) {
                return new FloatConstantSelector(Float.parseFloat(value));
            }
            if (!key.equals("longValue")) continue;
            return new LongConstantSelector(Long.parseLong(value));
        }
        throw new MixinParseException("Cannot find any constant values in @At(\"CONSTANT\") args. An example would be @At(value = \"CONSTANT\", args = {\"intValue=5\"}). Note: Whitespaces are not allowed between either side of the equals.");
    }

    public abstract boolean matchesConstant(@NotNull AbstractInsnNode var1);
}

