/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nilloader.api.lib.asm.Type;
import nilloader.api.lib.asm.tree.AnnotationNode;
import nilloader.api.lib.asm.tree.ClassNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.internal.MixinParseException;

public class MixinHeader {
    @NotNull
    public final Collection<String> targets;
    public final int priority;

    public MixinHeader(@NotNull Collection<String> targets, int priority) {
        this.targets = targets;
        this.priority = priority;
    }

    @NotNull
    public static MixinHeader parse(@NotNull ClassNode node, int defaultPriority) throws MixinParseException {
        AnnotationNode mixinAnnot = null;
        if (node.invisibleAnnotations == null) {
            throw new MixinParseException("The class " + node.name + " does not contain a @Mixin-annotation and thus is an invalid mixin.");
        }
        for (AnnotationNode annot : node.invisibleAnnotations) {
            if (!annot.desc.equals("Lorg/spongepowered/asm/mixin/Mixin;")) continue;
            if (mixinAnnot != null) {
                throw new MixinParseException("Multiple @Mixin annotations???");
            }
            mixinAnnot = annot;
        }
        if (mixinAnnot == null) {
            throw new MixinParseException("Did not find a @Mixin Annotation in class " + node.name);
        }
        ArrayList<String> targets = new ArrayList<String>();
        int priority = defaultPriority;
        for (int i = 0; i < mixinAnnot.values.size(); i += 2) {
            List aev;
            String name = (String)mixinAnnot.values.get(i);
            Object value = mixinAnnot.values.get(i + 1);
            if (name.equals("value")) {
                aev = (List)value;
                for (Object target : aev) {
                    targets.add(((Type)target).getDescriptor());
                }
                continue;
            }
            if (name.equals("targets")) {
                aev = (List)value;
                for (Object target : aev) {
                    targets.add('L' + ((String)target).replace('.', '/') + ';');
                }
                continue;
            }
            if (name.equals("priority")) {
                priority = (Integer)value;
                continue;
            }
            throw new MixinParseException("Unimplemented key in @Mixin: " + name);
        }
        ArrayList<String> saneTargets = new ArrayList<String>();
        for (String t : targets) {
            if (t.charAt(0) != 'L') {
                throw new MixinParseException("Incorrect mixin target in class " + node.name + ": " + t + " (Note: arrays and primitives are not supported.)");
            }
            saneTargets.add(t.substring(1, t.length() - 1));
        }
        return new MixinHeader(Collections.unmodifiableCollection(saneTargets), priority);
    }
}

