/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal;

import nilloader.api.lib.asm.tree.ClassNode;
import nilloader.api.lib.asm.tree.MethodNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.internal.util.smap.MultiplexLineNumberAllocator;

public class HandlerContextHelper {
    @NotNull
    private final String globalHandlerPrefix;
    private int handlerCounter = 0;
    @NotNull
    public final MultiplexLineNumberAllocator lineAllocator;

    @NotNull
    public static HandlerContextHelper from(@NotNull ClassNode node) {
        String[] methodNames = new String[node.methods.size()];
        int n = 0;
        for (MethodNode method : node.methods) {
            methodNames[n++] = method.name;
        }
        for (String s : methodNames) {
            String prefix;
            if (!s.startsWith("$handler$")) continue;
            int i = 0;
            block2: while (true) {
                prefix = "$handler$" + i++ + "$";
                for (String mname : methodNames) {
                    if (mname.startsWith(prefix)) continue block2;
                }
                break;
            }
            return new HandlerContextHelper(prefix, new MultiplexLineNumberAllocator(node));
        }
        return new HandlerContextHelper("$handler$", new MultiplexLineNumberAllocator(node));
    }

    private HandlerContextHelper(@NotNull String handlerPrefix, @NotNull MultiplexLineNumberAllocator lineAllocator) {
        this.globalHandlerPrefix = handlerPrefix;
        this.lineAllocator = lineAllocator;
    }

    @NotNull
    public String generateUniqueLocalPrefix() {
        return this.globalHandlerPrefix + this.handlerCounter++ + "$";
    }
}

