/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.api;

import de.geolykt.nilmm.internal.dependency.json.JSONArray;
import de.geolykt.nilmm.internal.dependency.json.JSONException;
import de.geolykt.nilmm.internal.dependency.json.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MixinConfig {
    public final boolean required;
    @Nullable
    public final String minVersion;
    @NotNull
    public final String mixinPackage;
    @Nullable
    public final String target;
    @Nullable
    public final String compatibiltyLevel;
    @NotNull
    public final Collection<String> mixins;
    public final int priority;
    public final boolean verbose;
    @Nullable
    public final String refmap;
    public final boolean setSourceFile;
    @NotNull
    public final Collection<String> client;
    @NotNull
    public final Collection<String> server;

    @NotNull
    public static MixinConfig fromString(@NotNull String s) throws InvalidMixinConfigException {
        try {
            return MixinConfig.fromJson(new JSONObject(s));
        }
        catch (JSONException e) {
            InvalidMixinConfigException throwEx = new InvalidMixinConfigException("The mixin contents do not follow the expected format!");
            throwEx.initCause(e);
            throw throwEx;
        }
    }

    @NotNull
    public static MixinConfig fromJson(@NotNull JSONObject object) throws InvalidMixinConfigException {
        String mixinPackage = object.optString("package");
        if (mixinPackage == null) {
            throw new InvalidMixinConfigException("The required field \"package\" is missing from the mixin configuration.");
        }
        mixinPackage = mixinPackage.replace('.', '/');
        HashSet<String> mixinList = new HashSet<String>();
        JSONArray mixins = object.optJSONArray("mixins");
        JSONArray client = object.optJSONArray("client");
        JSONArray server = object.optJSONArray("server");
        if (mixins != null) {
            for (Object o : mixins) {
                mixinList.add(o.toString().replace('.', '/'));
            }
        }
        if (client != null) {
            for (Object o : client) {
                mixinList.add(o.toString().replace('.', '/'));
            }
        }
        if (server != null) {
            for (Object o : server) {
                mixinList.add(o.toString().replace('.', '/'));
            }
        }
        return new MixinConfig(object.optBoolean("required", true), object.optString("minVersion"), mixinPackage, object.optString("target"), object.optString("compatibilityLevel"), Collections.unmodifiableCollection(mixinList), object.optInt("priority", 0), object.optBoolean("verbose", false), object.optString("refmap"), object.optBoolean("setSourceFile", false), Collections.<String>emptyList(), Collections.<String>emptyList());
    }

    protected MixinConfig(boolean required, @Nullable String minVersion, @NotNull String mixinPackage, @Nullable String target, @Nullable String compatibilityLevel, @NotNull Collection<String> mixins, int priority, boolean verbose, @Nullable String refmap, boolean setSourceFile, @NotNull Collection<String> client, @NotNull Collection<String> server) {
        this.required = required;
        this.minVersion = minVersion;
        this.mixinPackage = mixinPackage;
        this.target = target;
        this.compatibiltyLevel = compatibilityLevel;
        this.mixins = mixins;
        this.priority = priority;
        this.verbose = verbose;
        this.refmap = refmap;
        this.setSourceFile = setSourceFile;
        this.client = client;
        this.server = server;
    }

    public static class InvalidMixinConfigException
    extends Exception {
        private static final long serialVersionUID = 1708886499084998432L;

        public InvalidMixinConfigException(String message) {
            super(message);
        }
    }
}

