/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf.access;

import de.geolykt.starloader.deobf.access.AccessFlagModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
public final class AccessTransformInfo {
    @NotNull
    final List<AccessFlagModifier> modifiers = new ArrayList<AccessFlagModifier>();

    public List<AccessFlagModifier> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    public boolean apply(ClassNode node, boolean runtime) {
        boolean modified = false;
        block0: for (AccessFlagModifier mod : this.modifiers) {
            if (runtime && mod.isCompileOnly || !mod.clazz.equals(node.name)) continue;
            if (mod.type == AccessFlagModifier.Type.CLASS) {
                node.access = mod.apply(node.access);
                modified = true;
                continue;
            }
            if (mod.type == AccessFlagModifier.Type.METHOD) {
                for (MethodNode method : node.methods) {
                    if (!mod.name.get().equals(method.name) || !mod.descriptor.get().equals(method.desc)) continue;
                    method.access = mod.apply(method.access);
                    modified = true;
                    continue block0;
                }
                continue;
            }
            if (mod.type != AccessFlagModifier.Type.FIELD) continue;
            for (FieldNode field : node.fields) {
                if (!mod.name.get().equals(field.name) || !mod.descriptor.get().equals(field.desc)) continue;
                field.access = mod.apply(field.access);
                modified = true;
                continue block0;
            }
        }
        return modified;
    }

    public void apply(Map<String, ClassNode> nodes, Consumer<String> warnLogger) {
        HashMap<String, List> innerClasses = new HashMap<String, List>();
        for (AccessFlagModifier flag : this.modifiers) {
            boolean found;
            ClassNode node = nodes.get(flag.clazz);
            if (node == null) {
                warnLogger.accept("Cannot locate class: " + flag.clazz + " required by " + flag.toAccessWidenerString());
                continue;
            }
            if (flag.type == AccessFlagModifier.Type.CLASS) {
                node.access = flag.apply(node.access);
                for (InnerClassNode innerClassNode : node.innerClasses) {
                    if (!innerClassNode.name.equals(node.name)) continue;
                    innerClassNode.access = flag.apply(innerClassNode.access);
                    innerClasses.computeIfAbsent(node.name, key -> new ArrayList()).add(flag);
                }
                continue;
            }
            if (flag.type == AccessFlagModifier.Type.FIELD) {
                found = false;
                for (FieldNode field : node.fields) {
                    if (!field.name.equals(flag.name.get()) || !field.desc.equals(flag.descriptor.get())) continue;
                    found = true;
                    field.access = flag.apply(field.access);
                }
                if (found) continue;
                warnLogger.accept("Cannot find field required by access widener: " + flag.toAccessWidenerString());
                continue;
            }
            if (flag.type == AccessFlagModifier.Type.METHOD) {
                found = false;
                for (MethodNode method : node.methods) {
                    if (!method.name.equals(flag.name.get()) || !method.desc.equals(flag.descriptor.get())) continue;
                    found = true;
                    method.access = flag.apply(method.access);
                }
                if (found) continue;
                warnLogger.accept("Cannot find method required by access widener: " + flag.toAccessWidenerString());
                continue;
            }
            throw new IllegalStateException("Unkown type: " + Objects.toString((Object)flag.type));
        }
        if (!innerClasses.isEmpty()) {
            for (ClassNode node : nodes.values()) {
                for (InnerClassNode icn : node.innerClasses) {
                    List list = (List)innerClasses.get(icn.name);
                    if (list == null) continue;
                    for (AccessFlagModifier modifier : list) {
                        icn.access = modifier.apply(icn.access);
                    }
                }
            }
        }
    }
}

