/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf.access;

import java.util.Locale;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
public abstract class AccessFlagModifier {
    public final Type type;
    public final boolean isCompileOnly;
    public final String clazz;
    public final Optional<String> name;
    public final Optional<String> descriptor;

    public AccessFlagModifier(Type type, String clazz, Optional<String> name, Optional<String> descriptor, boolean compileOnly) {
        this.type = type;
        this.clazz = clazz;
        this.name = name;
        this.descriptor = descriptor;
        if (type == Type.CLASS) {
            if (name.isPresent() || descriptor.isPresent()) {
                throw new IllegalArgumentException("Neither name nor descriptor may be present for the CLASS type.");
            }
        } else if (!name.isPresent() || !descriptor.isPresent()) {
            throw new IllegalArgumentException("Both name and descriptor must be present for anything but the CLASS type.");
        }
        this.isCompileOnly = compileOnly;
    }

    public abstract int apply(int var1);

    public abstract String toAccessWidenerString();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static enum Type {
        CLASS,
        METHOD,
        FIELD;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static class RemoveFlagModifier
    extends AccessFlagModifier {
        private final int flag;
        private final String awMode;

        public RemoveFlagModifier(Type type, String clazz, Optional<String> name, Optional<String> descriptor, int flag, String awMode, boolean compileOnly) {
            super(type, clazz, name, descriptor, compileOnly);
            this.flag = flag;
            this.awMode = awMode;
        }

        @Override
        public int apply(int oldAccessFlag) {
            return oldAccessFlag & ~this.flag;
        }

        @Override
        public String toAccessWidenerString() {
            if (this.type == Type.CLASS) {
                return this.awMode + " class " + this.clazz;
            }
            return String.format("%s %s %s %s %s", this.awMode, this.type.toString(), this.clazz, this.name.get(), this.descriptor.get());
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static class ExtendableModifier
    extends AccessFlagModifier {
        public ExtendableModifier(Type type, String clazz, Optional<String> name, Optional<String> descriptor, boolean compileOnly) {
            super(type, clazz, name, descriptor, compileOnly);
        }

        @Override
        public int apply(int oldAccessFlag) {
            int flag = oldAccessFlag & 0xFFFFFFFD & 0xFFFFFFEF;
            if ((flag & 1) == 0) {
                return flag | 4;
            }
            return flag;
        }

        @Override
        public String toAccessWidenerString() {
            if (this.type == Type.CLASS) {
                return "extendable class " + this.clazz;
            }
            return String.format("extendable %s %s %s %s", this.type.toString(), this.clazz, this.name.get(), this.descriptor.get());
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static class AccessibleModifier
    extends AccessFlagModifier {
        public AccessibleModifier(Type type, String clazz, Optional<String> name, Optional<String> descriptor, boolean compileOnly) {
            super(type, clazz, name, descriptor, compileOnly);
        }

        @Override
        public int apply(int oldAccessFlag) {
            return oldAccessFlag & 0xFFFFFFFD & 0xFFFFFFFB | 1;
        }

        @Override
        public String toAccessWidenerString() {
            if (this.type == Type.CLASS) {
                return "accessible class " + this.clazz;
            }
            return String.format("accessible %s %s %s %s", this.type.toString(), this.clazz, this.name.get(), this.descriptor.get());
        }
    }
}

