/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.logging;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.stianloader.picoresolve.logging.JULLogAdapter;
import org.stianloader.picoresolve.logging.SLF4JLogAdapter;

public abstract class LoggingAdapter {
    @NotNull
    static LoggingAdapter currentInstance;

    @NotNull
    public static LoggingAdapter getDefaultLogger() {
        return currentInstance;
    }

    public static void setDefaultLogger(@NotNull LoggingAdapter instance) {
        currentInstance = Objects.requireNonNull(instance);
    }

    public abstract void debug(Class<?> var1, String var2, Object ... var3);

    public abstract void error(Class<?> var1, String var2, Object ... var3);

    public abstract void info(Class<?> var1, String var2, Object ... var3);

    public abstract void warn(Class<?> var1, String var2, Object ... var3);

    static {
        LoggingAdapter instance;
        try {
            Class.forName("org.slf4j.LoggerFactory");
            instance = new SLF4JLogAdapter();
        }
        catch (ClassNotFoundException | NoClassDefFoundError expected) {
            instance = new JULLogAdapter();
        }
        currentInstance = instance;
    }
}

