/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.stianloader.picoresolve.version.MavenVersion;

public final class GAV {
    @NotNull
    private final String artifact;
    @NotNull
    private final String group;
    @NotNull
    private final MavenVersion version;

    public GAV(@NotNull String group, @NotNull String artifact, @NotNull MavenVersion version) {
        this.group = group;
        this.artifact = artifact;
        this.version = version;
    }

    @NotNull
    @Contract(pure=true)
    public String artifact() {
        return this.artifact;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GAV) {
            GAV other = (GAV)obj;
            return other.group.equals(this.group) && other.artifact.equals(this.artifact) && other.version.equals(this.version);
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public String group() {
        return this.group;
    }

    public int hashCode() {
        return Objects.hash(this.group, this.artifact, this.version);
    }

    @NotNull
    @Contract(pure=true)
    public MavenVersion version() {
        return this.version;
    }

    public String toString() {
        return this.group + ":" + this.artifact + ":" + this.version.getOriginText();
    }
}

