/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.launcher.service;

import de.geolykt.starloader.launcher.service.SLMixinLogger;
import de.geolykt.starloader.util.JavaInterop;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.minestom.server.extras.selfmodification.MinestomRootClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.launch.platform.container.ContainerHandleVirtual;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.service.IClassProvider;
import org.spongepowered.asm.service.IClassTracker;
import org.spongepowered.asm.service.IMixinAuditTrail;
import org.spongepowered.asm.service.IMixinInternal;
import org.spongepowered.asm.service.ITransformerProvider;
import org.spongepowered.asm.service.MixinServiceAbstract;
import org.spongepowered.asm.util.IConsumer;

public class SLMixinService
extends MixinServiceAbstract {
    private static final MinestomRootClassLoader CLASSLOADER = MinestomRootClassLoader.getInstance();
    private static SLMixinService instance;
    private final IClassBytecodeProvider bytecodeProvider = new IClassBytecodeProvider(){

        @Override
        public ClassNode getClassNode(String name) throws ClassNotFoundException, IOException {
            return this.getClassNode(name, false);
        }

        @Override
        public ClassNode getClassNode(String name, boolean runTransformers) throws ClassNotFoundException, IOException {
            return this.getClassNode(name, runTransformers, 0);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public ClassNode getClassNode(String name, boolean runTransformers, int readerFlags) throws ClassNotFoundException, IOException {
            Exception causedBy;
            ArrayList<Exception> caughtExceptions = new ArrayList<Exception>();
            @NotNull Callable[] suppliers = new Callable[4];
            int i = 0;
            int systemClassLoaderIndex = JavaInterop.isJava9() || CLASSLOADER.isProtected(name) ? i++ : suppliers.length - 1;
            suppliers[systemClassLoaderIndex] = () -> {
                ClassLoader cl = JavaInterop.getPlatformClassLoader();
                InputStream is = cl == null ? ClassLoader.getSystemResourceAsStream(name.replace('.', '/') + ".class") : cl.getResourceAsStream(name.replace('.', '/') + ".class");
                return new ClassReader(is);
            };
            suppliers[i++] = () -> new ClassReader(CLASSLOADER.loadClassBytes(name, false).getBytes());
            suppliers[i++] = () -> new ClassReader(CLASSLOADER.loadBytesWithChildren(name, false));
            suppliers[i++] = () -> new ClassReader(CLASSLOADER.getResourceAsStream(name.replace('.', '/') + ".class"));
            for (Callable supplier : suppliers) {
                try {
                    ClassReader reader = (ClassReader)supplier.call();
                    ClassNode node = new ClassNode();
                    reader.accept(node, readerFlags);
                    return node;
                }
                catch (Exception e) {
                    caughtExceptions.add(e);
                }
            }
            ListIterator it = caughtExceptions.listIterator(caughtExceptions.size());
            if (it.hasPrevious()) {
                causedBy = (Exception)it.previous();
                while (it.hasPrevious()) {
                    causedBy.addSuppressed((Throwable)it.previous());
                }
            } else {
                causedBy = null;
            }
            ClassNotFoundException thrownException = new ClassNotFoundException("Could not load ClassNode with name " + name, causedBy);
            if (MinestomRootClassLoader.DEBUG) {
                thrownException.fillInStackTrace();
                LoggerFactory.getLogger(SLMixinService.class).warn("Unable to call #getClassNode(): Couldn't load ClassNode for class with name '{}'.", (Object)name, (Object)thrownException);
            }
            throw thrownException;
        }
    };
    private final IClassProvider classprovider = new IClassProvider(){

        @Override
        public Class<?> findAgentClass(String name, boolean initialize) throws ClassNotFoundException {
            return this.findAgentClass(name, initialize);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return CLASSLOADER.findClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                if (MinestomRootClassLoader.DEBUG) {
                    LoggerFactory.getLogger(SLMixinService.class).warn("#findClass(String): Unable to find class '{}'", (Object)name, (Object)cnfe);
                }
                throw cnfe;
            }
        }

        @Override
        public Class<?> findClass(String name, boolean initialize) throws ClassNotFoundException {
            try {
                return Class.forName(name, initialize, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    return Class.forName(name, initialize, SLMixinService.class.getClassLoader());
                }
                catch (ClassNotFoundException cnfe2) {
                    cnfe2.addSuppressed(cnfe);
                    if (MinestomRootClassLoader.DEBUG) {
                        LoggerFactory.getLogger(SLMixinService.class).warn("#findClass(String, boolean): Unable to find class '{}'", (Object)name, (Object)cnfe2);
                    }
                    throw cnfe2;
                }
            }
        }

        @Override
        public URL[] getClassPath() {
            return CLASSLOADER.getURLs();
        }
    };
    private IConsumer<MixinEnvironment.Phase> wiredPhaseConsumer;

    public static SLMixinService getInstance() {
        return instance;
    }

    @Override
    protected ILogger createLogger(String name) {
        return new SLMixinLogger(Objects.requireNonNull(name, "logger may not have a null name"));
    }

    @Override
    public IMixinAuditTrail getAuditTrail() {
        return null;
    }

    @Override
    public IClassBytecodeProvider getBytecodeProvider() {
        return this.bytecodeProvider;
    }

    @Override
    public IClassProvider getClassProvider() {
        return this.classprovider;
    }

    @Override
    public IClassTracker getClassTracker() {
        return null;
    }

    @Nullable
    public final <T extends IMixinInternal> T getMixinInternal(Class<T> type) {
        return this.getInternal(type);
    }

    @Override
    public String getName() {
        return "Starloader Bootstrap";
    }

    public IConsumer<MixinEnvironment.Phase> getPhaseConsumer() {
        return this.wiredPhaseConsumer;
    }

    @Override
    public Collection<String> getPlatformAgents() {
        return Arrays.asList("de.geolykt.starloader.launcher.service.SLPlattformAgent");
    }

    @Override
    public IContainerHandle getPrimaryContainer() {
        return new ContainerHandleVirtual(this.getName());
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return CLASSLOADER.getResourceAsStreamWithChildren(Objects.requireNonNull(name, "name may not be null"));
    }

    @Override
    public ITransformerProvider getTransformerProvider() {
        return null;
    }

    @Override
    public void init() {
        instance = this;
        super.init();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Deprecated
    public void unwire() {
        super.unwire();
        this.wiredPhaseConsumer = null;
    }

    @Override
    @Deprecated
    public void wire(MixinEnvironment.Phase phase, IConsumer<MixinEnvironment.Phase> phaseConsumer) {
        super.wire(phase, phaseConsumer);
        this.wiredPhaseConsumer = phaseConsumer;
    }
}

