/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.selectors.constant;

import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.stianloader.micromixin.transform.internal.annotation.ConstantSelector;

public class DoubleConstantSelector
extends ConstantSelector {
    private final double value;

    public DoubleConstantSelector(double value) {
        this.value = value;
    }

    @Override
    public boolean matchesConstant(@NotNull AbstractInsnNode insn) {
        if (insn instanceof InsnNode) {
            return insn.getOpcode() == 14 && this.value == 0.0 || insn.getOpcode() == 15 && this.value == 1.0;
        }
        if (insn instanceof LdcInsnNode) {
            return ((LdcInsnNode)insn).cst instanceof Double && (Double)((LdcInsnNode)insn).cst == this.value;
        }
        return false;
    }
}

