/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.api.SlicedInjectionPointSelector;

public abstract class InjectionPointSelector {
    @NotNull
    public final String fullyQualifiedName;
    @NotNull
    public final Set<String> allNames;

    public InjectionPointSelector(@NotNull String fqn, @NotNull Collection<String> allNames) {
        this.fullyQualifiedName = fqn;
        HashSet<String> names = new HashSet<String>(allNames);
        names.add(fqn);
        this.allNames = Collections.unmodifiableSet(names);
    }

    public InjectionPointSelector(@NotNull String fqn, String ... aliases) {
        this(fqn, Arrays.asList(aliases));
    }

    @Nullable
    public abstract AbstractInsnNode getFirstInsn(@NotNull MethodNode var1, @Nullable SlicedInjectionPointSelector var2, @Nullable SlicedInjectionPointSelector var3, @NotNull SimpleRemapper var4, @NotNull StringBuilder var5);

    @NotNull
    public abstract Collection<? extends AbstractInsnNode> getMatchedInstructions(@NotNull MethodNode var1, @Nullable SlicedInjectionPointSelector var2, @Nullable SlicedInjectionPointSelector var3, @NotNull SimpleRemapper var4, @NotNull StringBuilder var5);

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.OverrideOnly
    public boolean supportsRedirect() {
        return true;
    }
}

