/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.stianloader.picoresolve.VersionlessDependency;
import org.stianloader.picoresolve.exclusion.Exclusion;
import org.stianloader.picoresolve.exclusion.ExclusionContainer;

class DependencyManagementTree {
    @NotNull
    public static final DependencyManagementTree EMPTY = new DependencyManagementTree();
    @NotNull
    private final List<DependencyManagementTree> imported = new ArrayList<DependencyManagementTree>();
    @NotNull
    private final Map<VersionlessDependency, DependencyManagementNode> nodes = new ConcurrentHashMap<VersionlessDependency, DependencyManagementNode>();
    private DependencyManagementTree parent;

    DependencyManagementTree() {
    }

    public void addImportNode(DependencyManagementTree node) {
        this.imported.add(node);
    }

    public void addNode(VersionlessDependency dep, DependencyManagementNode node) {
        this.nodes.put(dep, node);
    }

    public void setParent(@NotNull DependencyManagementTree parent) {
        if (this == EMPTY) {
            return;
        }
        this.parent = parent;
    }

    private boolean collectNodes0(Map<VersionlessDependency, DependencyManagementNode> out, int depth) {
        if (depth-- == 0) {
            for (Map.Entry<VersionlessDependency, DependencyManagementNode> entry : this.nodes.entrySet()) {
                out.putIfAbsent(entry.getKey(), entry.getValue());
            }
            return this.imported.isEmpty();
        }
        boolean empty = true;
        for (DependencyManagementTree importTree : this.imported) {
            empty &= importTree.collectNodes0(out, depth);
        }
        return empty;
    }

    public void collectNodes(Map<VersionlessDependency, DependencyManagementNode> out) {
        int depth = 0;
        while (!this.collectNodes0(out, depth)) {
            ++depth;
        }
        if (this.parent != null) {
            this.parent.collectNodes(out);
        }
    }

    static class DependencyManagementNode {
        final String scope;
        final String range;
        final ExclusionContainer<Exclusion> exclusions;

        public DependencyManagementNode(String scope, String range, ExclusionContainer<Exclusion> exclusions) {
            this.scope = scope;
            this.range = range;
            this.exclusions = exclusions;
        }
    }
}

