/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.stianloader.micromixin.transform.api.MixinLoggingFacade;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.internal.MixinMethodStub;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.annotation.AbstractOverlayAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinShadowAnnotation;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;

public final class MixinOverwriteAnnotation
extends AbstractOverlayAnnotation<MixinMethodStub> {
    @Nullable
    private final List<String> aliases;
    @ApiStatus.Internal
    private boolean naggedInvalidAlias;

    private MixinOverwriteAnnotation(@Nullable List<String> aliases, @NotNull MixinLoggingFacade logger) {
        super(logger);
        this.aliases = aliases;
    }

    @NotNull
    public static MixinOverwriteAnnotation generateImplicit(@NotNull ClassNode node, @NotNull MethodNode method, @NotNull MixinLoggingFacade logger) throws MixinParseException {
        if ((method.access & 9) == 9) {
            throw new MixinParseException("The handler method " + node.name + "." + method.name + method.desc + ", which is implicitly an @Overwrite-annotated method, is public and static. Mixin however does not support both access modifiers existing at the same time. So instead explicitly define it as a @Overwrite-annotated method or use @Unique if the intention to overwrite a method is not there.");
        }
        return new MixinOverwriteAnnotation(null, logger);
    }

    @NotNull
    public static MixinOverwriteAnnotation parse(@NotNull ClassNode node, @NotNull MethodNode method, @NotNull AnnotationNode annot, @NotNull MixinLoggingFacade logger) throws MixinParseException {
        List aliases = null;
        if (annot.values != null) {
            for (int i = 0; i < annot.values.size(); i += 2) {
                List aval;
                String name = (String)annot.values.get(i);
                Object val = annot.values.get(i + 1);
                if (!name.equals("aliases")) {
                    throw new MixinParseException("Unimplemented key in @Overwrite: " + name);
                }
                aliases = aval = (List)val;
            }
        }
        return new MixinOverwriteAnnotation(aliases, logger);
    }

    @Override
    public boolean handleCollision(@NotNull MixinMethodStub source, @NotNull ClassNode target, int access) {
        if ((access & 9) == 9 && this.aliases != null) {
            throw new IllegalStateException("The handler method " + source.owner.name + "." + source.getName() + source.getDesc() + " targets a method in " + target.name + ". As the handler specified aliases and the targetted method is public and static, an overwrite is no possible. Instead explicitly use @Overwrite for the target or manually transform that method through the plattform's supported transformation API.");
        }
        if ((source.getAccess() & 8) == 0) {
            if ((access & 8) != 0) {
                throw new IllegalStateException("The handler method " + source.owner.name + "." + source.getName() + source.getDesc() + ", which targets a member in " + target.name + ", is not static, but the targetted member is static. Consider making the handler static (should it be possible without dealing with other limitations of @Overwrite).");
            }
        } else if ((access & 8) == 0) {
            throw new IllegalStateException("The handler method " + source.owner.name + "." + source.getName() + source.getDesc() + ", which targets a member in " + target.name + ", is static, but the targetted member is not static. Consider making the handler not static or readjust the targetted method.");
        }
        if (ASMUtil.hasReducedAccess(access, source.getAccess())) {
            throw new IllegalStateException("The handler method " + source.owner.name + "." + source.getName() + source.getDesc() + ", which targets a member in " + target.name + ", has a lesser access modifier than the method it targets. Try to keep the access flags the same across both methods.");
        }
        if ((access & 2) == 0 && this.aliases != null && !this.aliases.isEmpty() && !this.naggedInvalidAlias) {
            this.naggedInvalidAlias = true;
            this.logger.warn(MixinShadowAnnotation.class, "The @Overwrite annotated member {}.{} {} defines an alias for a non-private method. While this behaviour is supported in micromixin-transformer, it isn't supported in the spongeian mixin implementation. This may represent a compatibility hazard. For more information, see the javadocs on aliases for the Overwrite annotation. Note that the access modifier of your mixin member is not of relevance, just the modifier of the member that is being aliased.", source.getOwner().name, source.getName(), source.getDesc());
        }
        return true;
    }

    @Override
    @NotNull
    public String getDesiredName(@NotNull MixinMethodStub source, @NotNull ClassNode target, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        List<String> aliases = this.aliases;
        if (aliases == null) {
            return source.getName();
        }
        String desiredDesc = remapper.getRemappedMethodDescriptor(source.getDesc(), sharedBuilder);
        for (MethodNode method : target.methods) {
            if (!method.desc.equals(desiredDesc)) continue;
            if (method.name.equals(source.getName())) {
                return source.getName();
            }
            for (String alias : aliases) {
                if (!alias.equals(method.name)) continue;
                return alias;
            }
        }
        throw new IllegalStateException("Unable to find the method defined by the aliases specified by the @Overwrite-annotation on " + source.getOwner().name + "." + source.getName() + source.getDesc() + ". The targetted method should be within " + target.name);
    }
}

